/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.places.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import com.facebook.internal.Validate;
import com.facebook.places.internal.LocationPackageRequestParams;
import com.facebook.places.internal.ScannerException;
import com.facebook.places.internal.WifiScanResult;
import com.facebook.places.internal.WifiScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WifiScannerImpl
implements WifiScanner {
    private static final String SSID_NOMAP = "_nomap";
    private static final String SSID_OPTOUT = "_optout";
    private Context context;
    private WifiManager wifiManager;
    private ScanResultBroadcastReceiver broadcastReceiver;
    private final Object scanLock = new Object();
    private final LocationPackageRequestParams params;

    WifiScannerImpl(Context context, LocationPackageRequestParams params) {
        this.context = context;
        this.params = params;
    }

    @Override
    public void initAndCheckEligibility() throws ScannerException {
        boolean isWifiScanningAlwaysOn;
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.wifi")) {
            throw new ScannerException(ScannerException.Type.NOT_SUPPORTED);
        }
        if (!Validate.hasWiFiPermission((Context)this.context)) {
            throw new ScannerException(ScannerException.Type.PERMISSION_DENIED);
        }
        if (this.wifiManager == null) {
            this.wifiManager = (WifiManager)this.context.getSystemService("wifi");
        }
        if (!(isWifiScanningAlwaysOn = this.isWifiScanningAlwaysOn()) && !this.wifiManager.isWifiEnabled()) {
            throw new ScannerException(ScannerException.Type.DISABLED);
        }
    }

    @Override
    public WifiScanResult getConnectedWifi() throws ScannerException {
        try {
            WifiInfo wifiInfo = this.wifiManager.getConnectionInfo();
            if (wifiInfo == null || TextUtils.isEmpty((CharSequence)wifiInfo.getBSSID()) || wifiInfo.getSupplicantState() != SupplicantState.COMPLETED || WifiScannerImpl.isWifiSsidBlacklisted(wifiInfo.getSSID())) {
                return null;
            }
            WifiScanResult wifiScanResult = new WifiScanResult();
            wifiScanResult.bssid = wifiInfo.getBSSID();
            wifiScanResult.ssid = wifiInfo.getSSID();
            wifiScanResult.rssi = wifiInfo.getRssi();
            wifiScanResult.timestampMs = SystemClock.elapsedRealtime();
            if (Build.VERSION.SDK_INT >= 21) {
                wifiScanResult.frequency = wifiInfo.getFrequency();
            }
            return wifiScanResult;
        }
        catch (Exception e) {
            throw new ScannerException(ScannerException.Type.UNKNOWN_ERROR, e);
        }
    }

    @Override
    public boolean isWifiScanningEnabled() {
        try {
            this.initAndCheckEligibility();
            if (Validate.hasLocationPermission((Context)this.context)) {
                return true;
            }
        }
        catch (ScannerException scannerException) {
            // empty catch block
        }
        return false;
    }

    private boolean isWifiScanningAlwaysOn() {
        if (Build.VERSION.SDK_INT >= 18) {
            return this.wifiManager.isScanAlwaysAvailable();
        }
        return false;
    }

    private List<WifiScanResult> getCachedScanResults() throws ScannerException {
        try {
            List<ScanResult> scanResults = this.wifiManager.getScanResults();
            scanResults = WifiScannerImpl.filterWifiScanResultsByMaxAge(scanResults, this.params.getWifiScanMaxAgeMs());
            WifiScannerImpl.filterResults(scanResults, this.params.getWifiMaxScanResults());
            ArrayList<WifiScanResult> wifiScanResults = new ArrayList<WifiScanResult>(scanResults.size());
            for (ScanResult scanResult : scanResults) {
                if (WifiScannerImpl.isWifiSsidBlacklisted(scanResult.SSID)) continue;
                WifiScanResult wifiScanResult = new WifiScanResult();
                wifiScanResult.bssid = scanResult.BSSID;
                wifiScanResult.ssid = scanResult.SSID;
                wifiScanResult.rssi = scanResult.level;
                wifiScanResult.frequency = scanResult.frequency;
                wifiScanResult.timestampMs = Build.VERSION.SDK_INT >= 17 ? TimeUnit.MICROSECONDS.toMillis(scanResult.timestamp) : SystemClock.elapsedRealtime();
                wifiScanResults.add(wifiScanResult);
            }
            return wifiScanResults;
        }
        catch (Exception e) {
            throw new ScannerException(ScannerException.Type.UNKNOWN_ERROR, e);
        }
    }

    private static boolean isWifiSsidBlacklisted(String ssid) {
        return ssid != null && (ssid.endsWith(SSID_NOMAP) || ssid.contains(SSID_OPTOUT));
    }

    private static void filterResults(List<ScanResult> scanResults, int maxResults) {
        if (scanResults.size() > maxResults) {
            Comparator<ScanResult> comparator = new Comparator<ScanResult>(){

                @Override
                public int compare(ScanResult lhs, ScanResult rhs) {
                    return rhs.level - lhs.level;
                }
            };
            Collections.sort(scanResults, comparator);
            scanResults.subList(maxResults, scanResults.size()).clear();
        }
    }

    private static List<ScanResult> filterWifiScanResultsByMaxAge(List<ScanResult> scanResults, long maxAgeMs) {
        ArrayList<ScanResult> filtered = new ArrayList<ScanResult>();
        if (scanResults != null) {
            if (Build.VERSION.SDK_INT < 17) {
                filtered.addAll(scanResults);
            } else {
                long nowSinceBootMs = SystemClock.elapsedRealtime();
                for (ScanResult result : scanResults) {
                    long ageMs = nowSinceBootMs - result.timestamp / 1000L;
                    if (ageMs < 0L) {
                        ageMs = System.currentTimeMillis() - result.timestamp;
                    }
                    if (ageMs >= maxAgeMs) continue;
                    filtered.add(result);
                }
            }
        }
        return filtered;
    }

    @Override
    public synchronized List<WifiScanResult> getWifiScans() throws ScannerException {
        boolean isListEmpty;
        List<WifiScanResult> wifiScanResults = null;
        if (!this.params.isWifiActiveScanForced()) {
            wifiScanResults = this.getCachedScanResults();
        }
        boolean bl = isListEmpty = wifiScanResults == null || wifiScanResults.isEmpty();
        if (this.params.isWifiActiveScanForced() || this.params.isWifiActiveScanAllowed() && isListEmpty) {
            wifiScanResults = this.getActiveScanResults();
        }
        return wifiScanResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WifiScanResult> getActiveScanResults() throws ScannerException {
        List<WifiScanResult> wifiScanResults;
        block9: {
            wifiScanResults = null;
            try {
                if (!Validate.hasChangeWifiStatePermission((Context)this.context)) break block9;
                this.registerBroadcastReceiver();
                boolean isScanStarted = this.wifiManager.startScan();
                if (!isScanStarted) break block9;
                try {
                    Object object = this.scanLock;
                    synchronized (object) {
                        this.scanLock.wait(this.params.getWifiScanTimeoutMs());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                wifiScanResults = this.getCachedScanResults();
            }
            catch (Exception exception) {
            }
            finally {
                this.unregisterBroadcastReceiver();
            }
        }
        return wifiScanResults;
    }

    private void registerBroadcastReceiver() {
        if (this.broadcastReceiver != null) {
            this.unregisterBroadcastReceiver();
        }
        this.broadcastReceiver = new ScanResultBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.wifi.SCAN_RESULTS");
        this.context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, intentFilter);
    }

    private void unregisterBroadcastReceiver() {
        if (this.broadcastReceiver != null) {
            try {
                this.context.unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broadcastReceiver = null;
        }
    }

    private class ScanResultBroadcastReceiver
    extends BroadcastReceiver {
        private ScanResultBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (intent != null && "android.net.wifi.SCAN_RESULTS".equals(intent.getAction())) {
                Object object = WifiScannerImpl.this.scanLock;
                synchronized (object) {
                    WifiScannerImpl.this.scanLock.notify();
                }
                WifiScannerImpl.this.unregisterBroadcastReceiver();
            }
        }
    }
}

