/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.places.internal;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.HandlerThread;
import com.facebook.internal.Validate;
import com.facebook.places.internal.LocationPackageRequestParams;
import com.facebook.places.internal.LocationScanner;
import com.facebook.places.internal.ScannerException;
import java.util.ArrayList;
import java.util.List;

public class LocationScannerImpl
implements LocationScanner,
LocationListener {
    private static final long MIN_TIME_BETWEEN_UPDATES = 100L;
    private static final float MIN_DISTANCE_BETWEEN_UPDATES = 0.0f;
    private Context context;
    private LocationManager locationManager;
    private LocationPackageRequestParams params;
    private Location freshLocation;
    private final Object scanLock = new Object();
    private List<String> enabledProviders;

    public LocationScannerImpl(Context context, LocationPackageRequestParams params) {
        this.context = context;
        this.params = params;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    @Override
    public void initAndCheckEligibility() throws ScannerException {
        if (!Validate.hasLocationPermission((Context)this.context)) {
            throw new ScannerException(ScannerException.Type.PERMISSION_DENIED);
        }
        this.enabledProviders = new ArrayList<String>(this.params.getLocationProviders().length);
        for (String provider : this.params.getLocationProviders()) {
            if (!this.locationManager.isProviderEnabled(provider)) continue;
            this.enabledProviders.add(provider);
        }
        if (this.enabledProviders.isEmpty()) {
            throw new ScannerException(ScannerException.Type.DISABLED);
        }
    }

    private Location getLastLocation(String provider) {
        Location lastLocation = this.locationManager.getLastKnownLocation(provider);
        if (lastLocation != null) {
            long lastLocationTs = lastLocation.getTime();
            long locationAgeMs = System.currentTimeMillis() - lastLocationTs;
            if (locationAgeMs < this.params.getLastLocationMaxAgeMs()) {
                return lastLocation;
            }
        }
        return null;
    }

    @Override
    public Location getLocation() throws ScannerException {
        for (String provider : this.enabledProviders) {
            Location lastLocation = this.getLastLocation(provider);
            if (lastLocation == null) continue;
            return lastLocation;
        }
        return this.getFreshLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getFreshLocation() throws ScannerException {
        this.freshLocation = null;
        HandlerThread handlerThread = new HandlerThread("LocationScanner");
        try {
            handlerThread.start();
            for (String provider : this.enabledProviders) {
                this.locationManager.requestLocationUpdates(provider, 100L, 0.0f, (LocationListener)this, handlerThread.getLooper());
            }
            try {
                Object object = this.scanLock;
                synchronized (object) {
                    this.scanLock.wait(this.params.getLocationRequestTimeoutMs());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.locationManager.removeUpdates((LocationListener)this);
            handlerThread.quit();
        }
        if (this.freshLocation == null) {
            throw new ScannerException(ScannerException.Type.TIMEOUT);
        }
        return this.freshLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocationChanged(Location location) {
        if (this.freshLocation == null && location.getAccuracy() < this.params.getLocationMaxAccuracyMeters()) {
            Object object = this.scanLock;
            synchronized (object) {
                this.freshLocation = location;
                this.scanLock.notify();
            }
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }
}

