/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices.cloudgaming.internal;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.FacebookRequestError;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class SDKLogger {
    private static SDKLogger instance;
    private final InternalAppEventsLogger logger;
    private String appID = null;
    private String userID = null;
    private String sessionID = null;
    private ConcurrentHashMap<String, String> requestIDToFunctionTypeMap;

    private SDKLogger(Context context) {
        this.logger = new InternalAppEventsLogger(context);
        this.requestIDToFunctionTypeMap = new ConcurrentHashMap();
    }

    public static synchronized SDKLogger getInstance(Context context) {
        if (instance == null) {
            instance = new SDKLogger(context);
        }
        return instance;
    }

    public static void logInternalError(Context context, SDKMessageEnum functionType, Exception e) {
        SDKLogger.getInstance(context).logInternalError(functionType, e);
    }

    public void logPreparingRequest(String functionType, String requestID, JSONObject payloads) {
        Bundle parameters = this.getParametersWithRequestIDAndFunctionType(requestID, functionType);
        parameters.putString("payload", payloads.toString());
        this.logger.logEventImplicitly("cloud_games_preparing_request", parameters);
    }

    public void logSentRequest(String functionType, String requestID, JSONObject payloads) {
        Bundle parameters = this.getParametersWithRequestIDAndFunctionType(requestID, functionType);
        this.requestIDToFunctionTypeMap.put(requestID, functionType);
        parameters.putString("payload", payloads.toString());
        this.logger.logEventImplicitly("cloud_games_sent_request", parameters);
    }

    public void logSendingSuccessResponse(String requestID) {
        Bundle parameters = this.getParametersWithRequestIDAndFunctionType(requestID);
        this.logger.logEventImplicitly("cloud_games_sending_success_response", parameters);
    }

    public void logSendingErrorResponse(FacebookRequestError error, @Nullable String requestID) {
        Bundle parameters = this.getParametersWithRequestIDAndFunctionType(requestID);
        parameters.putString("error_code", Integer.toString(error.getErrorCode()));
        parameters.putString("error_type", error.getErrorType());
        parameters.putString("error_message", error.getErrorMessage());
        this.logger.logEventImplicitly("cloud_games_sending_error_response", parameters);
    }

    public void logLoginSuccess() {
        Bundle parameters = this.getInitParameters();
        this.logger.logEventImplicitly("cloud_games_login_success", parameters);
    }

    public void logGameLoadComplete() {
        Bundle parameters = this.getInitParameters();
        this.logger.logEventImplicitly("cloud_games_load_complete", parameters);
    }

    public void logInternalError(SDKMessageEnum functionType, Exception e) {
        Bundle parameters = this.getInitParameters();
        parameters.putString("function_type", functionType.toString());
        parameters.putString("error_type", e.getClass().getName());
        parameters.putString("error_message", e.getMessage());
        this.logger.logEventImplicitly("cloud_games_internal_error", parameters);
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    private Bundle getParametersWithRequestIDAndFunctionType(@Nullable String requestID) {
        Bundle parameters = this.getInitParameters();
        if (requestID != null) {
            String functionType = this.requestIDToFunctionTypeMap.getOrDefault(requestID, null);
            parameters.putString("request_id", requestID);
            if (functionType != null) {
                parameters.putString("function_type", functionType);
                this.requestIDToFunctionTypeMap.remove(requestID);
            }
        }
        return parameters;
    }

    private Bundle getParametersWithRequestIDAndFunctionType(String requestID, String functionType) {
        Bundle parameters = this.getInitParameters();
        parameters.putString("request_id", requestID);
        parameters.putString("function_type", functionType);
        return parameters;
    }

    private Bundle getInitParameters() {
        Bundle parameters = new Bundle();
        if (this.appID != null) {
            parameters.putString("app_id", this.appID);
        }
        if (this.sessionID != null) {
            parameters.putString("session_id", this.sessionID);
        }
        return parameters;
    }
}

