/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.facebook.gamingservices.GamingContext;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GamingPayload {
    private static final String TAG = GamingPayload.class.getSimpleName();
    private static final String KEY_CONTEXT_TOKEN_ID = "context_token_id";
    private static final String KEY_GAME_REQUEST_ID = "game_request_id";
    private static final String KEY_PAYLOAD = "payload";
    private static final String KEY_APPLINK_DATA = "al_applink_data";
    private static final String KEY_EXTRAS = "extras";
    private static final String KEY_TOURNAMENT_ID = "tournament_id";
    private static Map<String, String> payloadData;

    private GamingPayload() {
    }

    @Nullable
    public static String getGameRequestID() {
        if (payloadData == null) {
            return null;
        }
        if (payloadData.containsKey(KEY_GAME_REQUEST_ID)) {
            return payloadData.get(KEY_GAME_REQUEST_ID);
        }
        return null;
    }

    @Nullable
    public static String getPayload() {
        if (payloadData == null) {
            return null;
        }
        if (payloadData.containsKey(KEY_PAYLOAD)) {
            return payloadData.get(KEY_PAYLOAD);
        }
        return null;
    }

    @Nullable
    public static String getTournamentId() {
        if (payloadData == null) {
            return null;
        }
        if (payloadData.containsKey(KEY_TOURNAMENT_ID)) {
            return payloadData.get(KEY_TOURNAMENT_ID);
        }
        return null;
    }

    public static void loadPayloadFromCloudGame(String payloadString) {
        HashMap<String, String> loadedPayload = new HashMap<String, String>();
        try {
            JSONObject payloadJSON = new JSONObject(payloadString);
            loadedPayload.put(KEY_GAME_REQUEST_ID, payloadJSON.optString(KEY_GAME_REQUEST_ID));
            loadedPayload.put(KEY_PAYLOAD, payloadJSON.optString(KEY_PAYLOAD));
            loadedPayload.put(KEY_TOURNAMENT_ID, payloadJSON.optString(KEY_TOURNAMENT_ID));
            payloadData = loadedPayload;
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.toString(), (Throwable)e);
        }
    }

    public static void loadPayloadFromIntent(Intent intent) {
        Bundle appLinkData;
        Bundle appLinkExtras;
        HashMap<String, String> loadedPayload = new HashMap<String, String>();
        if (intent == null) {
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras != null && extras.containsKey(KEY_APPLINK_DATA) && (appLinkExtras = (appLinkData = extras.getBundle(KEY_APPLINK_DATA)).getBundle(KEY_EXTRAS)) != null) {
            String gameRequestId = appLinkExtras.getString(KEY_GAME_REQUEST_ID);
            String payload = appLinkExtras.getString(KEY_PAYLOAD);
            String contextTokenId = appLinkExtras.getString(KEY_CONTEXT_TOKEN_ID);
            String tournamentId = appLinkExtras.getString(KEY_TOURNAMENT_ID);
            if (contextTokenId != null) {
                GamingContext.setCurrentGamingContext(new GamingContext(contextTokenId));
            }
            loadedPayload.put(KEY_GAME_REQUEST_ID, gameRequestId);
            loadedPayload.put(KEY_PAYLOAD, payload);
            loadedPayload.put(KEY_TOURNAMENT_ID, tournamentId);
            payloadData = loadedPayload;
        }
    }
}

