/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.net.Uri;
import com.facebook.FacebookSdk;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Validate;
import java.util.Locale;

public class ImageRequest {
    public static final int UNSPECIFIED_DIMENSION = 0;
    private static final String PATH = "%s/%s/picture";
    private static final String HEIGHT_PARAM = "height";
    private static final String WIDTH_PARAM = "width";
    private static final String MIGRATION_PARAM = "migration_overrides";
    private static final String MIGRATION_VALUE = "{october_2012:true}";
    private Context context;
    private Uri imageUri;
    private Callback callback;
    private boolean allowCachedRedirects;
    private Object callerTag;

    public static Uri getProfilePictureUri(String userId, int width, int height) {
        Validate.notNullOrEmpty(userId, "userId");
        width = Math.max(width, 0);
        height = Math.max(height, 0);
        if (width == 0 && height == 0) {
            throw new IllegalArgumentException("Either width or height must be greater than 0");
        }
        Uri.Builder builder = Uri.parse((String)ServerProtocol.getGraphUrlBase()).buildUpon().path(String.format(Locale.US, PATH, FacebookSdk.getGraphApiVersion(), userId));
        if (height != 0) {
            builder.appendQueryParameter(HEIGHT_PARAM, String.valueOf(height));
        }
        if (width != 0) {
            builder.appendQueryParameter(WIDTH_PARAM, String.valueOf(width));
        }
        builder.appendQueryParameter(MIGRATION_PARAM, MIGRATION_VALUE);
        return builder.build();
    }

    private ImageRequest(Builder builder) {
        this.context = builder.context;
        this.imageUri = builder.imageUrl;
        this.callback = builder.callback;
        this.allowCachedRedirects = builder.allowCachedRedirects;
        this.callerTag = builder.callerTag == null ? new Object() : builder.callerTag;
    }

    public Context getContext() {
        return this.context;
    }

    public Uri getImageUri() {
        return this.imageUri;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public boolean isCachedRedirectAllowed() {
        return this.allowCachedRedirects;
    }

    public Object getCallerTag() {
        return this.callerTag;
    }

    public static class Builder {
        private Context context;
        private Uri imageUrl;
        private Callback callback;
        private boolean allowCachedRedirects;
        private Object callerTag;

        public Builder(Context context, Uri imageUri) {
            Validate.notNull(imageUri, "imageUri");
            this.context = context;
            this.imageUrl = imageUri;
        }

        public Builder setCallback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setCallerTag(Object callerTag) {
            this.callerTag = callerTag;
            return this;
        }

        public Builder setAllowCachedRedirects(boolean allowCachedRedirects) {
            this.allowCachedRedirects = allowCachedRedirects;
            return this;
        }

        public ImageRequest build() {
            return new ImageRequest(this);
        }
    }

    public static interface Callback {
        public void onCompleted(ImageResponse var1);
    }
}

