/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.common.R;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.LoginFragment;
import com.facebook.share.internal.DeviceShareDialogFragment;
import com.facebook.share.model.ShareContent;

public class FacebookActivity
extends FragmentActivity {
    public static String PASS_THROUGH_CANCEL_ACTION = "PassThrough";
    private static String FRAGMENT_TAG = "SingleFragment";
    private static final String TAG = FacebookActivity.class.getName();
    private Fragment singleFragment;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (!FacebookSdk.isInitialized()) {
            Utility.logd((String)TAG, (String)"Facebook SDK not initialized. Make sure you call sdkInitialize inside your Application's onCreate method.");
            FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        }
        this.setContentView(R.layout.com_facebook_activity_layout);
        if (PASS_THROUGH_CANCEL_ACTION.equals(intent.getAction())) {
            this.handlePassThroughError();
            return;
        }
        this.singleFragment = this.getFragment();
    }

    protected Fragment getFragment() {
        Intent intent = this.getIntent();
        FragmentManager manager = this.getSupportFragmentManager();
        Object fragment = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            if ("FacebookDialogFragment".equals(intent.getAction())) {
                FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = dialogFragment;
            } else if ("DeviceShareDialogFragment".equals(intent.getAction())) {
                DeviceShareDialogFragment dialogFragment = new DeviceShareDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.setShareContent((ShareContent)intent.getParcelableExtra("content"));
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = dialogFragment;
            } else {
                fragment = new LoginFragment();
                fragment.setRetainInstance(true);
                manager.beginTransaction().add(R.id.com_facebook_fragment_container, fragment, FRAGMENT_TAG).commit();
            }
        }
        return fragment;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.singleFragment != null) {
            this.singleFragment.onConfigurationChanged(newConfig);
        }
    }

    public Fragment getCurrentFragment() {
        return this.singleFragment;
    }

    private void handlePassThroughError() {
        Intent requestIntent = this.getIntent();
        Bundle errorResults = NativeProtocol.getMethodArgumentsFromIntent((Intent)requestIntent);
        FacebookException exception = NativeProtocol.getExceptionFromErrorData((Bundle)errorResults);
        Intent resultIntent = NativeProtocol.createProtocolResultIntent((Intent)this.getIntent(), null, (FacebookException)exception);
        this.setResult(0, resultIntent);
        this.finish();
    }
}

