/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.common.R;
import com.facebook.devicerequests.internal.DeviceRequestsHelper;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.DeviceAuthMethodHandler;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginFragment;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceAuthDialog
extends DialogFragment {
    private static final String DEVICE_LOGIN_ENDPOINT = "device/login";
    private static final String DEVICE_LOGIN_STATUS_ENDPOINT = "device/login_status";
    private static final String REQUEST_STATE_KEY = "request_state";
    private static final int LOGIN_ERROR_SUBCODE_EXCESSIVE_POLLING = 1349172;
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_DECLINED = 1349173;
    private static final int LOGIN_ERROR_SUBCODE_AUTHORIZATION_PENDING = 1349174;
    private static final int LOGIN_ERROR_SUBCODE_CODE_EXPIRED = 1349152;
    private ProgressBar progressBar;
    private TextView confirmationCode;
    private TextView instructions;
    private DeviceAuthMethodHandler deviceAuthMethodHandler;
    private AtomicBoolean completed = new AtomicBoolean();
    private volatile GraphRequestAsyncTask currentGraphRequestPoll;
    private volatile ScheduledFuture scheduledPoll;
    private volatile RequestState currentRequestState;
    private Dialog dialog;
    private boolean isBeingDestroyed = false;
    private boolean isRetry = false;
    private LoginClient.Request mRequest = null;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        RequestState requestState;
        View view = super.onCreateView(inflater, container, savedInstanceState);
        FacebookActivity facebookActivity = (FacebookActivity)this.getActivity();
        LoginFragment fragment = (LoginFragment)facebookActivity.getCurrentFragment();
        this.deviceAuthMethodHandler = (DeviceAuthMethodHandler)fragment.getLoginClient().getCurrentHandler();
        if (savedInstanceState != null && (requestState = (RequestState)savedInstanceState.getParcelable(REQUEST_STATE_KEY)) != null) {
            this.setCurrentRequestState(requestState);
        }
        return view;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.dialog = new Dialog((Context)this.getActivity(), R.style.com_facebook_auth_dialog);
        View view = this.initializeContentView(DeviceRequestsHelper.isAvailable() && !this.isRetry);
        this.dialog.setContentView(view);
        return this.dialog;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (!this.isBeingDestroyed) {
            this.onCancel();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.currentRequestState != null) {
            outState.putParcelable(REQUEST_STATE_KEY, (Parcelable)this.currentRequestState);
        }
    }

    public void onDestroy() {
        this.isBeingDestroyed = true;
        this.completed.set(true);
        super.onDestroy();
        if (this.currentGraphRequestPoll != null) {
            this.currentGraphRequestPoll.cancel(true);
        }
        if (this.scheduledPoll != null) {
            this.scheduledPoll.cancel(true);
        }
    }

    public void startLogin(LoginClient.Request request) {
        this.mRequest = request;
        Bundle parameters = new Bundle();
        parameters.putString("scope", TextUtils.join((CharSequence)",", request.getPermissions()));
        String redirectUriString = request.getDeviceRedirectUriString();
        if (redirectUriString != null) {
            parameters.putString("redirect_uri", redirectUriString);
        }
        String accessToken = Validate.hasAppID() + "|" + Validate.hasClientToken();
        parameters.putString("access_token", accessToken);
        parameters.putString("device_info", DeviceRequestsHelper.getDeviceInfo());
        GraphRequest graphRequest = new GraphRequest(null, DEVICE_LOGIN_ENDPOINT, parameters, HttpMethod.POST, new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                if (DeviceAuthDialog.this.isBeingDestroyed) {
                    return;
                }
                if (response.getError() != null) {
                    DeviceAuthDialog.this.onError(response.getError().getException());
                    return;
                }
                JSONObject jsonObject = response.getJSONObject();
                RequestState requestState = new RequestState();
                try {
                    requestState.setUserCode(jsonObject.getString("user_code"));
                    requestState.setRequestCode(jsonObject.getString("code"));
                    requestState.setInterval(jsonObject.getLong("interval"));
                }
                catch (JSONException ex) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)ex));
                    return;
                }
                DeviceAuthDialog.this.setCurrentRequestState(requestState);
            }
        });
        graphRequest.executeAsync();
    }

    private void setCurrentRequestState(RequestState currentRequestState) {
        this.currentRequestState = currentRequestState;
        this.confirmationCode.setText((CharSequence)currentRequestState.getUserCode());
        Bitmap bitmap = DeviceRequestsHelper.generateQRCode(currentRequestState.getAuthorizationUri());
        BitmapDrawable qrCode = new BitmapDrawable(this.getResources(), bitmap);
        this.instructions.setCompoundDrawablesWithIntrinsicBounds(null, (Drawable)qrCode, null, null);
        this.confirmationCode.setVisibility(0);
        this.progressBar.setVisibility(8);
        if (!this.isRetry && DeviceRequestsHelper.startAdvertisementService(currentRequestState.getUserCode())) {
            AppEventsLogger logger = AppEventsLogger.newLogger((Context)this.getContext());
            logger.logSdkEvent("fb_smart_login_service", null, null);
        }
        if (currentRequestState.withinLastRefreshWindow()) {
            this.schedulePoll();
        } else {
            this.poll();
        }
    }

    protected View initializeContentView(boolean isSmartLogin) {
        LayoutInflater inflater = this.getActivity().getLayoutInflater();
        View view = inflater.inflate(this.getLayoutResId(isSmartLogin), null);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.confirmationCode = (TextView)view.findViewById(R.id.confirmation_code);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceAuthDialog.this.onCancel();
            }
        });
        this.instructions = (TextView)view.findViewById(R.id.com_facebook_device_auth_instructions);
        this.instructions.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.com_facebook_device_auth_instructions)));
        return view;
    }

    @LayoutRes
    protected int getLayoutResId(boolean isSmartLogin) {
        return isSmartLogin ? R.layout.com_facebook_smart_device_dialog_fragment : R.layout.com_facebook_device_auth_dialog_fragment;
    }

    private void poll() {
        this.currentRequestState.setLastPoll(new Date().getTime());
        this.currentGraphRequestPoll = this.getPollRequest().executeAsync();
    }

    private void schedulePoll() {
        this.scheduledPoll = DeviceAuthMethodHandler.getBackgroundExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                DeviceAuthDialog.this.poll();
            }
        }, this.currentRequestState.getInterval(), TimeUnit.SECONDS);
    }

    private GraphRequest getPollRequest() {
        Bundle parameters = new Bundle();
        parameters.putString("code", this.currentRequestState.getRequestCode());
        return new GraphRequest(null, DEVICE_LOGIN_STATUS_ENDPOINT, parameters, HttpMethod.POST, new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                if (DeviceAuthDialog.this.completed.get()) {
                    return;
                }
                FacebookRequestError error = response.getError();
                if (error != null) {
                    switch (error.getSubErrorCode()) {
                        case 1349172: 
                        case 1349174: {
                            DeviceAuthDialog.this.schedulePoll();
                            break;
                        }
                        case 1349152: {
                            DeviceAuthDialog.this.startLogin(DeviceAuthDialog.this.mRequest);
                            break;
                        }
                        case 1349173: {
                            DeviceAuthDialog.this.onCancel();
                            break;
                        }
                        default: {
                            DeviceAuthDialog.this.onError(response.getError().getException());
                        }
                    }
                    return;
                }
                try {
                    JSONObject resultObject = response.getJSONObject();
                    DeviceAuthDialog.this.onSuccess(resultObject.getString("access_token"));
                }
                catch (JSONException ex) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)ex));
                }
            }
        });
    }

    private void presentConfirmation(final String userId, final Utility.PermissionsPair permissions, final String accessToken, String name) {
        String message = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_title);
        String continueFormat = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_continue_as);
        String cancel = this.getResources().getString(R.string.com_facebook_smart_login_confirmation_cancel);
        String continueText = String.format(continueFormat, name);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setMessage((CharSequence)message).setCancelable(true).setNegativeButton((CharSequence)continueText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface alertDialog, int which) {
                DeviceAuthDialog.this.completeLogin(userId, permissions, accessToken);
            }
        }).setPositiveButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface alertDialog, int which) {
                View view = DeviceAuthDialog.this.initializeContentView(false);
                DeviceAuthDialog.this.dialog.setContentView(view);
                DeviceAuthDialog.this.startLogin(DeviceAuthDialog.this.mRequest);
            }
        });
        builder.create().show();
    }

    private void onSuccess(final String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id,permissions,name");
        AccessToken temporaryToken = new AccessToken(accessToken, FacebookSdk.getApplicationId(), "0", null, null, null, null, null);
        GraphRequest request = new GraphRequest(temporaryToken, "me", parameters, HttpMethod.GET, new GraphRequest.Callback(){

            public void onCompleted(GraphResponse response) {
                String name;
                Utility.PermissionsPair permissions;
                String userId;
                if (DeviceAuthDialog.this.completed.get()) {
                    return;
                }
                if (response.getError() != null) {
                    DeviceAuthDialog.this.onError(response.getError().getException());
                    return;
                }
                try {
                    JSONObject jsonObject = response.getJSONObject();
                    userId = jsonObject.getString("id");
                    permissions = Utility.handlePermissionResponse((JSONObject)jsonObject);
                    name = jsonObject.getString("name");
                }
                catch (JSONException ex) {
                    DeviceAuthDialog.this.onError(new FacebookException((Throwable)ex));
                    return;
                }
                DeviceRequestsHelper.cleanUpAdvertisementService(DeviceAuthDialog.this.currentRequestState.getUserCode());
                boolean requireConfirm = FetchedAppSettingsManager.getAppSettingsWithoutQuery((String)FacebookSdk.getApplicationId()).getSmartLoginOptions().contains(SmartLoginOption.RequireConfirm);
                if (requireConfirm && !DeviceAuthDialog.this.isRetry) {
                    DeviceAuthDialog.this.isRetry = true;
                    DeviceAuthDialog.this.presentConfirmation(userId, permissions, accessToken, name);
                    return;
                }
                DeviceAuthDialog.this.completeLogin(userId, permissions, accessToken);
            }
        });
        request.executeAsync();
    }

    private void completeLogin(String userId, Utility.PermissionsPair permissions, String accessToken) {
        this.deviceAuthMethodHandler.onSuccess(accessToken, FacebookSdk.getApplicationId(), userId, permissions.getGrantedPermissions(), permissions.getDeclinedPermissions(), AccessTokenSource.DEVICE_AUTH, null, null);
        this.dialog.dismiss();
    }

    protected void onError(FacebookException ex) {
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        if (this.currentRequestState != null) {
            DeviceRequestsHelper.cleanUpAdvertisementService(this.currentRequestState.getUserCode());
        }
        this.deviceAuthMethodHandler.onError((Exception)((Object)ex));
        this.dialog.dismiss();
    }

    private void onCancel() {
        if (!this.completed.compareAndSet(false, true)) {
            return;
        }
        if (this.currentRequestState != null) {
            DeviceRequestsHelper.cleanUpAdvertisementService(this.currentRequestState.getUserCode());
        }
        if (this.deviceAuthMethodHandler != null) {
            this.deviceAuthMethodHandler.onCancel();
        }
        this.dialog.dismiss();
    }

    private static class RequestState
    implements Parcelable {
        private String authorizationUri;
        private String userCode;
        private String requestCode;
        private long interval;
        private long lastPoll;
        public static final Parcelable.Creator<RequestState> CREATOR = new Parcelable.Creator<RequestState>(){

            public RequestState createFromParcel(Parcel in) {
                return new RequestState(in);
            }

            public RequestState[] newArray(int size) {
                return new RequestState[size];
            }
        };

        RequestState() {
        }

        public String getAuthorizationUri() {
            return this.authorizationUri;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public void setUserCode(String userCode) {
            this.userCode = userCode;
            this.authorizationUri = String.format(Locale.ENGLISH, "https://facebook.com/device?user_code=%1$s&qr=1", userCode);
        }

        public String getRequestCode() {
            return this.requestCode;
        }

        public void setRequestCode(String requestCode) {
            this.requestCode = requestCode;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void setLastPoll(long lastPoll) {
            this.lastPoll = lastPoll;
        }

        protected RequestState(Parcel in) {
            this.userCode = in.readString();
            this.requestCode = in.readString();
            this.interval = in.readLong();
            this.lastPoll = in.readLong();
        }

        public boolean withinLastRefreshWindow() {
            if (this.lastPoll == 0L) {
                return false;
            }
            long diff = new Date().getTime() - this.lastPoll - this.interval * 1000L;
            return diff < 0L;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.userCode);
            dest.writeString(this.requestCode);
            dest.writeLong(this.interval);
            dest.writeLong(this.lastPoll);
        }
    }
}

