/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.proto;

import android.text.TextUtils;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class RevenueProtoReq {
    private static final String TAG = "RevenueProtoReq";
    private final String data;
    private final int cmd;
    private final int appId;
    private final int version;
    private final JSONObject jsonMsg;
    private final String sign;
    private final Map<String, String> params;
    private final Map<String, String> header;

    private RevenueProtoReq(Builder builder) {
        this.data = builder.data;
        this.cmd = builder.cmd;
        this.appId = builder.appId;
        this.version = builder.version;
        this.jsonMsg = builder.jsonMsg;
        this.sign = builder.sign;
        this.params = builder.params;
        this.header = CommonHttpHeader.getRevenueHeaderMap();
        if (!TextUtils.isEmpty((CharSequence)builder.countryCode)) {
            this.header.put("country", this.formatCountryCode(builder.countryCode));
        }
        this.checkCountry(builder.countryCode);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getCmd() {
        return this.cmd;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    private String formatCountryCode(String countryCode) {
        if (countryCode == null) {
            return "";
        }
        return countryCode.toUpperCase();
    }

    public String toString() {
        return "RevenueProtoReq{, cmd=" + this.cmd + ", appId=" + this.appId + ", version=" + this.version + ", sign='" + this.sign + '\'' + ", header=" + this.header + ", jsonMsg='" + this.jsonMsg + '\'' + ", data='" + this.data + '\'' + ", params=" + this.params + '}';
    }

    private void checkCountry(final String country) {
        int size = FP.size((CharSequence)country);
        if (size > 3) {
            MLog.error((Object)TAG, (String)"checkCountry %s", (Object[])new Object[]{country});
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    RevenueProtoReq.this.reportAbnorCountry(country);
                }
            });
        }
    }

    private void reportAbnorCountry(String country) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "revenue_country");
        statContent.put("sfield", country);
        statContent.put("ifield", this.cmd);
        HiidoStatis.reportContent((StatisContent)statContent);
        if (SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("\u8425\u6536\u8bf7\u6c42\u975e\u6cd5\u56fd\u5bb6\u7801 " + country);
        }
    }

    public static final class Builder {
        private String data;
        private int cmd = -1;
        private int appId = -1;
        private int version = 0;
        private JSONObject jsonMsg;
        private String countryCode;
        private String sign;
        private Map<String, String> params;

        private Builder() {
        }

        public Builder cmd(int val) {
            this.cmd = val;
            return this;
        }

        public Builder appId(int val) {
            this.appId = val;
            return this;
        }

        public Builder version(int val) {
            this.version = val;
            return this;
        }

        public Builder jsonMsg(JSONObject val) {
            this.jsonMsg = val;
            return this;
        }

        public Builder countryCode(String val) {
            this.countryCode = val;
            return this;
        }

        public RevenueProtoReq build() {
            if (this.cmd == -1 || this.appId == -1 || this.jsonMsg == null) {
                throw new IllegalArgumentException("illegal argument");
            }
            this.data = JsonStringBuilder.newBuilder().put("cmd", (Object)this.cmd).put("appId", (Object)this.appId).put("version", (Object)this.version).put("jsonMsg", (Object)this.jsonMsg).buildJson();
            this.sign = MD5Utils.getMd5StringNew((String)("turnover" + this.data));
            this.params = new HashMap<String, String>(2);
            this.params.put("sign", this.sign);
            this.params.put("data", this.data);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)RevenueProtoReq.TAG, (String)"cmd: %s, countryCode: %s, sign: %s, data: %s", (Object[])new Object[]{this.cmd, this.countryCode, this.sign, this.data});
            }
            return new RevenueProtoReq(this);
        }
    }
}

