/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.proto;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.callback.GenericsCallback;
import com.yy.base.okhttp.callback.IGenericsSerializator;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.RevenueUri;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import okhttp3.Call;

public class RevenueProto {
    private static long mSeq = System.currentTimeMillis();
    private static final IGenericsSerializator<RevenueProtoRes> REVENUE_TRANSFORM = new IGenericsSerializator<RevenueProtoRes>(){

        public RevenueProtoRes transform(String response, Class<RevenueProtoRes> classOfT) {
            return (RevenueProtoRes)JsonParser.parseJsonObject((String)response, classOfT);
        }
    };

    public static String getUrl(String type, int cmd) {
        String host = RevenueUri.getHost();
        return StringUtils.formatWitUSLocal((String)"%s/%s/%s/%s", (Object[])new Object[]{host, type, 1802, cmd});
    }

    public static JsonStringBuilder getCommonParam() {
        JsonStringBuilder param = JsonStringBuilder.newBuilder();
        param.put("uid", (Object)AccountUtil.getUid());
        param.put("sid", (Object)0);
        param.put("ssid", (Object)0);
        param.put("appId", (Object)1802);
        param.put("currencyType", (Object)1805);
        param.put("seq", (Object)RevenueProto.uniqueSeq());
        return param;
    }

    public static synchronized String uniqueSeq() {
        long cur = System.currentTimeMillis();
        mSeq = cur > mSeq ? cur : ++mSeq;
        return AccountUtil.getUid() + "_" + mSeq;
    }

    public static void sendHttp(String url, RevenueProtoReq req, final RevenueProtoCallback callback) {
        HttpUtil.httpReq((String)url, req.getParams(), (int)2, (INetRespCallback)new INetRespOriginJsonParseCallback<RevenueProtoRes>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)"RevenueUri", (String)("e = " + e), (Object[])new Object[0]);
                if (callback != null) {
                    callback.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<RevenueProtoRes> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"RevenueUri", (String)(" sucess " + (RuntimeContext.sIsDebuggable ? response : "")), (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onResponse(res.data, id2);
                }
            }

            public long getCacheEffectiveTime() {
                return 0L;
            }
        }, req.getHeader());
    }

    public static abstract class RevenueProtoCallback
    extends GenericsCallback<RevenueProtoRes> {
        public RevenueProtoCallback() {
            super(REVENUE_TRANSFORM);
        }
    }
}

