/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.param;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftLifecycle;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftListener;
import com.yy.hiyo.wallet.base.revenue.gift.event.IShowGiftInterceptor;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftFlashLocation;

public class GiftHandlerParam
extends KvoSource {
    private static final String TAG = "GiftHandlerParam";
    @Nullable
    private final IGiftLifecycle mLifecycle;
    @Nullable
    private final IGiftListener mGiftListener;
    @NonNull
    private final IGiftBehavior mBehavior;
    @Nullable
    private final IShowGiftInterceptor mShowInterceptor;
    @NonNull
    private final String mRoomId;
    @NonNull
    private final long mAnchorUid;
    public static final String kvo_mChannelId = "mChannelId";
    @KvoFieldAnnotation(name="mChannelId")
    private int mChannelId;
    private String mGameId = "";
    private String cvid = "";
    private GiftFlashLocation mFlashLocation;
    private ActivityTagInfo mRoomTag;
    @NonNull
    private final String mTopId;
    private final String mSubId;
    private final String mRecommendToken;

    private GiftHandlerParam(Builder builder) {
        this.mLifecycle = builder.lifecycle;
        this.mGiftListener = builder.listener;
        this.mBehavior = builder.behavior;
        this.mShowInterceptor = builder.showInterceptor;
        this.mRoomId = builder.roomId;
        this.cvid = builder.cvid;
        this.mAnchorUid = builder.anchorUid;
        this.mFlashLocation = builder.flashLocation;
        this.mRoomTag = builder.roomTag;
        this.mChannelId = builder.channelId;
        this.mTopId = builder.topId;
        this.mSubId = builder.subId;
        this.mRecommendToken = builder.recommendToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void setChannelId(int channelId) {
        this.setValue(kvo_mChannelId, channelId);
    }

    @Nullable
    public IGiftLifecycle getLifecycle() {
        return this.mLifecycle;
    }

    @Nullable
    public IGiftListener getGiftListener() {
        return this.mGiftListener;
    }

    @NonNull
    public IGiftBehavior getBehavior() {
        return this.mBehavior;
    }

    @Nullable
    public IShowGiftInterceptor getShowInterceptor() {
        return this.mShowInterceptor;
    }

    @NonNull
    public String getRoomId() {
        return this.mRoomId;
    }

    @NonNull
    public long getAnchorUid() {
        return this.mAnchorUid;
    }

    public String getCvid() {
        return this.cvid;
    }

    public int getChannelId() {
        return this.mChannelId;
    }

    public GiftFlashLocation getFlashLocation() {
        return this.mFlashLocation;
    }

    public String getGameId() {
        return this.mGameId;
    }

    public void setGameId(String gameId) {
        this.mGameId = gameId;
    }

    public void setRoomTag(ActivityTagInfo roomTag) {
        this.mRoomTag = roomTag;
    }

    public ActivityTagInfo getRoomTag() {
        return this.mRoomTag;
    }

    public String getTopId() {
        return this.mTopId;
    }

    public String getSubId() {
        return this.mSubId;
    }

    public String getRecommendToken() {
        return this.mRecommendToken;
    }

    public String toString() {
        return "GiftHandlerParam{, mBehavior=" + this.mBehavior + ", mRoomId='" + this.mRoomId + '\'' + ", mAnchorUid=" + this.mAnchorUid + ", mChannelId=" + this.mChannelId + ", mGameId='" + this.mGameId + '\'' + ", mFlashLocation=" + (Object)((Object)this.mFlashLocation) + ", mRoomTag=" + this.mRoomTag + ", mTopId='" + this.mTopId + '\'' + ", mSubId='" + this.mSubId + '\'' + '}';
    }

    public static final class Builder {
        private IGiftLifecycle lifecycle;
        private IGiftListener listener;
        private IGiftBehavior behavior;
        private IShowGiftInterceptor showInterceptor;
        private String roomId;
        private String cvid;
        private long anchorUid;
        private int channelId;
        private GiftFlashLocation flashLocation;
        private ActivityTagInfo roomTag;
        private String topId;
        private String subId;
        private String recommendToken;

        private Builder() {
        }

        public Builder lifecycle(IGiftLifecycle val) {
            this.lifecycle = val;
            return this;
        }

        public Builder listener(IGiftListener val) {
            this.listener = val;
            return this;
        }

        public Builder behavior(IGiftBehavior val) {
            this.behavior = val;
            return this;
        }

        public Builder roomId(String val) {
            this.roomId = val;
            return this;
        }

        public Builder cvid(String val) {
            this.cvid = val;
            return this;
        }

        public Builder anchorUid(long val) {
            this.anchorUid = val;
            return this;
        }

        public Builder channelId(int val) {
            this.channelId = val;
            return this;
        }

        public Builder flashLocation(GiftFlashLocation val) {
            this.flashLocation = val;
            return this;
        }

        public Builder roomTag(ActivityTagInfo tag) {
            this.roomTag = tag;
            return this;
        }

        public Builder topId(String val) {
            this.topId = val;
            return this;
        }

        public Builder subId(String val) {
            this.subId = val;
            return this;
        }

        public Builder showInterceptor(IShowGiftInterceptor val) {
            this.showInterceptor = val;
            return this;
        }

        public Builder recommendToken(String token) {
            this.recommendToken = token;
            return this;
        }

        public GiftHandlerParam build() {
            this.checkoutParam(this);
            return new GiftHandlerParam(this);
        }

        private void checkoutParam(Builder param) {
            String msg = null;
            if (param == null) {
                msg = "GiftHandlerParam can not be null";
            } else if (TextUtils.isEmpty((CharSequence)param.roomId)) {
                msg = "GiftHandlerParam with roomId can not be empty";
            } else if (param.behavior == null) {
                msg = "GiftHandlerParam with IGiftBehavior can not be null";
            } else if (this.channelId <= 0) {
                msg = "GiftHandlerParam with channelId is illegal";
            } else if (this.anchorUid <= 0L) {
                msg = "GiftHandlerParam with anchorUid is illegal";
            }
            if (msg != null) {
                MLog.error((Object)GiftHandlerParam.TAG, (String)msg, (Object[])new Object[0]);
                throw new IllegalArgumentException(msg);
            }
        }
    }
}

