/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.giftbox;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.rclayout.RCRelativeLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.wallet.base.DR;
import com.yy.hiyo.wallet.base.R;
import com.yy.hiyo.wallet.base.giftbox.GiftBoxCarouselAnimator;
import com.yy.hiyo.wallet.base.giftbox.GiftSweepImageView;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftAnimDesParam;
import java.util.ArrayList;
import java.util.List;

public class GiftBoxView
extends YYRelativeLayout {
    private final Context mContext;
    private GiftSweepImageView sweepImg;
    private GiftBoxCarouselAnimator giftBoxCarouselAnimator;
    private List<String> urls;
    private RecycleImageView giftIv;
    private RCRelativeLayout rcLayout;
    private YYView mGiftRedDot;
    private YYTextView mGiftUnreadRedDot;
    private SVGAImageView mGiftBoxSvga;
    private int giftViewType = 0;
    private String mGiftIconUrl;
    private SVGAImageView bgSvga;
    private RecycleImageView mNewGiftImage;
    private YYImageView mImageCover;
    private boolean mSweepAnimPlaying = false;
    private boolean mContinueIconAnim = true;

    public GiftBoxView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.createView();
    }

    private void createView() {
        GiftBoxView.inflate((Context)this.mContext, (int)R.layout.layout_gift_box, (ViewGroup)this);
        this.rcLayout = (RCRelativeLayout)this.findViewById(R.id.rc_layout);
        this.rcLayout.setRoundAsCircle(true);
        this.mGiftRedDot = (YYView)this.findViewById(R.id.gift_red_dot);
        this.mGiftUnreadRedDot = (YYTextView)this.findViewById(R.id.gift_unread_red_dot);
        this.sweepImg = (GiftSweepImageView)this.findViewById(R.id.gift_box_sweep_img);
        this.giftIv = (RecycleImageView)this.findViewById(R.id.iv_gift);
        this.mNewGiftImage = (RecycleImageView)this.findViewById(R.id.ivNewGift);
        this.mImageCover = (YYImageView)this.findViewById(R.id.ivCover);
        this.mGiftBoxSvga = (SVGAImageView)this.findViewById(R.id.gift_box_svga);
        this.bgSvga = (SVGAImageView)this.findViewById(R.id.bg_bubble_svga);
    }

    public void operatorView(boolean isNewGift) {
        if (isNewGift) {
            this.mNewGiftImage.setVisibility(0);
            this.sweepImg.setVisibility(8);
            this.giftIv.setVisibility(8);
            this.mImageCover.setVisibility(8);
        } else {
            this.mNewGiftImage.setVisibility(8);
            this.sweepImg.setVisibility(0);
            this.giftIv.setVisibility(0);
            this.mImageCover.setVisibility(0);
        }
    }

    public void showNewGiftIcon() {
        this.giftViewType = 1;
        this.mNewGiftImage.setVisibility(0);
        this.sweepImg.setVisibility(8);
        this.giftIv.setVisibility(8);
        this.mImageCover.setVisibility(8);
    }

    public void loadGiftBoxSvga() {
        DyResLoader.INSTANCE.loadSvga(this.mGiftBoxSvga, DR.sv_channel_bottom_gift_box, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                GiftBoxView.this.giftViewType = 2;
                GiftBoxView.this.mGiftBoxSvga.setVisibility(0);
                GiftBoxView.this.mGiftBoxSvga.startAnimation();
                GiftBoxView.this.rcLayout.setVisibility(8);
                GiftBoxView.this.cancelAllAnim();
            }

            public void onFailed(Exception e) {
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public void startCarouselImg(List<String> result) {
        if (!TextUtils.isEmpty((CharSequence)this.mGiftIconUrl)) {
            return;
        }
        this.urls = result;
        this.getGiftBoxCarouselAnimator().initAndStartRepeatScale(this.giftIv, this.urls, 5, null);
    }

    public void startSweepAnim() {
        this.giftViewType = 0;
        this.mNewGiftImage.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)this.mGiftIconUrl)) {
            return;
        }
        this.startSweepAnimInner();
        this.mSweepAnimPlaying = true;
    }

    private void startSweepAnimInner() {
        this.sweepImg.initAndStartRepeatTranslation(-1, ResolutionUtils.dip2Px((float)60.0f));
    }

    public void setGiftRedDot(boolean visible) {
        this.mGiftRedDot.setVisibility(!this.isUnreadRedDotShow() && visible ? 0 : 8);
    }

    public void setUnreadRedDot(int count) {
        if (count > 0) {
            if (this.mGiftUnreadRedDot != null) {
                if (this.mGiftRedDot != null) {
                    this.mGiftRedDot.setVisibility(8);
                }
                if (this.mGiftUnreadRedDot.getVisibility() != 0) {
                    this.mGiftUnreadRedDot.setVisibility(0);
                }
                String redCount = count > 99 ? "99+" : String.valueOf(count);
                this.mGiftUnreadRedDot.setText((CharSequence)redCount);
            }
        } else if (this.mGiftUnreadRedDot != null && this.mGiftUnreadRedDot.getVisibility() != 8) {
            this.mGiftUnreadRedDot.setVisibility(8);
            this.mGiftUnreadRedDot.setText((CharSequence)"");
        }
    }

    public void setGiftIcon(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.mGiftIconUrl = url;
        this.cancelAllAnim();
        ImageLoader.loadImage((RecycleImageView)this.giftIv, (String)url, (int)R.drawable.icon_gift_box);
    }

    public void resetGiftIcon() {
        this.mGiftIconUrl = null;
        ImageLoader.loadImage((RecycleImageView)this.giftIv, (int)R.drawable.icon_gift_box);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.resetGiftIcon();
            this.setUnreadRedDot(0);
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelAllAnim();
    }

    private GiftBoxCarouselAnimator getGiftBoxCarouselAnimator() {
        if (this.giftBoxCarouselAnimator == null) {
            this.giftBoxCarouselAnimator = new GiftBoxCarouselAnimator();
        }
        return this.giftBoxCarouselAnimator;
    }

    public void setGiftIvVisible(int visible) {
        this.giftIv.setVisibility(visible);
    }

    public void cancelAllAnim() {
        this.cancelAllAnimInner();
        this.mSweepAnimPlaying = false;
        this.mContinueIconAnim = false;
    }

    private void cancelAllAnimInner() {
        this.sweepImg.cancelTransAnim();
        if (this.giftBoxCarouselAnimator != null) {
            this.giftBoxCarouselAnimator.cancelScaleAnim();
        }
    }

    public void startGiftBgSvga(DResource dResource) {
        if (this.giftViewType == 0) {
            DyResLoader.INSTANCE.loadSvga(this.bgSvga, dResource, true);
        }
    }

    public void showGiftIconAnim(final String url, final long showTime, final long interval) {
        this.cancelAllAnimInner();
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        int repeatCount = Math.round(showTime / 1380L);
        this.getGiftBoxCarouselAnimator().initAndStartRepeatScale(this.giftIv, urls, repeatCount, new GiftBoxCarouselAnimator.OnAnimationCycleListener(){

            @Override
            public void onAnimCycleEnd() {
                if (!GiftBoxView.this.mContinueIconAnim) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GiftBoxView.this.showGiftIconAnim(url, showTime, interval);
                    }
                }, (long)interval);
            }
        });
    }

    public GiftAnimDesParam getGiftAnimDesParam() {
        int[] location = new int[2];
        this.giftIv.getLocationInWindow(location);
        GiftAnimDesParam param = GiftAnimDesParam.newBuilder().desHeight(this.giftIv.getMeasuredHeight()).desWidth(this.giftIv.getMeasuredWidth()).viewType(this.giftViewType).desX(location[0]).desY(location[1]).builder();
        return param;
    }

    private boolean isUnreadRedDotShow() {
        return this.mGiftUnreadRedDot != null && this.mGiftUnreadRedDot.getVisibility() == 0;
    }

    public void onPause() {
        this.cancelAllAnimInner();
    }

    public void onResume() {
        if (this.mSweepAnimPlaying) {
            this.startSweepAnimInner();
        }
    }

    public void blowUpViewSize() {
        ViewGroup.LayoutParams rcP;
        if (this.mGiftBoxSvga == null || this.rcLayout == null) {
            return;
        }
        ViewGroup.LayoutParams svgaP = this.mGiftBoxSvga.getLayoutParams();
        if (svgaP != null) {
            svgaP.width = ResolutionUtils.dip2Px((float)35.0f);
            svgaP.height = ResolutionUtils.dip2Px((float)35.0f);
            this.mGiftBoxSvga.setLayoutParams(svgaP);
        }
        if ((rcP = this.rcLayout.getLayoutParams()) != null) {
            rcP.width = ResolutionUtils.dip2Px((float)35.0f);
            rcP.height = ResolutionUtils.dip2Px((float)35.0f);
            this.rcLayout.setLayoutParams(rcP);
        }
    }
}

