/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.giftbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.util.Property;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.YYImageUtils;
import java.util.List;

public class GiftBoxCarouselAnimator {
    private static String TAG = "GiftBoxCarouselAnimator";
    private ObjectAnimator scaleAnim;
    boolean replacePic = true;
    private int start = 0;
    private int repeatScaleTimes = 0;
    private String url;

    public void cancelScaleAnim() {
        if (this.scaleAnim != null) {
            this.url = "";
            this.scaleAnim.removeAllListeners();
            this.scaleAnim = null;
        }
    }

    public void initAndStartRepeatScale(final RecycleImageView giftIv, final List<String> urlList, final int repeatCount, final OnAnimationCycleListener listener) {
        if (urlList == null || urlList.size() <= 0) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initAndStartRepeatScale", (Object[])new Object[0]);
        }
        this.start = 0;
        this.repeatScaleTimes = 0;
        this.url = urlList.get(0) + YYImageUtils.getThumbSmall();
        if (this.scaleAnim == null) {
            this.scaleAnim = this.getScaleAnim(giftIv);
            this.scaleAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    GiftBoxCarouselAnimator.this.replacePic = true;
                    GiftBoxCarouselAnimator.this.start++;
                    if (GiftBoxCarouselAnimator.this.start >= urlList.size()) {
                        GiftBoxCarouselAnimator.this.start = 0;
                    }
                    if (GiftBoxCarouselAnimator.this.repeatScaleTimes < repeatCount) {
                        GiftBoxCarouselAnimator.this.url = (String)urlList.get(GiftBoxCarouselAnimator.this.start) + YYImageUtils.getThumbSmall();
                    } else {
                        GiftBoxCarouselAnimator.this.url = "";
                    }
                    if (GiftBoxCarouselAnimator.this.repeatScaleTimes <= repeatCount) {
                        GiftBoxCarouselAnimator.this.startScaleAnim();
                    } else if (listener != null) {
                        listener.onAnimCycleEnd();
                    }
                }
            });
            this.scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float frac = animation.getAnimatedFraction();
                    if (GiftBoxCarouselAnimator.this.replacePic && (double)frac > 0.5) {
                        GiftBoxCarouselAnimator.this.replacePic = false;
                        ImageLoader.loadImage((RecycleImageView)giftIv, (String)GiftBoxCarouselAnimator.this.url, (int)R.drawable.icon_gift_box);
                    }
                }
            });
            this.scaleAnim.setStartDelay(1000L);
            this.scaleAnim.setDuration(380L);
            this.startScaleAnim();
        }
    }

    private void startScaleAnim() {
        if (this.scaleAnim == null) {
            return;
        }
        ++this.repeatScaleTimes;
        this.scaleAnim.start();
    }

    @NonNull
    private ObjectAnimator getScaleAnim(RecycleImageView giftIv) {
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.2f, 1.0f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.2f, 1.0f});
        return ObjectAnimator.ofPropertyValuesHolder((Object)giftIv, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
    }

    static interface OnAnimationCycleListener {
        public void onAnimCycleEnd();
    }
}

