/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.action;

import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.money.api.appconfigcenter.GetRoomRightBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.RoomRightBannerInfo;

public class RoomActivityActionList
extends ActivityAction {
    public List<RoomActivityAction> list;
    public long version;
    public int miniRefreshMin = Integer.MAX_VALUE;

    public static RoomActivityActionList from(GetRoomRightBannerInfoRsp rsp) {
        List rightBannerInfos;
        if (rsp != null && !FP.empty((Collection)(rightBannerInfos = rsp.infos))) {
            ArrayList<RoomActivityAction> tempList = new ArrayList<RoomActivityAction>(rightBannerInfos.size());
            for (RoomRightBannerInfo info : rightBannerInfos) {
                if (info == null) continue;
                RoomActivityAction activityAction = RoomActivityAction.from(info);
                tempList.add(activityAction);
            }
            RoomActivityActionList roomActivityActionList = new RoomActivityActionList();
            roomActivityActionList.list = tempList;
            roomActivityActionList.version = rsp.version;
            return roomActivityActionList;
        }
        return null;
    }

    public static RoomActivityActionList from(ActivityActionList actionList) {
        if (actionList == null || FP.empty(actionList.list)) {
            return null;
        }
        return RoomActivityActionList.convertRoomActionList(actionList);
    }

    private static RoomActivityActionList convertRoomActionList(ActivityActionList actionList) {
        if (actionList == null || FP.empty(actionList.list)) {
            return null;
        }
        List<ActivityAction> actList = actionList.list;
        ArrayList<RoomActivityAction> tempList = new ArrayList<RoomActivityAction>(actList.size());
        for (ActivityAction info : actList) {
            RoomActivityAction roomActivityAction = RoomActivityAction.from(info);
            tempList.add(roomActivityAction);
        }
        RoomActivityActionList roomActivityActionList = new RoomActivityActionList();
        roomActivityActionList.list = tempList;
        roomActivityActionList.version = actionList.version;
        return roomActivityActionList;
    }

    public int getMiniRefreshMin() {
        if (this.list != null) {
            for (RoomActivityAction activityAction : this.list) {
                if (activityAction == null || activityAction.refreshMinutes >= this.miniRefreshMin) continue;
                this.miniRefreshMin = activityAction.refreshMinutes;
            }
        }
        return this.miniRefreshMin;
    }

    @Override
    public boolean isExpire() {
        if (this.list != null) {
            for (RoomActivityAction activityAction : this.list) {
                if (!activityAction.isExpire()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "RoomActivityActionList=list:" + this.list + ",version=" + this.version + ",miniRefreshMin=" + this.miniRefreshMin;
    }
}

