/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.action;

import android.net.Uri;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.ihago.money.api.appconfigcenter.ActivityBannerInfo;
import net.ihago.money.api.appconfigcenter.LinkStyle;

@Keep
public class ActivityAction
implements Serializable {
    public long id;
    public int activityType;
    public String title;
    public String iconUrl;
    public String linkUrl;
    public LinkShowType linkType;
    public PictureType pictureType;
    public int refreshMinutes;
    public long responseAt;
    public ShowLogic showLogic;
    public long startTime;
    public long endTime;
    public int width;
    public int height;
    public boolean hasShowRed;
    public boolean hasRead;
    public int originType;
    public float windowScale;
    public int shakeStayRoomSeconds;
    public int shakeContinueType;
    public int shakeSvgaType;
    public int shakeSeconds;
    public int countdownRemainSeconds;
    public String lowEndUrl;
    public Map<String, String> actExtraInfos;
    public boolean isH5BigPage;
    public String tagName;
    public static final String MORA_LINK_URL = "mora";
    public int lowEndWidth;
    public int lowEndHeight;

    public ActivityAction() {
        this.activityType = ActivityType.NORMAL.type;
        this.linkType = LinkShowType.NOTHING;
        this.pictureType = PictureType.UNKOWN;
        this.shakeStayRoomSeconds = 0;
        this.shakeContinueType = 0;
        this.shakeSvgaType = 0;
        this.shakeSeconds = 0;
        this.countdownRemainSeconds = 0;
        this.lowEndUrl = null;
        this.isH5BigPage = false;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() - this.responseAt > (long)(this.refreshMinutes * 60 * 1000);
    }

    public static ActivityAction from(@NonNull ActivityBannerInfo data) {
        ActivityAction action = new ActivityAction();
        action.id = data.id.intValue();
        action.refreshMinutes = data.refresh_mins;
        action.iconUrl = data.pic_url;
        action.linkType = ActivityAction.convertType(data.link_style);
        action.activityType = data.type;
        action.title = data.title;
        action.linkUrl = data.link_url;
        if (data.pic_type.intValue() == net.ihago.money.api.appconfigcenter.PictureType.DynamicPic.getValue()) {
            action.pictureType = PictureType.SVGA;
        } else if (data.pic_type.intValue() == net.ihago.money.api.appconfigcenter.PictureType.StaticPic.getValue()) {
            action.pictureType = PictureType.IMAGE;
        } else if (data.pic_type.intValue() == net.ihago.money.api.appconfigcenter.PictureType.EmbedH5.getValue()) {
            action.pictureType = PictureType.H5;
        }
        action.startTime = data.start_time;
        action.endTime = data.end_time;
        action.responseAt = System.currentTimeMillis();
        action.actExtraInfos = new HashMap<String, String>(4);
        action.actExtraInfos.putAll(data.act_extra_infos);
        action.width = data.pic_width;
        action.height = data.pic_height;
        action.hasShowRed = data.has_red;
        action.originType = data.type;
        action.windowScale = data.window_scale.floatValue();
        action.shakeStayRoomSeconds = data.shake_stay_room_seconds;
        action.shakeContinueType = data.shake_continue_type;
        action.shakeSvgaType = data.shake_svga_type;
        action.shakeSeconds = data.shake_seconds;
        action.countdownRemainSeconds = data.countdown_remain_seconds;
        action.lowEndUrl = data.low_end_url;
        action.showLogic = ActivityAction.convertShowLogic(data.show_logic);
        action.tagName = data.tag_name;
        action.lowEndWidth = data.low_end_width;
        action.lowEndHeight = data.low_end_height;
        return action;
    }

    private static ShowLogic convertShowLogic(int showLogic) {
        if (showLogic == net.ihago.money.api.appconfigcenter.ShowLogic.Always.getValue()) {
            return ShowLogic.ALWAYS;
        }
        if (showLogic == net.ihago.money.api.appconfigcenter.ShowLogic.OnlyFirst.getValue()) {
            return ShowLogic.ONLY_ONCE;
        }
        if (showLogic == net.ihago.money.api.appconfigcenter.ShowLogic.FirstInDay.getValue()) {
            return ShowLogic.ONCE_PER_DAY;
        }
        return ShowLogic.NONE;
    }

    public static LinkShowType convertType(int type) {
        LinkShowType linkType = LinkShowType.NOTHING;
        linkType = type == LinkStyle.StyleJump.getValue() ? LinkShowType.NEW_WINDOW : (type == LinkStyle.StylePop.getValue() ? LinkShowType.DIALOG : (type == LinkStyle.StyleApp.getValue() ? LinkShowType.APP : (type == LinkStyle.StyleTransparentH5.getValue() ? LinkShowType.TRANSPARENT_H5 : (type == LinkStyle.StyleSpinach.getValue() ? LinkShowType.FLOAT_WEB : LinkShowType.NOTHING))));
        return linkType;
    }

    public String toString() {
        return "ActivityAction{id=" + this.id + ", activityType=" + this.activityType + ", title='" + this.title + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", linkUrl='" + this.linkUrl + '\'' + ", linkType=" + (Object)((Object)this.linkType) + ", pictureType=" + (Object)((Object)this.pictureType) + ", refreshMinutes=" + this.refreshMinutes + ", responseAt=" + this.responseAt + ", isExpire=" + this.isExpire() + ", actExtraInfos=" + this.actExtraInfos + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public void spliceLinkUrl(String key, String value) {
        Uri.Builder builder = Uri.parse((String)this.linkUrl).buildUpon();
        builder.appendQueryParameter(key, value);
        this.linkUrl = builder.toString();
    }

    public static enum PictureType {
        IMAGE,
        SVGA,
        H5,
        UNKOWN;

    }

    public static enum LinkShowType {
        NEW_WINDOW,
        DIALOG,
        APP,
        TRANSPARENT_H5,
        FLOAT_GAME,
        FLOAT_WEB,
        NOTHING;

    }

    public static enum ActivityType {
        NORMAL(0),
        FIRST_CHARGE(1),
        FLOAT_GAME(2),
        ORDER_BOX(232);

        public int type;

        private ActivityType(int val) {
            this.type = val;
        }

        public static ActivityType from(int type) {
            ActivityType[] values;
            for (ActivityType value : values = ActivityType.values()) {
                if (value.type != type) continue;
                return value;
            }
            return NORMAL;
        }
    }

    public static enum ShowLogic {
        ALWAYS,
        ONLY_ONCE,
        ONCE_PER_DAY,
        NONE;

    }
}

