/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base;

import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IService;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.ActivityActionList;
import com.yy.hiyo.wallet.base.action.ActivityActionWrapper;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.action.GiftPanelAction;
import com.yy.hiyo.wallet.base.action.RoomActivityActionList;
import com.yy.hiyo.wallet.base.action.WalletBannerAction;
import com.yy.webservice.event.JsEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.ihago.money.api.appconfigcenter.BubbleNotify;
import net.ihago.money.api.appconfigcenter.RoomDynamicBannerShake;

public interface IActivityService
extends IService {
    public JsEvent[] getRevenueJsEvent(Environment var1);

    public void fetchGiftActivities(String var1, ActivityTagInfo var2, @Nullable Callback<GiftPanelAction> var3);

    public void fetchWalletActivities(@Nullable Callback<WalletBannerAction> var1);

    public void fetchRoomActivities(String var1, ActivityTagInfo var2, @Nullable Callback<RoomActivityActionList> var3);

    public void fetchActivityBannerInfo(String var1, ActivityTagInfo var2, int var3, @Nullable Callback<ActivityActionList> var4);

    public void fetchActivityBannerInfo(String var1, ActivityTagInfo var2, int var3, @Nullable Callback<ActivityActionList> var4, boolean var5);

    public void fetchActivityBannerInfo(int var1, @Nullable Callback<ActivityActionList> var2, boolean var3);

    public ActivityActionList getActivityBannerInfoFromCache(String var1, ActivityTagInfo var2, int var3);

    public void fetchGiftActivities(String var1, ActivityTagInfo var2, @Nullable Callback<GiftPanelAction> var3, boolean var4);

    public void fetchRoomActivities(String var1, ActivityTagInfo var2, @Nullable Callback<RoomActivityActionList> var3, boolean var4);

    public void requestSpinachList(int var1, Callback<ActivityActionList> var2);

    public void clearActivities(String var1, ActivityTagInfo var2);

    public void clearRoomActivities(String var1, ActivityTagInfo var2);

    public void addOnActivityUpdateListener(OnActivityUpdateListener var1);

    public void removeOnActivityUpdateListener(OnActivityUpdateListener var1);

    public void setOnRightBannerPushListener(OnRightBannerPushListener var1);

    public void setOnDynamicActListener(OnDynamicActListener var1);

    public void updateActivity(String var1, ActivityTagInfo var2, boolean var3);

    @Deprecated
    @Nullable
    default public <T extends ActivityAction> ActivityActionWrapper<T> find(List<ActivityActionWrapper<T>> list, String roomId, ActivityTagInfo roomTag) {
        ActivityActionWrapper<T> result = null;
        for (ActivityActionWrapper<T> item : list) {
            if (!StringUtils.equal((String)roomId, (String)item.roomId) || !ActivityTagInfo.isEqual(roomTag, item.roomTag)) continue;
            result = item;
            break;
        }
        return result;
    }

    @Nullable
    default public <T extends ActivityAction> ActivityActionWrapper<T> find(List<ActivityActionWrapper<T>> list, String roomId, ActivityTagInfo roomTag, int location) {
        ActivityActionWrapper<T> result = null;
        for (ActivityActionWrapper<T> item : list) {
            if (!StringUtils.equal((String)roomId, (String)item.roomId) || !ActivityTagInfo.isEqual(roomTag, item.roomTag) || location != item.location) continue;
            result = item;
            break;
        }
        return result;
    }

    public void clearAllRoomActivities();

    public static interface OnDynamicActListener
    extends OnRightBannerPushListener {
        public void getBannerNotify(boolean var1);

        public void refreshData();

        public void getDynamicBannerShake(RoomDynamicBannerShake var1);

        public void getDynamicBannerBubble(BubbleNotify var1);
    }

    public static interface OnRightBannerPushListener {
        public ActivityTagInfo getRoomTagId(String var1);

        default public String roomId() {
            return "";
        }
    }

    public static interface OnActivityUpdateListener {
        default public void onGiftActivityUpdate(List<ActivityActionWrapper<GiftPanelAction>> data) {
        }

        default public void onWalletActivityUpdate(List<ActivityActionWrapper<WalletBannerAction>> data) {
        }

        default public void onRoomActivityUpdate(List<ActivityActionWrapper<RoomActivityActionList>> data) {
        }

        default public void onActivityBannerUpdate(List<ActivityActionWrapper<ActivityActionList>> data) {
        }
    }
}

