/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.bean;

import com.google.gson.reflect.TypeToken;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

@DontProguardClass
public class GiftItemInfo {
    public static final String PREVIEW_SVGA = "previewSvga";
    public static final String VIDEO = "video";
    public static final String VIDEO_SIZE = "videoSize";
    public static final String STATIC_ICON = "staticIcon";
    public static final String LEVEL_MULTIPLE_SVGAS = "levelMultipleSvgas";
    public static final String FULL_SCREEN_SVGA = "fullScreenSvga";
    public static final String REPLACE_SVGA = "replaceSvga";
    public static final String SVGA = "svga";
    public static final String REPLACE_CONFIG = "replaceConfig";
    public static final String VIDEO_REPLACE_SVGA = "videoReplaceSvga";
    public static final String VIDEO_REPLACE_CONFIG = "videoReplaceConfig";
    public static final String SVGA_SIZE = "svgaSize";
    public static final String REPLACE_TYPE = "replaceType";
    public static final String TEXT_COLOR = "textColor";
    public static final String TEXT_SIZE = "textSize";
    public static final String PACKAGE_PRIORITY = "packagePriority";
    public static final String NUMBER_LIST = "numberList";
    public static final String EFFECT_LIST = "effectList";
    public static final String PRIORITY = "priority";
    public static final String USETYPE = "usetype";
    public static final String TIPS = "tips";
    public static final String LEFT_CORNER_MARK = "leftCornerMark";
    public static final String SELECT_HINT = "selectHint";
    public static final String SKIP_URL = "skipUrl";
    public static final String CLICK_JUMP_LINK = "clickJumpLink";
    public static final String UNIT_AWARD = "unitAward";
    public static final String KTV_SVGA_NEW = "ktvSvgaNew";
    public static final String FORCE_HIDDEN = "forceHidden";
    public static final String EFFECT_ON_SVGA = "effectOnSvga";
    public static final String SCREEN_HIDDEN = "screenHidden";
    public static final String TINY_SVGA = "tinySvga";
    public static final String CHARM_VALUE = "charmValue";
    public static final String SHOW_PLUGIN_LIST = "showPluginList";
    public static final String PAY_LEVEL = "payLevel";
    public static final String GRADE_ICON = "gradeIcon";
    public static final String GREET_TITLE = "greetTitle";
    public static final String GREET_TEXT = "greetText";
    public static final String BOX_SVGA = "boxSvga";
    public static final String FULL_BROADCAST_BG_URL = "fullBroadcastBgUrl";
    public static final String FULL_BROADCAST_BG_TYPE = "fullBroadcastBgType";
    public static final String MULTIPLE_PROPS_HIDDEN = "multiplePropsHidden";
    public static final String CLICK_JUMP_TEXT = "clickJumpText";
    public static final String HAS_ACT_JUMP_TEXT = "hasActJumpText";
    public static final String TAB_ID = "tabId";
    public static final String SVGA_BANNER_URL = "svgaBannerUrl";
    public static final String OF_RESCOURCE = "ofRescource";
    public static final String CACHE_KEY = "cacheKey";
    public static final String DESCRIPTION = "description";
    public static final String CHECK_RES_MD5 = "animationVerify";
    public static final String MOOD_SVGA = "linkSvga";
    private int propsId;
    private String name = "";
    private int type;
    private int appId;
    private boolean visible;
    private boolean usable;
    private ArrayList<Pricing> pricingList;
    private Map<String, Object> desc;
    private ArrayList<Number> defaultNumberLists;
    private ArrayList<Effect> defaultEffectLists;
    private int count;
    private int expireCount;
    private int giftLevel;
    private boolean showCombo = true;
    String urlPrefix = "";
    private int usedChannel;
    private ArrayList<Number> numberList;
    private ArrayList<Effect> effectList;
    public JSONObject expand;
    private String mStaticIcon;

    private Object opt(String name) {
        return StringUtils.isEmpty((String)name) ? null : (this.desc != null ? this.desc.get(name) : null);
    }

    private String optString(String name, String def) {
        String result = null;
        if (this.desc != null) {
            Object object = this.opt(name);
            result = GiftUtils.toString(object);
        }
        return result != null ? result : def;
    }

    private boolean optBoolean(String name, boolean def) {
        Boolean result = null;
        if (this.desc != null) {
            Object object = this.opt(name);
            result = GiftUtils.toBoolean(object);
        }
        return result != null ? result : def;
    }

    private int optInt(String name, int def) {
        Integer result = null;
        if (this.desc != null) {
            Object object = this.opt(name);
            result = GiftUtils.toInteger(object);
        }
        return result != null ? result : def;
    }

    private Map<String, Object> optMap(String name) {
        Object map;
        if (this.desc != null && (map = this.desc.get(name)) instanceof Map) {
            return (Map)map;
        }
        return null;
    }

    public void setStaticIcon(String staticIcon) {
        this.mStaticIcon = staticIcon;
    }

    public String getPreviewSvga() {
        String previewSvga = this.optString(PREVIEW_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(previewSvga, this.urlPrefix);
    }

    public String getVideo() {
        String video = this.optString(VIDEO, "");
        return GiftUtils.tryReplaceUrlPrefix(video, this.urlPrefix);
    }

    public String getVideoSize() {
        return this.optString(VIDEO_SIZE, "");
    }

    public String getMoodSvga() {
        return this.optString(MOOD_SVGA, "");
    }

    public String getStaticIcon() {
        String staticIcon = StringUtils.isEmpty((String)this.mStaticIcon) ? this.optString(STATIC_ICON, "") : this.mStaticIcon;
        return GiftUtils.tryReplaceUrlPrefix(staticIcon, this.urlPrefix);
    }

    public HashMap<String, LevelMultipleSvgas> getLevelMultipleSvgas() {
        Map<String, Object> jsonObject = this.optMap(LEVEL_MULTIPLE_SVGAS);
        HashMap<String, LevelMultipleSvgas> levelMultipleSvgasHashMap = new HashMap<String, LevelMultipleSvgas>();
        if (jsonObject != null) {
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof Map)) continue;
                Map objectMap = (Map)value;
                LevelMultipleSvgas levelMultipleSvgas = new LevelMultipleSvgas();
                levelMultipleSvgas.fullScreenSvga = GiftUtils.toString(objectMap.get(FULL_SCREEN_SVGA));
                levelMultipleSvgas.previewSvga = GiftUtils.toString(objectMap.get(PREVIEW_SVGA));
                levelMultipleSvgas.urlPrefix(this.urlPrefix);
                levelMultipleSvgas.replaceSvga = GiftUtils.toString(objectMap.get(REPLACE_SVGA));
                levelMultipleSvgas.svga = GiftUtils.toString(objectMap.get(SVGA));
                levelMultipleSvgas.video = GiftUtils.toString(objectMap.get(VIDEO));
                levelMultipleSvgas.videoSize = GiftUtils.toString(objectMap.get(VIDEO_SIZE));
                Object replaceConfigJsonObject = objectMap.get(REPLACE_CONFIG);
                if (replaceConfigJsonObject instanceof Map) {
                    Map replaceConfigMap = (Map)replaceConfigJsonObject;
                    ReplaceConfig replaceConfig = new ReplaceConfig();
                    replaceConfig.svgaSize = GiftUtils.toString(replaceConfigMap.get(SVGA_SIZE));
                    replaceConfig.replaceType = GiftUtils.toInteger(replaceConfigMap.get(REPLACE_TYPE), -1);
                    replaceConfig.textColor = GiftUtils.toString(replaceConfigMap.get(TEXT_COLOR));
                    replaceConfig.textSize = GiftUtils.toInteger(replaceConfigMap.get(TEXT_SIZE), 0);
                    levelMultipleSvgas.replaceConfig = replaceConfig;
                }
                levelMultipleSvgasHashMap.put(key, levelMultipleSvgas);
            }
        }
        return levelMultipleSvgasHashMap;
    }

    public String getPackagePriority() {
        return this.optString(PACKAGE_PRIORITY, "");
    }

    public String getDescription() {
        return this.optString(DESCRIPTION, "");
    }

    public ArrayList<Number> getNumberLists() {
        return this.numberList;
    }

    public ArrayList<Effect> getEffectLists() {
        return this.effectList;
    }

    private void parseNumberAndEffectLists() {
        String numberLists = this.optString(NUMBER_LIST, "");
        if (StringUtils.isEmpty((String)numberLists)) {
            this.numberList = this.defaultNumberLists;
        } else {
            this.numberList = (ArrayList)JsonParser.parseJsonObject((String)numberLists, (Type)new TypeToken<ArrayList<Number>>(){}.getType());
            if (this.numberList == null) {
                this.numberList = this.defaultNumberLists;
            }
        }
        String effectLists = this.optString(EFFECT_LIST, "");
        if (StringUtils.isEmpty((String)effectLists)) {
            this.effectList = this.defaultEffectLists;
        } else {
            this.effectList = (ArrayList)JsonParser.parseJsonObject((String)effectLists, (Type)new TypeToken<ArrayList<Effect>>(){}.getType());
            if (this.effectList != null) {
                for (Effect effect : this.effectList) {
                    if (effect == null) continue;
                    effect.parseJson();
                }
            }
            if (this.effectList == null) {
                this.effectList = this.defaultEffectLists;
            }
        }
    }

    public String getPriority() {
        return this.optString(PRIORITY, "");
    }

    public String getUsetype() {
        return this.optString(USETYPE, "");
    }

    public String getTips() {
        return this.optString(TIPS, "");
    }

    public String getLeftCornerMark() {
        String leftCornerMark = this.optString(LEFT_CORNER_MARK, "");
        return GiftUtils.tryReplaceUrlPrefix(leftCornerMark, this.urlPrefix);
    }

    public String getSelectHint() {
        return this.optString(SELECT_HINT, "");
    }

    public String getSkipUrl() {
        String skipUrl = this.optString(SKIP_URL, "");
        return GiftUtils.tryReplaceUrlPrefix(skipUrl, this.urlPrefix);
    }

    public String getClickJumpLink() {
        String clickJumpLink = this.optString(CLICK_JUMP_LINK, "");
        return GiftUtils.tryReplaceUrlPrefix(clickJumpLink, this.urlPrefix);
    }

    public int getUnitAward() {
        return this.optInt(UNIT_AWARD, 0);
    }

    public String getSvga() {
        String svga = this.optString(SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(svga, this.urlPrefix);
    }

    public String getFullScreenSvga() {
        String fullScreenSvga = this.optString(FULL_SCREEN_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(fullScreenSvga, this.urlPrefix);
    }

    public String getKtvSvga() {
        String ktvSvga = this.optString(KTV_SVGA_NEW, "");
        return GiftUtils.tryReplaceUrlPrefix(ktvSvga, this.urlPrefix);
    }

    public String getReplaceSvga() {
        String replaceSvga = this.optString(REPLACE_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(replaceSvga, this.urlPrefix);
    }

    public ReplaceConfig getReplaceConfig() {
        Map<String, Object> jsonObject = this.optMap(REPLACE_CONFIG);
        ReplaceConfig replaceConfig = new ReplaceConfig();
        if (jsonObject != null) {
            replaceConfig.svgaSize = GiftUtils.toString(jsonObject.get(SVGA_SIZE));
            replaceConfig.replaceType = GiftUtils.toInteger(jsonObject.get(REPLACE_TYPE), -1);
            replaceConfig.textColor = GiftUtils.toString(jsonObject.get(TEXT_COLOR));
            replaceConfig.textSize = GiftUtils.toInteger(jsonObject.get(TEXT_SIZE), 0);
        }
        return replaceConfig;
    }

    public String getVideoReplaceSvga() {
        String replaceSvga = this.optString(VIDEO_REPLACE_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(replaceSvga, this.urlPrefix);
    }

    public ReplaceConfig getVideoReplaceConfig() {
        Map<String, Object> jsonObject = this.optMap(VIDEO_REPLACE_CONFIG);
        ReplaceConfig replaceConfig = new ReplaceConfig();
        if (jsonObject != null) {
            replaceConfig.svgaSize = GiftUtils.toString(jsonObject.get(SVGA_SIZE));
            replaceConfig.replaceType = GiftUtils.toInteger(jsonObject.get(REPLACE_TYPE), -1);
            replaceConfig.textColor = GiftUtils.toString(jsonObject.get(TEXT_COLOR));
            replaceConfig.textSize = GiftUtils.toInteger(jsonObject.get(TEXT_SIZE), 0);
        }
        return replaceConfig;
    }

    public boolean isForceHidden() {
        return this.optBoolean(FORCE_HIDDEN, false);
    }

    public boolean isCheckResMd5() {
        return this.optBoolean(CHECK_RES_MD5, true);
    }

    public boolean isEffectOnSvga() {
        return this.optBoolean(EFFECT_ON_SVGA, false);
    }

    public boolean isScreenHidden() {
        return this.optBoolean(SCREEN_HIDDEN, false);
    }

    public String getTinySvga() {
        String tinySvga = this.optString(TINY_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(tinySvga, this.urlPrefix);
    }

    public int getCharmValue() {
        return this.optInt(CHARM_VALUE, 0);
    }

    public ArrayList<String> getShowPluginList() {
        Object list = null;
        if (this.desc != null) {
            list = this.desc.get(SHOW_PLUGIN_LIST);
        }
        if (list instanceof ArrayList) {
            try {
                ArrayList arrayList = (ArrayList)list;
                return arrayList;
            }
            catch (Exception e) {
                MLog.error((Object)"GiftItemInfo", (Throwable)e);
            }
        }
        return new ArrayList<String>(0);
    }

    public int getPayLevel() {
        return this.optInt(PAY_LEVEL, 0);
    }

    public String getGradeIcon(String key) {
        String url;
        key = key + "";
        Map<String, Object> jsonObject = this.optMap(GRADE_ICON);
        String string2 = url = jsonObject != null ? GiftUtils.toString(jsonObject.get(key)) : "";
        if (StringUtils.isNotEmpty((String)url)) {
            url = GiftUtils.isUrl(url) ? url : this.urlPrefix + url;
        }
        return url;
    }

    public String getGreetTitle() {
        return this.optString(GREET_TITLE, "");
    }

    public String getGreetText() {
        return this.optString(GREET_TEXT, "");
    }

    public String getBoxSvga() {
        String boxSvga = this.optString(BOX_SVGA, "");
        return GiftUtils.tryReplaceUrlPrefix(boxSvga, this.urlPrefix);
    }

    public String getFullBroadcastBgUrl() {
        String fullBroadcastBgUrl = this.optString(FULL_BROADCAST_BG_URL, "");
        return GiftUtils.tryReplaceUrlPrefix(fullBroadcastBgUrl, this.urlPrefix);
    }

    public String getFullBroadcastBgType() {
        String fullBroadcastBgType = this.optString(FULL_BROADCAST_BG_TYPE, "");
        return GiftUtils.tryReplaceUrlPrefix(fullBroadcastBgType, this.urlPrefix);
    }

    public boolean isMultiplePropsHidden() {
        return this.optBoolean(MULTIPLE_PROPS_HIDDEN, false);
    }

    public String getClickJumpText() {
        return this.optString(CLICK_JUMP_TEXT, "");
    }

    public boolean isHasActJumpText() {
        return this.optBoolean(HAS_ACT_JUMP_TEXT, false);
    }

    public String getTabId() {
        return this.optString(TAB_ID, "");
    }

    public String getSvgaBannerUrl() {
        String svgaBannerUrl = this.optString(SVGA_BANNER_URL, "");
        return GiftUtils.tryReplaceUrlPrefix(svgaBannerUrl, this.urlPrefix);
    }

    public String getArOfRescource() {
        String ofRescource = this.optString(OF_RESCOURCE, "");
        return GiftUtils.tryReplaceUrlPrefix(ofRescource, this.urlPrefix);
    }

    public String getCacheKey() {
        return this.optString(CACHE_KEY, "");
    }

    public void setDefaultList(ArrayList<Number> numbers, ArrayList<Effect> effects) {
        this.defaultNumberLists = numbers;
        this.defaultEffectLists = effects;
        this.parseNumberAndEffectLists();
        if (this.numberList == null) {
            this.numberList = this.defaultNumberLists;
        }
        if (this.effectList == null) {
            this.effectList = this.defaultEffectLists;
        } else {
            for (Effect effect : this.effectList) {
                effect.urlPrefix(this.urlPrefix);
            }
        }
    }

    public JSONObject getExpand() {
        return this.expand;
    }

    public void setExpand(JSONObject expand) {
        this.expand = expand;
    }

    public boolean isShowCombo() {
        return this.showCombo;
    }

    public void setShowCombo(boolean showCombo) {
        this.showCombo = showCombo;
    }

    public int getPropsId() {
        return this.propsId;
    }

    public void setPropsId(int propsId) {
        this.propsId = propsId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getAppId() {
        return this.appId;
    }

    public void setAppId(int appId) {
        this.appId = appId;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public ArrayList<Pricing> getPricingList() {
        return this.pricingList;
    }

    public void setPricingList(ArrayList<Pricing> pricingList) {
        this.pricingList = pricingList;
    }

    public boolean isNotNullForDesc() {
        return this.desc != null;
    }

    public void setDesc(Map<String, Object> desc) {
        this.desc = desc;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getExpireCount() {
        return this.expireCount;
    }

    public void setExpireCount(int expireCount) {
        this.expireCount = expireCount;
    }

    public int getGiftLevel() {
        return this.giftLevel;
    }

    public void setGiftLevel(int giftLevel) {
        this.giftLevel = giftLevel;
    }

    @DontProguardClass
    public static abstract class UrlPrefix {
        String urlPrefix = "";

        public abstract void urlPrefix(String var1);
    }

    @DontProguardClass
    public static class EffectUrl
    extends UrlPrefix {
        private String sweepLight = "";
        private String bannerBgUrl = "";
        private String wipeUrl = "";
        private String sendUserBgUrl = "";
        private String comboEffectBgUrl = "";

        public String getSweepLight() {
            return GiftUtils.tryReplaceUrlPrefix(this.sweepLight, this.urlPrefix);
        }

        public void setSweepLight(String sweepLight) {
            this.sweepLight = sweepLight;
        }

        public String getBannerBgUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.bannerBgUrl, this.urlPrefix);
        }

        public void setBannerBgUrl(String bannerBgUrl) {
            this.bannerBgUrl = bannerBgUrl;
        }

        public String getWipeUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.wipeUrl, this.urlPrefix);
        }

        public void setWipeUrl(String wipeUrl) {
            this.wipeUrl = wipeUrl;
        }

        public String getSendUserBgUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.sendUserBgUrl, this.urlPrefix);
        }

        public void setSendUserBgUrl(String sendUserBgUrl) {
            this.sendUserBgUrl = sendUserBgUrl;
        }

        public String getComboEffectBgUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.comboEffectBgUrl, this.urlPrefix);
        }

        public void setComboEffectBgUrl(String comboEffectBgUrl) {
            this.comboEffectBgUrl = comboEffectBgUrl;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }
    }

    @DontProguardClass
    public static class Effect
    extends UrlPrefix {
        private String effectUrls = "";
        private EffectUrl effectUrl;
        private String level = "";
        public int value;
        public boolean large;
        public String image = "";
        public long displayTime;

        public void setEffectUrls(String effectUrls) {
            this.effectUrls = effectUrls;
        }

        public EffectUrl getEffectUrl() {
            return this.effectUrl;
        }

        public void setEffectUrl(EffectUrl effectUrl) {
            this.effectUrl = effectUrl;
        }

        public String getImage() {
            return GiftUtils.tryReplaceUrlPrefix(this.image, this.urlPrefix);
        }

        public void setImage(String image) {
            this.image = image;
        }

        public boolean isLarge() {
            return this.large;
        }

        public void setLarge(boolean large) {
            this.large = large;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public void parseJson() {
            this.effectUrl = (EffectUrl)JsonParser.parseJsonObject((String)this.effectUrls, (Type)new TypeToken<EffectUrl>(){}.getType());
            if (this.effectUrl != null) {
                this.effectUrls = null;
            }
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            if (this.effectUrl != null) {
                this.effectUrl.urlPrefix(urlPrefix);
            }
        }
    }

    @DontProguardClass
    public static class Number {
        private int number;
        private String priority = "";
        private String desc = "";

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String getPriority() {
            return this.priority;
        }

        public void setPriority(String priority) {
            this.priority = priority;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    @DontProguardClass
    public static class ReplaceConfig {
        private String svgaSize = "";
        private int replaceType;
        private String textColor = "";
        private int textSize;

        public String getSvgaSize() {
            return this.svgaSize;
        }

        public void setSvgaSize(String svgaSize) {
            this.svgaSize = svgaSize;
        }

        public int getReplaceType() {
            return this.replaceType;
        }

        public void setReplaceType(int replaceType) {
            this.replaceType = replaceType;
        }

        public String getTextColor() {
            return this.textColor;
        }

        public void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public void setTextSize(int textSize) {
            this.textSize = textSize;
        }
    }

    @DontProguardClass
    public static class LevelMultipleSvgas
    extends UrlPrefix {
        private String svga = "";
        private String fullScreenSvga = "";
        private String replaceSvga = "";
        private ReplaceConfig replaceConfig;
        private String previewSvga = "";
        private String video = "";
        private String videoSize = "";

        public String getPreviewSvga() {
            return GiftUtils.tryReplaceUrlPrefix(this.previewSvga, this.urlPrefix);
        }

        public void setPreviewSvga(String previewSvga) {
            this.previewSvga = previewSvga;
        }

        public String getVideo() {
            return GiftUtils.tryReplaceUrlPrefix(this.video, this.urlPrefix);
        }

        public void setVideo(String video) {
            this.video = video;
        }

        public String getVideoSize() {
            return this.videoSize;
        }

        public void setVideoSize(String videoSize) {
            this.videoSize = videoSize;
        }

        public String getSvga() {
            return GiftUtils.tryReplaceUrlPrefix(this.svga, this.urlPrefix);
        }

        public void setSvga(String svga) {
            this.svga = svga;
        }

        public String getFullScreenSvga() {
            return GiftUtils.tryReplaceUrlPrefix(this.fullScreenSvga, this.urlPrefix);
        }

        public void setFullScreenSvga(String fullScreenSvga) {
            this.fullScreenSvga = fullScreenSvga;
        }

        public String getReplaceSvga() {
            return GiftUtils.tryReplaceUrlPrefix(this.replaceSvga, this.urlPrefix);
        }

        public void setReplaceSvga(String replaceSvga) {
            this.replaceSvga = replaceSvga;
        }

        public ReplaceConfig getReplaceConfig() {
            return this.replaceConfig;
        }

        public void setReplaceConfig(ReplaceConfig replaceConfig) {
            this.replaceConfig = replaceConfig;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }
    }

    @DontProguardClass
    public static class Pricing {
        private int currencyType;
        private int currencyAmount;
        private int revenueAmount;
        private int userTypeLimit;

        public int getUserTypeLimit() {
            return this.userTypeLimit;
        }

        public void setUserTypeLimit(int userTypeLimit) {
            this.userTypeLimit = userTypeLimit;
        }

        public int getCurrencyType() {
            return this.currencyType;
        }

        public void setCurrencyType(int currencyType) {
            this.currencyType = currencyType;
        }

        public int getCurrencyAmount() {
            return this.currencyAmount;
        }

        public void setCurrencyAmount(int currencyAmount) {
            this.currencyAmount = currencyAmount;
        }

        public int getRevenueAmount() {
            return this.revenueAmount;
        }

        public void setRevenueAmount(int revenueAmount) {
            this.revenueAmount = revenueAmount;
        }
    }
}

