/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.bean;

import android.util.Base64;
import com.google.gson.reflect.TypeToken;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftExpandInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;

@DontProguardClass
public class GiftInfo {
    static final String NULL_STRING_FILL = "";
    private int cmd;
    private long uid;
    private String seq = "";
    private int result;
    private int appId;
    private int usedChannel;
    private String expand = "";
    private String countryCode = "";
    private String language = "";
    private int liveCategoryId;
    private String urlPrefix = "";
    private int specialList;
    private String md5Version = "";
    private int compress;
    private String compressData = "";
    private ArrayList<GiftItemInfo> propsList = new ArrayList();
    private Expend expendData;

    public int getCmd() {
        return this.cmd;
    }

    public void setCmd(int cmd) {
        this.cmd = cmd;
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public int getAppId() {
        return this.appId;
    }

    public void setAppId(int appId) {
        this.appId = appId;
    }

    public int getUsedChannel() {
        return this.usedChannel;
    }

    public void setUsedChannel(int usedChannel) {
        this.usedChannel = usedChannel;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getLiveCategoryId() {
        return this.liveCategoryId;
    }

    public void setLiveCategoryId(int liveCategoryId) {
        this.liveCategoryId = liveCategoryId;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public int getSpecialList() {
        return this.specialList;
    }

    public void setSpecialList(int specialList) {
        this.specialList = specialList;
    }

    public String getMd5Version() {
        return this.md5Version;
    }

    public void setMd5Version(String md5Version) {
        this.md5Version = md5Version;
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int compress) {
        this.compress = compress;
    }

    public void setCompressData(String compressData) {
        this.compressData = compressData;
    }

    public ArrayList<GiftItemInfo> getPropsList() {
        return this.propsList;
    }

    public Expend getExpendData() {
        return this.expendData;
    }

    public void parse() {
        this.expendData = (Expend)JsonParser.parseJsonObject((String)this.expand, Expend.class);
        if (this.expendData != null) {
            this.expand = null;
            this.expendData.parse();
        } else {
            this.expendData = new Expend();
        }
        if (StringUtils.isNotEmpty((String)this.urlPrefix)) {
            this.expendData.urlPrefix(this.urlPrefix);
        }
        if (StringUtils.isNotEmpty((String)this.compressData)) {
            byte[] data = Base64.decode((String)this.compressData, (int)0);
            this.compressData = null;
            String propsListStr = GiftUtils.unCompressToStringZLib(data);
            ArrayList<GiftItemInfo> arrayList = this.propsList = StringUtils.isNotEmpty((String)propsListStr) ? (ArrayList)JsonParser.parseJsonObject((String)propsListStr, (Type)new TypeToken<ArrayList<GiftItemInfo>>(){}.getType()) : new ArrayList(0);
            if (this.propsList == null) {
                this.propsList = new ArrayList(0);
            }
            this.parsePropsListJson();
        }
    }

    private void parsePropsListJson() {
        if (this.propsList == null || this.propsList.size() == 0) {
            return;
        }
        for (GiftItemInfo giftItemInfo : this.propsList) {
            if (giftItemInfo == null) continue;
            giftItemInfo.urlPrefix = this.urlPrefix;
            giftItemInfo.setDefaultList(this.expendData.getDefaultNumberList(), this.expendData.getDefaultEffectList());
        }
    }

    @DontProguardClass
    public static class NumEffectConfig
    extends GiftItemInfo.UrlPrefix {
        private int level;
        private int numValue;
        private String frontUrl = "";
        private String bgUrl = "";
        private String numUrl = "";
        private int type;

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getNumValue() {
            return this.numValue;
        }

        public void setNumValue(int numValue) {
            this.numValue = numValue;
        }

        public String getFrontUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.frontUrl, this.urlPrefix);
        }

        public void setFrontUrl(String frontUrl) {
            this.frontUrl = frontUrl;
        }

        public String getBgUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.bgUrl, this.urlPrefix);
        }

        public void setBgUrl(String bgUrl) {
            this.bgUrl = bgUrl;
        }

        public String getNumUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.numUrl, this.urlPrefix);
        }

        public void setNumUrl(String numUrl) {
            this.numUrl = numUrl;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }
    }

    @DontProguardClass
    public static class NumEffect
    extends GiftItemInfo.UrlPrefix {
        private int level;
        private int priceValue;
        private ArrayList<NumEffectConfig> config = new ArrayList(0);

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getPriceValue() {
            return this.priceValue;
        }

        public void setPriceValue(int priceValue) {
            this.priceValue = priceValue;
        }

        public ArrayList<NumEffectConfig> getConfig() {
            return this.config;
        }

        public void setConfig(ArrayList<NumEffectConfig> config) {
            this.config = config;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            if (this.config != null) {
                for (NumEffectConfig numEffectConfig : this.config) {
                    numEffectConfig.urlPrefix(urlPrefix);
                }
            }
        }
    }

    @DontProguardClass
    public static class EffectItem
    extends GiftItemInfo.UrlPrefix {
        private int level;
        private String effectUrl = "";
        private int type;
        private String effectValue = "";

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getEffectUrl() {
            return GiftUtils.tryReplaceUrlPrefix(this.effectUrl, this.urlPrefix);
        }

        public void setEffectUrl(String effectUrl) {
            this.effectUrl = effectUrl;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getEffectValue() {
            return this.effectValue;
        }

        public void setEffectValue(String effectValue) {
            this.effectValue = effectValue;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }
    }

    @DontProguardClass
    public static class ComboEffect
    extends GiftItemInfo.UrlPrefix {
        private ArrayList<EffectItem> appraiseEffect = new ArrayList(0);
        private ArrayList<EffectItem> finishEffect = new ArrayList(0);
        private ArrayList<NumEffect> numEffect = new ArrayList(0);

        public ArrayList<EffectItem> getAppraiseEffect() {
            return this.appraiseEffect;
        }

        public void setAppraiseEffect(ArrayList<EffectItem> appraiseEffect) {
            this.appraiseEffect = appraiseEffect;
        }

        public ArrayList<EffectItem> getFinishEffect() {
            return this.finishEffect;
        }

        public void setFinishEffect(ArrayList<EffectItem> finishEffect) {
            this.finishEffect = finishEffect;
        }

        public ArrayList<NumEffect> getNumEffect() {
            return this.numEffect;
        }

        public void setNumEffect(ArrayList<NumEffect> numEffect) {
            this.numEffect = numEffect;
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            if (this.appraiseEffect != null) {
                for (EffectItem effectItem : this.appraiseEffect) {
                    effectItem.urlPrefix(urlPrefix);
                }
            }
            if (this.finishEffect != null) {
                for (EffectItem effectItem : this.finishEffect) {
                    effectItem.urlPrefix(urlPrefix);
                }
            }
            if (this.numEffect != null) {
                for (NumEffect numEffect : this.numEffect) {
                    numEffect.urlPrefix(urlPrefix);
                }
            }
        }
    }

    @DontProguardClass
    public static class Expend
    extends GiftItemInfo.UrlPrefix {
        private ComboEffect comboEffect;
        private ArrayList<GiftExpandInfo.GiftPanelTabInfo> tabInfo = new ArrayList(0);
        private ArrayList<GiftItemInfo.Number> defaultNumberList = new ArrayList(0);
        private ArrayList<GiftItemInfo.Effect> defaultEffectList = new ArrayList(0);

        public ComboEffect getComboEffect() {
            return this.comboEffect;
        }

        public void setComboEffect(ComboEffect comboEffect) {
            this.comboEffect = comboEffect;
        }

        public ArrayList<GiftExpandInfo.GiftPanelTabInfo> getTabInfo() {
            return this.tabInfo;
        }

        public void setTabInfo(ArrayList<GiftExpandInfo.GiftPanelTabInfo> tabInfo) {
            this.tabInfo = tabInfo;
        }

        public ArrayList<GiftItemInfo.Number> getDefaultNumberList() {
            return this.defaultNumberList;
        }

        public void setDefaultNumberList(ArrayList<GiftItemInfo.Number> defaultNumberList) {
            this.defaultNumberList = defaultNumberList;
        }

        public ArrayList<GiftItemInfo.Effect> getDefaultEffectList() {
            return this.defaultEffectList;
        }

        public void setDefaultEffectList(ArrayList<GiftItemInfo.Effect> defaultEffectList) {
            this.defaultEffectList = defaultEffectList;
        }

        public void parse() {
            for (GiftItemInfo.Effect effect : this.defaultEffectList) {
                effect.parseJson();
            }
        }

        @Override
        public void urlPrefix(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            if (this.comboEffect != null) {
                this.comboEffect.urlPrefix(urlPrefix);
            }
            if (this.defaultEffectList != null) {
                for (GiftItemInfo.Effect effect : this.defaultEffectList) {
                    effect.urlPrefix(urlPrefix);
                }
            }
        }
    }
}

