/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.bean;

import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import java.util.List;

public class GiftBroadcastInfo {
    private long uri;
    private GiftBroUserInfo mSendUserInfo;
    private List<GiftBroUserInfo> mRevUserInfos;
    private int mBusinessType;
    private int mPropsId;
    private int mPropsCount;
    private int version;
    private long mPropsCurrencyAmount;
    private int mUsedChannel;
    private long mUsedTime;
    private int mAppId;
    private String expand;
    private GiftComboInfo giftComboInfo;

    private GiftBroadcastInfo(Builder builder) {
        this.mSendUserInfo = builder.mSendUserInfo;
        this.mRevUserInfos = builder.mRecvUserInfo;
        this.mPropsId = builder.mPropsId;
        this.mPropsCount = builder.mPropsCount;
        this.mPropsCurrencyAmount = builder.mPropsCurrencyAmount;
        this.mUsedChannel = builder.mUsedChannel;
        this.mUsedTime = builder.mUsedTime;
        this.giftComboInfo = builder.giftComboInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getUri() {
        return this.uri;
    }

    public long getUid() {
        return this.mSendUserInfo == null ? 0L : this.mSendUserInfo.getUid();
    }

    public String getUserNickname() {
        return this.mSendUserInfo == null ? "" : this.mSendUserInfo.getNickName();
    }

    public long getRecvUid() {
        if (this.mRevUserInfos != null && !this.mRevUserInfos.isEmpty()) {
            return this.mRevUserInfos.get(0).getUid();
        }
        return 0L;
    }

    public String getRecvNickname() {
        if (this.mRevUserInfos != null && !this.mRevUserInfos.isEmpty()) {
            return this.mRevUserInfos.get(0).getNickName();
        }
        return "";
    }

    public int getBusinessType() {
        return this.mBusinessType;
    }

    public int getPropsId() {
        return this.mPropsId;
    }

    public int getPropsCount() {
        return this.mPropsCount;
    }

    public int getVersion() {
        return this.version;
    }

    public long getPropsCurrencyAmount() {
        return this.mPropsCurrencyAmount;
    }

    public int getUsedChannel() {
        return this.mUsedChannel;
    }

    public long getUsedTime() {
        return this.mUsedTime;
    }

    public int getAppId() {
        return this.mAppId;
    }

    public String getExpand() {
        return this.expand;
    }

    public GiftComboInfo getGiftComboInfo() {
        return this.giftComboInfo;
    }

    public List<GiftBroUserInfo> getRevUserInfos() {
        return this.mRevUserInfos;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GiftBroadcastInfo) {
            boolean same;
            GiftBroadcastInfo info = (GiftBroadcastInfo)obj;
            boolean bl = same = info.getUid() == this.getUid() && info.getRecvUid() == this.getRecvUid() && info.getPropsId() == this.mPropsId && info.getPropsCount() == this.mPropsCount;
            if (this.giftComboInfo == null && info.getGiftComboInfo() == null) {
                return same;
            }
            if (same) {
                return this.giftComboInfo.getFirstSendTime() == info.getGiftComboInfo().getFirstSendTime();
            }
            return same;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int code = 17;
        code = code * 19 + (int)this.getUid();
        code = code * 23 + (int)(this.mSendUserInfo == null ? 0L : this.mSendUserInfo.getUid());
        code = code * 27 + this.mPropsId;
        code = code * 29 + this.mPropsCount;
        return code;
    }

    public String toString() {
        return "GiftBroadcastInfo{, mPropsCount=" + this.mPropsCount + ", mPropsCurrencyAmount=" + this.mPropsCurrencyAmount + ", mUsedTime=" + this.mUsedTime + ", mPropsId=" + this.mPropsId + ", mUsedChannel=" + this.mUsedChannel + '}';
    }

    public static final class Builder {
        private int mPropsId;
        private int mPropsCount;
        private long mPropsCurrencyAmount;
        private int mUsedChannel;
        private long mUsedTime;
        private GiftComboInfo giftComboInfo;
        private GiftBroUserInfo mSendUserInfo;
        private List<GiftBroUserInfo> mRecvUserInfo;

        private Builder() {
        }

        public Builder sendUserInfo(GiftBroUserInfo val) {
            this.mSendUserInfo = val;
            return this;
        }

        public Builder recvUserInfo(List<GiftBroUserInfo> val) {
            this.mRecvUserInfo = val;
            return this;
        }

        public Builder propsId(int val) {
            this.mPropsId = val;
            return this;
        }

        public Builder propsCount(int val) {
            this.mPropsCount = val;
            return this;
        }

        public Builder propsCurrencyAmount(long val) {
            this.mPropsCurrencyAmount = val;
            return this;
        }

        public Builder usedChannel(int val) {
            this.mUsedChannel = val;
            return this;
        }

        public Builder usedTime(long val) {
            this.mUsedTime = val;
            return this;
        }

        public void giftComboInfo(GiftComboInfo giftComboInfo) {
            this.giftComboInfo = giftComboInfo;
        }

        public GiftBroadcastInfo build() {
            return new GiftBroadcastInfo(this);
        }
    }
}

