/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift.bean;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboEffectLevel;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;

public class GiftBroResult
implements Comparable<GiftBroResult> {
    private final GiftBroadcastInfo giftBroInfo;
    private GiftComboInfo giftComboInfo;
    private GiftItemInfo giftInfo;
    private final SendGiftExpand expand;
    private final int basePriority;
    private int randomPriority;
    private final int priorityLevel;
    private final int level;
    private GiftComboEffectLevel mGiftComboExpand;

    private GiftBroResult(Builder builder) {
        this.giftBroInfo = builder.giftBroInfo;
        this.giftComboInfo = builder.giftComboInfo;
        this.mGiftComboExpand = builder.mGiftComboExpand;
        this.giftInfo = builder.giftInfo;
        this.expand = builder.expand;
        this.priorityLevel = GiftUtils.priorityLevel(GiftUtils.giftAmount(this.giftInfo, this.giftBroInfo.getPropsCount()));
        this.basePriority = builder.priority <= 0 ? GiftUtils.giftPriority(this.giftBroInfo.getUid(), this.priorityLevel, this.giftComboInfo == null ? 0 : this.giftComboInfo.getComboHits()) : builder.priority;
        this.level = GiftUtils.giftLevel(this.giftInfo, GiftUtils.giftAmount(this.giftInfo, this.giftBroInfo.getPropsCount()));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public GiftBroadcastInfo getGiftBroInfo() {
        return this.giftBroInfo;
    }

    @Nullable
    public GiftComboInfo getGiftComboInfo() {
        return this.giftComboInfo;
    }

    public void setGiftComboInfo(GiftComboInfo giftComboInfo) {
        this.giftComboInfo = giftComboInfo;
    }

    @Nullable
    public GiftItemInfo getGiftInfo() {
        return this.giftInfo;
    }

    public void setGiftInfo(GiftItemInfo info) {
        this.giftInfo = info;
    }

    public int getPropsId() {
        return this.giftBroInfo.getPropsId();
    }

    @Nullable
    public SendGiftExpand getExpand() {
        return this.expand;
    }

    public String getRoomId() {
        return this.expand == null ? "" : (this.expand.roomId == null ? "" : this.expand.roomId);
    }

    public GiftComboEffectLevel getGiftComboExpand() {
        return this.mGiftComboExpand;
    }

    public void setGiftComboExpand(GiftComboEffectLevel giftComboExpand) {
        this.mGiftComboExpand = giftComboExpand;
    }

    public long getGiftAmount() {
        long amount = GiftUtils.giftAmount(this.giftInfo, this.giftBroInfo.getPropsCount());
        if (amount <= 0L) {
            amount = this.giftBroInfo.getPropsCurrencyAmount();
        }
        return amount;
    }

    public int getBasePriority() {
        return this.basePriority;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setRandomPriority(int randomPriority) {
        this.randomPriority = randomPriority;
    }

    public int getRandomPriority() {
        return this.randomPriority;
    }

    public int getPriority() {
        return this.basePriority + this.randomPriority;
    }

    public boolean needShow(int effect) {
        return (effect & this.level) == effect;
    }

    public boolean isMyself() {
        if (this.giftBroInfo != null) {
            return this.giftBroInfo.getUid() == AccountUtil.getUid();
        }
        return false;
    }

    public boolean isMySendOrReceive() {
        if (this.giftBroInfo == null) {
            return false;
        }
        if (this.giftBroInfo.getUid() == AccountUtil.getUid()) {
            return true;
        }
        for (GiftBroUserInfo user : this.giftBroInfo.getRevUserInfos()) {
            if (user.getUid() != AccountUtil.getUid()) continue;
            return true;
        }
        return false;
    }

    public long getReceiverUid() {
        if (this.giftBroInfo != null) {
            return this.giftBroInfo.getRecvUid();
        }
        return 0L;
    }

    public boolean isFirst() {
        return this.giftComboInfo != null && this.giftComboInfo.getComboHits() == 1;
    }

    public boolean isFinish() {
        return this.giftComboInfo != null && this.giftComboInfo.getIsFinishCombo();
    }

    @Override
    public int compareTo(@NonNull GiftBroResult o) {
        int dif = 0;
        if (this.isMyself() && !o.isMyself()) {
            dif = -1;
        } else if (!this.isMyself() && o.isMyself()) {
            dif = 1;
        } else if (!this.isMyself() && !o.isMyself()) {
            dif = this.getPriority() - o.getPriority();
        }
        if (dif == 0) {
            if (this.giftComboInfo == null || o.giftComboInfo == null) {
                return dif;
            }
            if (this.equals(o)) {
                return this.giftComboInfo.getComboHits() - o.giftComboInfo.getComboHits();
            }
            if (this.giftComboInfo.getUseTimeMs() == 0L || o.giftComboInfo.getUseTimeMs() == 0L) {
                return dif;
            }
            long difT = this.giftComboInfo.getUseTimeMs() - o.giftComboInfo.getUseTimeMs();
            return difT > 0L ? 1 : (difT < 0L ? -1 : 0);
        }
        return dif;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GiftBroResult) {
            GiftBroResult result = (GiftBroResult)obj;
            return this.giftBroInfo.equals(result.getGiftBroInfo());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 17 * this.giftBroInfo.hashCode();
    }

    public String toString() {
        return "GiftBroResult{giftInfo=" + (this.giftInfo == null ? "" : this.giftInfo.getName()) + ", level=" + this.level + ", basePriority=" + this.basePriority + ", randomPriority=" + this.randomPriority + ", giftComboInfo=" + this.giftComboInfo + ", giftBroInfo=" + this.giftBroInfo + ", mGiftComboExpand=" + this.mGiftComboExpand + '}';
    }

    public static final class Builder {
        private GiftBroadcastInfo giftBroInfo;
        private GiftComboInfo giftComboInfo;
        private GiftItemInfo giftInfo;
        private SendGiftExpand expand;
        private GiftComboEffectLevel mGiftComboExpand;
        private int priority = 0;

        private Builder() {
        }

        public Builder giftBroInfo(GiftBroadcastInfo val) {
            this.giftBroInfo = val;
            return this;
        }

        public Builder giftComboInfo(GiftComboInfo val) {
            this.giftComboInfo = val;
            return this;
        }

        public Builder giftInfo(GiftItemInfo val) {
            this.giftInfo = val;
            return this;
        }

        public Builder expand(SendGiftExpand val) {
            this.expand = val;
            return this;
        }

        public Builder priority(int val) {
            this.priority = val;
            return this;
        }

        public Builder giftComboExpand(GiftComboEffectLevel val) {
            this.mGiftComboExpand = val;
            return this;
        }

        public GiftBroResult build() {
            return new GiftBroResult(this);
        }
    }
}

