/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.revenue.gift;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResultWrap;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.zip.InflaterOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftUtils {
    private static final String TAG = "GiftUtils";
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    private static Comparator<Object> discardComparator = (o1, o2) -> Long.compare(GiftUtils.getResult(o1).getGiftAmount(), GiftUtils.getResult(o2).getGiftAmount());

    public static <T> void callbackSucceed(final IGiftCallback<T> callback, final T res) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onSucceed(res);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onSucceed(res);
                }
            });
        }
    }

    public static void callbackFailed(final IGiftCallback callback, final int code, final String msg) {
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onFailed(code, msg);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onFailed(code, msg);
                }
            });
        }
    }

    public static int giftPriority(long uid, int priorityLevel, int combo) {
        if (uid == AccountUtil.getUid()) {
            return 1 * priorityLevel;
        }
        int levelBase = 1000000 * priorityLevel;
        if (combo != 1) {
            return levelBase + 100000 * priorityLevel;
        }
        return levelBase;
    }

    public static int priorityLevel(long amount) {
        if (amount >= 2000L) {
            return 1;
        }
        if (amount >= 10L) {
            return 2;
        }
        return 3;
    }

    public static long giftAmount(GiftItemInfo giftInfo, int count) {
        return GiftUtils.giftPrice(giftInfo) * (long)count;
    }

    public static int giftLevel(GiftItemInfo giftInfo, long amount) {
        int level = giftInfo != null && !TextUtils.isEmpty((CharSequence)giftInfo.getMoodSvga()) ? 17 : (giftInfo != null && giftInfo.isEffectOnSvga() && !TextUtils.isEmpty((CharSequence)giftInfo.getTinySvga()) ? 13 : (giftInfo != null && (!TextUtils.isEmpty((CharSequence)giftInfo.getSvga()) || !TextUtils.isEmpty((CharSequence)giftInfo.getFullScreenSvga()) || !TextUtils.isEmpty((CharSequence)giftInfo.getVideo()) || !TextUtils.isEmpty((CharSequence)giftInfo.getReplaceSvga())) ? 9 : (GiftUtils.giftFlashEffect(giftInfo, amount) != null ? 5 : 3)));
        if (giftInfo != null && giftInfo.isScreenHidden()) {
            level &= 0xFFFFFFFE;
        }
        return level;
    }

    public static boolean canBuy(GiftItemInfo giftInfo) {
        if (giftInfo == null || FP.empty(giftInfo.getPricingList())) {
            return false;
        }
        for (GiftItemInfo.Pricing pricing : giftInfo.getPricingList()) {
            if (pricing == null || pricing.getUserTypeLimit() != -1 || giftInfo.getCount() != 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static GiftItemInfo.Effect giftFlashEffect(GiftItemInfo giftInfo, long amount) {
        GiftItemInfo.Effect large = null;
        if (giftInfo != null && !FP.empty(giftInfo.getEffectLists())) {
            for (GiftItemInfo.Effect effect : giftInfo.getEffectLists()) {
                if (effect == null) continue;
                if ((long)effect.getValue() <= amount) {
                    large = effect;
                    continue;
                }
                if (large == null || (long)effect.getValue() <= amount) continue;
                return large;
            }
        }
        return large;
    }

    public static long giftPrice(GiftItemInfo giftInfo) {
        if (giftInfo == null || FP.empty(giftInfo.getPricingList())) {
            return 0L;
        }
        long price = -1L;
        for (GiftItemInfo.Pricing pricing : giftInfo.getPricingList()) {
            if (pricing == null) continue;
            if (price == -1L) {
                price = pricing.getCurrencyAmount();
            }
            if (pricing.getUserTypeLimit() == -1) continue;
            return pricing.getCurrencyAmount();
        }
        return price == -1L ? 0L : price;
    }

    public static String getGreetTitle(GiftItemInfo giftInfo) {
        if (giftInfo != null) {
            return giftInfo.getGreetTitle();
        }
        return "";
    }

    public static String getGreetText(GiftItemInfo giftInfo) {
        if (giftInfo != null) {
            return giftInfo.getGreetTitle();
        }
        return "";
    }

    public static String getSvgaGiftBgUrl(GiftItemInfo giftInfo) {
        if (giftInfo != null) {
            return giftInfo.getFullBroadcastBgUrl();
        }
        return "";
    }

    public static String getSvgaGiftBgType(GiftItemInfo giftInfo) {
        if (giftInfo != null) {
            return giftInfo.getFullBroadcastBgType();
        }
        return "";
    }

    public static SendGiftExpand parseSendGiftExpand(String ex) {
        SendGiftExpand expand = null;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)ex);
            expand = GiftUtils.parseSendGiftExpand(jo);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return expand;
    }

    public static SendGiftExpand parseSendGiftExpand(JSONObject jo) {
        SendGiftExpand.Builder builder = SendGiftExpand.newBuilder();
        builder.senderHeaderUrl(jo.optString("senderHeaderUrl", ""));
        builder.receiverHeaderUrl(jo.optString("receiverHeaderUrl", ""));
        builder.roomId(jo.optString("bid", ""));
        builder.roomOwnerUid(jo.optLong("roomOwnerUid", 0L));
        builder.staticIcon(jo.optString("staticIcon", ""));
        builder.giftSlogan(jo.optString("giftSlogan", ""));
        builder.giftLevel(jo.optInt("giftLevel", 0));
        builder.topId(jo.optString("topId", ""));
        builder.subId(jo.optString("subId", ""));
        builder.boxPropId(jo.optInt("boxPropId", 0));
        builder.triggerFullBroadcast(jo.optBoolean("triggerFullBroadcast", false));
        builder.familyName(jo.optString("familyName", ""));
        builder.familyLvIcon(jo.optString("familyLvIcon", ""));
        return builder.build();
    }

    public static boolean isSameGiftBro(GiftBroadcastInfo info1, GiftBroadcastInfo info2) {
        if (info1 == null || info2 == null) {
            return false;
        }
        return info1.getUid() == info2.getUid() && info1.getRecvUid() == info2.getRecvUid() && info1.getPropsId() == info2.getPropsId() && info1.getPropsCount() == info2.getPropsCount();
    }

    public static boolean canShowImGift() {
        return false;
    }

    public static String unCompressToStringZLib(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InflaterOutputStream zos = new InflaterOutputStream(out);
        try {
            zos.write(bytes);
            zos.close();
            return out.toString(GZIP_ENCODE_UTF_8);
        }
        catch (IOException e) {
            MLog.error((Object)"GiftJson", (Throwable)e);
            return "";
        }
    }

    public static boolean isUrl(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            return str.indexOf("https://") == 0 || str.indexOf("http://") == 0;
        }
        return false;
    }

    public static String tryReplaceUrlPrefix(String url, String urlPrefix) {
        if (StringUtils.isNotEmpty((String)url)) {
            url = GiftUtils.isUrl(url) ? url : urlPrefix + url;
        }
        return url;
    }

    public static <T> List<T> discardStrategy(Collection<T> original, float discardRatio, int discardMinRemain, int maxRemain) {
        int dif;
        int gap;
        int size = original.size();
        if (size <= 1) {
            return null;
        }
        PriorityQueue<Object> removeQueue = new PriorityQueue<Object>(size / 2, discardComparator);
        ArrayList remainList = new ArrayList();
        HashMap<Integer, Integer> comboHigh = new HashMap<Integer, Integer>();
        GiftUtils.findDiscardList(original, removeQueue, remainList, comboHigh);
        ArrayList<Object> remove = new ArrayList<Object>(size);
        if (maxRemain > 0 && (gap = size - removeQueue.size() - maxRemain) > 0) {
            remove.addAll(removeQueue);
            int r = 0;
            for (int i = remainList.size() - 1; i >= 0; --i) {
                Object t = remainList.get(i);
                if (r >= gap) break;
                ++r;
                remove.add(t);
            }
            return remove;
        }
        int removeMaxSize = size;
        int removeRemainSize = (int)((float)removeQueue.size() * (1.0f - discardRatio));
        int gap2 = size - removeQueue.size() + removeRemainSize - discardMinRemain;
        removeMaxSize = gap2 > 0 ? removeQueue.size() - removeRemainSize : removeQueue.size() - removeRemainSize - gap2;
        if (maxRemain > 0 && size - removeMaxSize > maxRemain) {
            removeMaxSize = size - maxRemain;
        }
        int removeSize = 0;
        Iterator iterator = removeQueue.iterator();
        while (iterator.hasNext()) {
            int high;
            Object t = iterator.next();
            GiftBroResult result = GiftUtils.getResult(t);
            if (removeSize > removeMaxSize) break;
            int n = result.getPropsId();
            Integer highO = (Integer)comboHigh.get(n);
            int n2 = high = highO == null ? 0 : highO;
            if (high != 0 && result.getGiftComboInfo().getComboHits() >= high) continue;
            remove.add(t);
            ++removeSize;
            iterator.remove();
        }
        if ((dif = size - removeSize - maxRemain) > 0) {
            for (Object e : removeQueue) {
                remove.add(e);
                if (--dif > 0) continue;
                break;
            }
        }
        return remove;
    }

    private static <T> void findDiscardList(Collection<T> original, Queue<T> removeQueue, List<T> remainList, Map<Integer, Integer> comboHigh) {
        for (T t : original) {
            GiftBroResult result = GiftUtils.getResult(t);
            if (result.isMySendOrReceive()) {
                remainList.add(t);
                continue;
            }
            if (GiftUtils.giftPrice(result.getGiftInfo()) <= 0L) {
                removeQueue.add(t);
                continue;
            }
            GiftComboInfo comb = result.getGiftComboInfo();
            if (comb == null) {
                remainList.add(t);
                continue;
            }
            if (comb.getComboHits() > 1) {
                comboHigh.put(result.getPropsId(), comb.getComboHits());
                removeQueue.add(t);
                continue;
            }
            remainList.add(t);
        }
    }

    private static <T> GiftBroResult getResult(T wrap) {
        if (wrap instanceof GiftBroResultWrap) {
            return ((GiftBroResultWrap)wrap).getResult();
        }
        if (wrap instanceof GiftBroResult) {
            return (GiftBroResult)wrap;
        }
        throw new IllegalArgumentException("GiftBroResult \u7c7b\u578b\u4e0d\u5bf9");
    }

    public static double checkDouble(double d) throws JSONException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new JSONException("Forbidden numeric value: " + d);
        }
        return d;
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if ("true".equalsIgnoreCase(stringValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return false;
            }
        }
        return null;
    }

    public static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return null;
    }

    public static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return (int)Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return null;
    }

    public static int toInteger(Object value, int def) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return (int)Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return def;
    }

    public static Long toLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return (long)Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return null;
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }
}

