/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay.callback;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.billing.base.RechargeResult;
import com.yy.hiyo.wallet.base.R;
import com.yy.hiyo.wallet.base.pay.PayCode;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;

public class SimpleRechargeCallback
implements IRechargeCallback {
    @Override
    public void onRechargeSuccess(RechargeResult result) {
    }

    @Override
    public void onSucceed(@Nullable RechargeInfo data) {
    }

    @Override
    public int rechargeSource() {
        return 0;
    }

    @Override
    public void onFailed(int code, String msg) {
        this.handleFailed(code, msg);
    }

    private void handleFailed(int code, String msg) {
        MLog.error((Object)"FTPay", (String)"handleFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
        if (!(code >= 20002 && code <= 21000 || PayCode.isReportPayError(code) || code == 10010)) {
            if (code == 20001) {
                this.showToast(R.string.tips_cancel_recharge);
            } else if (code == 10008) {
                this.showToast(R.string.tips_unknown_error);
            } else if (code == 10011) {
                this.showToast(R.string.tips_google_service_unavail);
            } else if (code == 40995 || code == 40982) {
                this.showToast(R.string.tips_recharge_user_banned);
            } else if (code == 40981) {
                this.showToast(R.string.tips_coupon_overdue);
            } else if (code == 40495) {
                this.showToast(R.string.tips_order_too_frequently);
            } else if (code == 10004) {
                this.showToast(R.string.tips_recharge_notify_timeout);
            } else if (code == 11003) {
                this.showToast(R.string.check_network_and_retry);
            } else if (code == 11002) {
                this.showToast(R.string.tips_huawei_account_not_log_in);
            } else if (code == 11001) {
                this.showToast(R.string.tips_huawei_account_not_log_in);
            } else if (code != 40929) {
                this.showToast(R.string.tips_refresh_again);
            }
        }
    }

    private void showToast(@StringRes int res) {
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)res), (int)0);
    }
}

