/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.pay.bean;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductItemExpand {
    private boolean couponMutex;
    private String slashCornerIcon;
    private String flatCornerIcon;
    private String iconText;
    private boolean currencyCodeEnable = true;
    private double srcAmount;
    private String srcCurrencySymbol;
    private boolean isRearDisplayCurrency;
    private int currencyUnitDisplay;
    private int currentMode;

    public ProductItemExpand(Builder builder) {
        this.couponMutex = builder.couponMutex;
        this.slashCornerIcon = builder.slashCornerIcon;
        this.flatCornerIcon = builder.flatCornerIcon;
        this.iconText = builder.iconText;
        this.currencyCodeEnable = builder.currencyCodeEnable;
        this.srcAmount = builder.srcAmount;
        this.srcCurrencySymbol = builder.srcCurrencySymbol;
        this.isRearDisplayCurrency = builder.isRearDisplayCurrency;
        this.currencyUnitDisplay = builder.currencyUnitDisplay;
        this.currentMode = builder.currentMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isCouponMutex() {
        return this.couponMutex;
    }

    public String getSlashCornerIcon() {
        return this.slashCornerIcon;
    }

    public String getFlatCornerIcon() {
        return this.flatCornerIcon;
    }

    public String getIconText() {
        return this.iconText;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public boolean isCurrencyCodeEnable() {
        return this.currencyCodeEnable;
    }

    public double getSrcAmount() {
        return this.srcAmount;
    }

    public boolean getIsRearDisplayCurrency() {
        return this.isRearDisplayCurrency;
    }

    public String getSrcCurrencySymbol() {
        try {
            int index = this.srcCurrencySymbol.indexOf("*");
            if (index > 0 && this.srcCurrencySymbol.length() > index + 1) {
                String[] split = this.srcCurrencySymbol.split("\\*");
                return split[this.currencyUnitDisplay];
            }
        }
        catch (Exception e) {
            MLog.error((Object)"getSrcCurrencySymbol", (String)("e: " + e), (Object[])new Object[0]);
        }
        return this.srcCurrencySymbol;
    }

    public static class Builder {
        private boolean couponMutex;
        private String slashCornerIcon;
        private String flatCornerIcon;
        private String iconText;
        private boolean currencyCodeEnable = true;
        private double srcAmount;
        private String srcCurrencySymbol;
        private boolean isRearDisplayCurrency;
        private int currencyUnitDisplay;
        private int currentMode;

        private Builder() {
        }

        public Builder currentMode(int val) {
            this.currentMode = val;
            return this;
        }

        public Builder couponMutex(boolean val) {
            this.couponMutex = val;
            return this;
        }

        public Builder slashCornerIcon(String val) {
            this.slashCornerIcon = val;
            return this;
        }

        public Builder flatCornerIcon(String val) {
            this.flatCornerIcon = val;
            return this;
        }

        public Builder iconText(String val) {
            this.iconText = val;
            return this;
        }

        public Builder currencyCodeEnable(boolean val) {
            this.currencyCodeEnable = val;
            return this;
        }

        public Builder localCurrencyDisplay(String jsonStr) {
            try {
                JSONObject localCurrencyDisplay = JsonParser.obtainJSONObject((String)jsonStr);
                String srcAmountAndSymbol = localCurrencyDisplay.optString(AccountUtil.realCountry().toUpperCase(), "");
                this.srcAmount = this.parseSrcAmount(srcAmountAndSymbol);
                this.srcCurrencySymbol = this.parseSrcCurrencySymbol(srcAmountAndSymbol);
            }
            catch (JSONException e) {
                MLog.error((Object)"ProductItemExpand", (String)("e: " + (Object)((Object)e)), (Object[])new Object[0]);
                this.srcAmount = 0.0;
                this.srcCurrencySymbol = "";
            }
            return this;
        }

        public Builder currencyUnitDisplay(int unit) {
            this.currencyUnitDisplay = unit;
            return this;
        }

        public Builder isRearDisplayCurrency(boolean rearDisplay) {
            this.isRearDisplayCurrency = rearDisplay;
            return this;
        }

        public ProductItemExpand build() {
            return new ProductItemExpand(this);
        }

        private double parseSrcAmount(String str) {
            int index = str.indexOf("-");
            if (index > 0) {
                String srcAmount = str.substring(0, index);
                return Double.parseDouble(srcAmount);
            }
            return 0.0;
        }

        private String parseSrcCurrencySymbol(String str) {
            int index = str.indexOf("-");
            if (index > 0 && str.length() > index + 1) {
                return str.substring(index + 1);
            }
            return "";
        }
    }
}

