/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.base.action;

import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.appconfigcenter.ActivityBannerInfo;
import net.ihago.money.api.appconfigcenter.GetActivityBannerInfoRsp;
import net.ihago.money.api.appconfigcenter.GetSpinachListBannersRsp;
import org.jetbrains.annotations.Nullable;

public class ActivityActionList
extends ActivityAction {
    public List<ActivityAction> list;
    public long version;
    public int miniRefreshMin = Integer.MAX_VALUE;

    public static ActivityActionList from(GetActivityBannerInfoRsp rsp) {
        List activityBannerInfos;
        ActivityActionList activityActionList;
        if (rsp != null && (activityActionList = ActivityActionList.convertActionList(activityBannerInfos = rsp.infos, rsp.version)) != null) {
            return activityActionList;
        }
        return null;
    }

    public static ActivityActionList from(GetSpinachListBannersRsp rsp) {
        List activityBannerInfos;
        ActivityActionList activityActionList;
        if (rsp != null && (activityActionList = ActivityActionList.convertActionList(activityBannerInfos = rsp.infos, rsp.version)) != null) {
            return activityActionList;
        }
        return null;
    }

    @Nullable
    private static ActivityActionList convertActionList(List<ActivityBannerInfo> activityBannerInfos, Long version) {
        if (!FP.empty(activityBannerInfos)) {
            ArrayList<ActivityAction> tempList = new ArrayList<ActivityAction>(activityBannerInfos.size());
            for (ActivityBannerInfo info : activityBannerInfos) {
                if (info == null) continue;
                ActivityAction activityAction = ActivityAction.from(info);
                tempList.add(activityAction);
            }
            ActivityActionList activityActionList = new ActivityActionList();
            activityActionList.list = tempList;
            activityActionList.version = version;
            return activityActionList;
        }
        return null;
    }

    public int getMiniRefreshMin() {
        if (this.list != null) {
            for (ActivityAction activityAction : this.list) {
                if (activityAction == null || activityAction.refreshMinutes >= this.miniRefreshMin) continue;
                this.miniRefreshMin = activityAction.refreshMinutes;
            }
        }
        return this.miniRefreshMin;
    }

    @Override
    public boolean isExpire() {
        if (this.list != null) {
            for (ActivityAction activityAction : this.list) {
                if (!activityAction.isExpire()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (RuntimeContext.isInGray()) {
            return "RoomActivityActionList=list:" + this.list + ",version=" + this.version + ",miniRefreshMin=" + this.miniRefreshMin;
        }
        return "list:" + (this.list != null ? this.list.size() : 0);
    }
}

