/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.yyvoicemanager;

import android.os.Handler;
import android.os.HandlerThread;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.util.concurrent.ConcurrentHashMap;

public class VoiceHandlerThread {
    private static HandlerThread sBackgroundThread = null;
    private static Handler sBackgroundHandler = null;
    private static ConcurrentHashMap<Runnable, Runnable> mCacheRunnable = new ConcurrentHashMap();

    private static synchronized void createBackgroundThread() {
        if (sBackgroundThread == null) {
            sBackgroundThread = new HandlerThread("YYVoiceHandlerThread", 0);
            sBackgroundThread.start();
            sBackgroundHandler = new Handler(sBackgroundThread.getLooper());
        }
    }

    public static void post(Runnable runnable2) {
        VoiceHandlerThread.post(runnable2, null, 0L);
    }

    public static void postDelay(Runnable runnable2, Long delay) {
        VoiceHandlerThread.post(runnable2, null, delay);
    }

    public static void post(final Runnable runnable2, final Runnable callbackRunnable, Long delay) {
        if (runnable2 == null) {
            return;
        }
        VoiceHandlerThread.createBackgroundThread();
        Runnable realRunnable2 = new Runnable(){

            @Override
            public void run() {
                runnable2.run();
                if (callbackRunnable != null) {
                    YYTaskExecutor.postToMainThread((Runnable)callbackRunnable);
                }
                mCacheRunnable.remove(runnable2);
            }
        };
        mCacheRunnable.put(runnable2, realRunnable2);
        sBackgroundHandler.postDelayed(realRunnable2, delay.longValue());
    }

    public static boolean isCurrentVoiceThread() {
        return Thread.currentThread() == sBackgroundThread;
    }

    public static void executeInVoiceThread(Runnable runnable2) {
        if (VoiceHandlerThread.isCurrentVoiceThread()) {
            runnable2.run();
        } else {
            VoiceHandlerThread.post(runnable2);
        }
    }

    public static void removeTask(Runnable r) {
        Runnable remove = mCacheRunnable.remove(r);
        if (remove != null) {
            sBackgroundHandler.removeCallbacks(remove);
        } else {
            sBackgroundHandler.removeCallbacks(r);
        }
    }
}

