/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.officialvoice.record;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatView;
import com.yy.hiyo.voice.base.offlinevoice.VoiceChatInfo;
import com.yy.hiyo.voice.base.offlinevoice.VoicePlayState;
import com.yy.voice.R;
import com.yy.voice.officialvoice.record.IVoiceView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VoiceChatView
extends YYConstraintLayout
implements IVoiceChatView {
    private static final String TAG = "VoiceChatView";
    private VoiceChatInfo voiceInfo;
    private static final int MIN_WIDTH = ResolutionUtils.dip2Px((float)114.0f);
    private static final int MAX_WIDTH = (int)((double)ScreenUtils.getInstance().getWidthPixels() * 0.7);
    private static final int DIF_WIDTH = MAX_WIDTH - MIN_WIDTH;
    private Animation loadingAni;
    private boolean isMe;
    @NotNull
    private final IVoiceView iView;
    private ProgressBar progressBar;
    private YYImageView btnOperator;
    private YYTextView timer;
    private YYView line;

    public VoiceChatView(@Nullable Context context, boolean isMe, @NotNull IVoiceView iView) {
        super(context);
        this.isMe = isMe;
        this.iView = iView;
        this.create();
    }

    private final void create() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.voice_chat_view_holder, (ViewGroup)this, true);
        this.updateSideUi(this.isMe);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View it) {
                if (VoiceChatView.this.voiceInfo != null) {
                    VoiceChatView.this.iView.onClickVoice(VoiceChatView.this.voiceInfo);
                }
            }
        });
    }

    private final void updateSideUi(boolean myself) {
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.btnOperator = (YYImageView)this.findViewById(R.id.btnOperator);
        this.timer = (YYTextView)this.findViewById(R.id.timer);
        this.line = (YYView)this.findViewById(R.id.line);
        if (myself) {
            this.progressBar.setProgressDrawable(ResourceUtils.getDrawable((int)R.drawable.voice_progress_bg_me));
            this.btnOperator.setImageResource(R.drawable.voice_play_me);
            this.timer.setBackgroundResource(R.drawable.voice_time_bg_me);
            this.line.setBackgroundColor(ColorUtils.parseColor((String)"#88FF9621"));
        } else {
            this.progressBar.setProgressDrawable(ResourceUtils.getDrawable((int)R.drawable.voice_progress_bg_other));
            this.btnOperator.setImageResource(R.drawable.voice_play_other);
            this.timer.setBackgroundResource(R.drawable.voice_time_bg_other);
            this.line.setBackgroundColor(ColorUtils.parseColor((String)"#88888888"));
        }
    }

    public void bindVoiceInfo(@NotNull VoiceChatInfo info) {
        boolean myself;
        VoiceChatInfo curInfo = this.iView.getCurrentPlayInfo();
        if (curInfo != null && curInfo != info && StringUtils.equal((String)curInfo.getUrl(), (String)info.getUrl())) {
            info = curInfo;
        }
        if (this.isMe != (myself = info.getMyself())) {
            this.isMe = myself;
            this.updateSideUi(this.isMe);
        }
        long min = info.getDuration() / 1000L;
        this.timer.setText((CharSequence)StringUtils.format((String)"%d:%02d", (Object[])new Object[]{min / 60L, min % 60L}));
        this.setViewWidth(info.getDuration());
        if (this.voiceInfo != info) {
            if (this.voiceInfo != null) {
                Kvo.autoUnbindingFrom((KvoSource)this.voiceInfo, (Object)((Object)this));
            }
            this.voiceInfo = info;
            Kvo.autoBindingTo((KvoSource)this.voiceInfo, (Object)((Object)this));
        }
    }

    private final void setViewWidth(float millis) {
        int width = MIN_WIDTH;
        if (millis >= 60000.0f) {
            width = MAX_WIDTH;
        } else if (millis > 1000.0f) {
            width = (int)((float)MIN_WIDTH + millis / 60000.0f * (float)DIF_WIDTH);
        }
        ViewGroup.LayoutParams lp = this.progressBar.getLayoutParams();
        lp.width = width;
        this.progressBar.setLayoutParams(lp);
    }

    @KvoMethodAnnotation(sourceClass=VoiceChatInfo.class, name="progress", thread=1)
    public final void updatePlayProgress(KvoEventIntent event) {
        long total = ((VoiceChatInfo)event.source()).getDuration();
        long cur = ((VoiceChatInfo)event.source()).getProgress();
        MLog.debug((Object)TAG, (String)"updatePlayProgress total: %d, cur: %d", (Object[])new Object[]{total, cur});
        float progress = (float)cur * 100.0f / (float)total;
        this.setProgress((int)progress);
    }

    @KvoMethodAnnotation(sourceClass=VoiceChatInfo.class, name="state", thread=1)
    public final void updateState(KvoEventIntent event) {
        VoicePlayState state = (VoicePlayState)event.newValue();
        MLog.debug((Object)TAG, (String)"updateState state: %s", (Object[])new Object[]{state});
        this.updateStateUi(state);
    }

    private void updateStateUi(VoicePlayState state) {
        if (state == VoicePlayState.LOADING) {
            this.loading();
        } else if (state == VoicePlayState.PLAYING) {
            this.startPlay();
        } else if (state == VoicePlayState.PAUSE) {
            this.stopState();
        } else if (state == VoicePlayState.COMPLETE) {
            this.setProgress(100);
            this.stopPlay();
        } else if (state != VoicePlayState.NONE) {
            this.stopPlay();
        } else {
            this.stopState();
        }
    }

    private final void setProgress(int progress) {
        if (progress > 0 && Build.VERSION.SDK_INT >= 24) {
            this.progressBar.setProgress(progress, true);
        } else {
            this.progressBar.setProgress(progress);
        }
    }

    public final void stopPlay() {
        MLog.debug((Object)TAG, (String)"stopPlay", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public final void run() {
                VoiceChatView.this.setProgress(0);
                VoiceChatView.this.stopState();
            }
        }, (long)200L);
        this.btnOperator.clearAnimation();
    }

    private final void stopState() {
        if (this.isMe) {
            this.btnOperator.setImageResource(R.drawable.voice_play_me);
        } else {
            this.btnOperator.setImageResource(R.drawable.voice_play_other);
        }
    }

    public final void resumePlay() {
        this.startState();
    }

    public final void startPlay() {
        this.btnOperator.clearAnimation();
        this.startState();
    }

    private final void startState() {
        if (this.isMe) {
            this.btnOperator.setImageResource(R.drawable.voice_pause_me);
        } else {
            this.btnOperator.setImageResource(R.drawable.voice_pause_other);
        }
    }

    private final void loading() {
        if (this.loadingAni == null) {
            this.loadingAni = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.rotate_anim);
            this.loadingAni.setInterpolator((Interpolator)new LinearInterpolator());
        }
        this.btnOperator.setImageResource(R.drawable.voice_loading);
        this.btnOperator.startAnimation(this.loadingAni);
    }

    public final boolean isMe() {
        return this.isMe;
    }

    public final void setMe(boolean var1) {
        this.isMe = var1;
    }
}

