/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.officialvoice;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.record.base.AudioPlayInfo;
import com.yy.hiyo.record.base.AudioRecordInfo;
import com.yy.hiyo.record.base.AudioUploadInfo;
import com.yy.hiyo.record.base.IRecordService;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.offlinevoice.IRecordBehavior;
import com.yy.hiyo.voice.base.offlinevoice.IRecordLifecycle;
import com.yy.hiyo.voice.base.offlinevoice.ISendMsgCallback;
import com.yy.hiyo.voice.base.offlinevoice.ISendMsgState;
import com.yy.hiyo.voice.base.offlinevoice.IVoiceChatHandler;
import com.yy.hiyo.voice.base.offlinevoice.VoiceChatInfo;
import com.yy.hiyo.voice.base.offlinevoice.VoicePlayState;
import com.yy.hiyo.voice.base.offlinevoice.VoiceScene;
import com.yy.voice.R;
import com.yy.voice.officialvoice.record.IRecordViewCallback;
import com.yy.voice.officialvoice.record.IVoiceView;
import com.yy.voice.officialvoice.record.RecordView;
import com.yy.voice.officialvoice.record.VoiceChatView;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VoiceChatHandler
implements IVoiceChatHandler,
IRecordViewCallback,
IVoiceView {
    private static final String TAG = "VoiceChatHandler";
    private static final String BUSINESS = "voicechat";
    public static final int MAX_RECORD_TIME = 60000;
    private String roomId;
    private RecordView recordView = null;
    private AudioRecordInfo recordingInfo = null;
    private AudioPlayInfo playInfo = null;
    private VoiceChatInfo voiceChatInfo = null;
    private Context mContext;
    private IRecordLifecycle lifecycle;
    private IRecordBehavior behavior;
    private final Map<String, ISendMsgState> sendMsgStateMap = new HashMap<String, ISendMsgState>();
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public VoiceChatHandler(String roomId, IRecordBehavior behavior) {
        MLog.info((Object)TAG, (String)"new VoiceChatHandler roomId: %s", (Object[])new Object[]{roomId});
        this.roomId = roomId;
        this.behavior = behavior;
    }

    @NotNull
    public View getRecordView(Context context, VoiceScene scene) {
        if (this.recordView == null) {
            this.mContext = context;
            this.recordView = new RecordView(this.mContext, scene);
            this.recordView.setViewCallback(this);
        }
        if (this.recordView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.recordView.getParent()).removeView((View)this.recordView);
        }
        this.recordView.post(new Runnable(){

            @Override
            public void run() {
                if (VoiceChatHandler.this.recordView != null) {
                    Rect rect = VoiceChatHandler.this.getRecordIconRect();
                    int height = rect.bottom - rect.top;
                    VoiceChatHandler.this.recordView.setBarHeight(height);
                }
            }
        });
        return this.recordView;
    }

    public void destroy() {
        MLog.info((Object)TAG, (String)"destroy roomId: %s", (Object[])new Object[]{this.roomId});
        this.cancelRecord(true);
        this.stopPlay();
        this.recordView = null;
    }

    @Override
    public boolean startRecord() {
        this.cancelRecord(false);
        this.stopPlay();
        int support = ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).isRecordSupport();
        MLog.info((Object)TAG, (String)"startRecord support: %d", (Object[])new Object[]{support});
        if (support == 2) {
            PermissionHelper.requestRecordAudioPermission((Activity)((Activity)this.mContext), (IPermissionListener)new IPermissionListener(){

                public void onPermissionGranted(@NonNull String[] permission) {
                }

                public void onPermissionDenied(@NonNull String[] permission) {
                }
            });
            return false;
        }
        if (support == 3) {
            return false;
        }
        if (this.lifecycle != null) {
            this.lifecycle.onStart();
        }
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                VoiceChatHandler.this.recordingInfo = ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).startRecord(VoiceChatHandler.BUSINESS, VoiceChatHandler.this.roomId, 60000);
                if (VoiceChatHandler.this.recordingInfo != null) {
                    VoiceChatHandler.this.mBinder.singleBindSourceTo(VoiceChatHandler.this.getBindKey(VoiceChatHandler.this.recordingInfo), (KvoSource)VoiceChatHandler.this.recordingInfo);
                } else {
                    if (VoiceChatHandler.this.recordView != null) {
                        VoiceChatHandler.this.recordView.resetAll();
                    }
                    MLog.error((Object)VoiceChatHandler.TAG, (String)"startRecord recordingInfo is null", (Object[])new Object[0]);
                }
            }
        }, 0L);
        return true;
    }

    @Override
    public void cancelRecord(boolean resetView) {
        final AudioRecordInfo info = this.recordingInfo;
        if (info != null) {
            this.mQueueTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).cancelRecord(info);
                }
            }, 0L);
            this.clearRecord(resetView);
            this.unbindRecord(info);
        }
        if (this.lifecycle != null) {
            this.lifecycle.onSlideCancel();
        }
    }

    @Override
    public void finishRecord() {
        final AudioRecordInfo info = this.recordingInfo;
        if (info != null) {
            this.mQueueTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).stopRecord(info, true);
                }
            }, 0L);
        }
    }

    @Override
    @NotNull
    public Rect getRecordIconRect() {
        return this.behavior.getRecordIconRect();
    }

    @Override
    public boolean canRecord() {
        Object isPlaying = MsgDispatcher.getInstance().sendMessageSync(AppbaseMsgDef.ChannelMsgDef.IS_PLAYING_MUSIC);
        if (isPlaying instanceof Boolean && ((Boolean)isPlaying).booleanValue()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_playing_music_can_not_record, (int)0);
            return false;
        }
        return this.behavior.onTouchDown() && !this.isOpenMic();
    }

    @Override
    public boolean isOpenMic() {
        return ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).isAudioPublishEnabled(1);
    }

    @Override
    public void onClickVoice(@NotNull VoiceChatInfo info) {
        if (this.isOpenMic()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.short_tips_can_not_play, (int)0);
            return;
        }
        String url = info.getUrl();
        VoiceChatInfo varVoiceChatInfo = this.voiceChatInfo;
        if (varVoiceChatInfo != null && TextUtils.equals((CharSequence)varVoiceChatInfo.getUrl(), (CharSequence)url)) {
            if (this.voiceChatInfo != info) {
                this.voiceChatInfo = info;
            }
            if (this.playInfo != null && (this.playInfo.getState() == AudioPlayInfo.State.START || this.playInfo.getState() == AudioPlayInfo.State.RESUME)) {
                this.pausePlay(info);
                return;
            }
            if (this.playInfo != null && this.playInfo.getState() == AudioPlayInfo.State.PAUSE) {
                this.resumePlay(info);
                return;
            }
        }
        this.startPlay(info);
    }

    @Override
    @Nullable
    public VoiceChatInfo getCurrentPlayInfo() {
        return this.voiceChatInfo;
    }

    private void startPlay(final VoiceChatInfo info) {
        VoiceChatInfo varVoiceChatInfo = this.voiceChatInfo;
        final String url = info.getUrl();
        if (varVoiceChatInfo != null && !TextUtils.equals((CharSequence)varVoiceChatInfo.getUrl(), (CharSequence)url)) {
            this.stopPlay();
        }
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.mQueueTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    VoiceChatHandler.this.voiceChatInfo = info;
                    VoiceChatHandler.this.voiceChatInfo.setValue("state", (Object)VoicePlayState.LOADING);
                    VoiceChatHandler.this.playInfo = ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).playRecord(url);
                    ((VoiceChatHandler)VoiceChatHandler.this).playInfo.progressInterval = 50L;
                    VoiceChatHandler.this.mBinder.singleBindSourceTo((KvoSource)VoiceChatHandler.this.playInfo);
                }
            }, 0L);
            if (this.lifecycle != null) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VoiceChatHandler.this.lifecycle.onStart();
                    }
                });
            }
        }
    }

    private void pausePlay(final @NotNull VoiceChatInfo info) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AudioPlayInfo varPlayInfo = VoiceChatHandler.this.playInfo;
                VoiceChatInfo varVoiceChatInfo = VoiceChatHandler.this.voiceChatInfo;
                if (varPlayInfo != null && varVoiceChatInfo != null && TextUtils.equals((CharSequence)varVoiceChatInfo.getUrl(), (CharSequence)info.getUrl())) {
                    ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).pausePlayRecord(varPlayInfo);
                    varVoiceChatInfo.setValue("state", (Object)VoicePlayState.PAUSE);
                    if (VoiceChatHandler.this.lifecycle != null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                VoiceChatHandler.this.lifecycle.onPause();
                            }
                        });
                    }
                }
            }
        }, 0L);
    }

    private void resumePlay(final @NotNull VoiceChatInfo info) {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AudioPlayInfo varPlayInfo = VoiceChatHandler.this.playInfo;
                VoiceChatInfo varVoiceChatInfo = VoiceChatHandler.this.voiceChatInfo;
                if (varPlayInfo != null && varVoiceChatInfo != null && TextUtils.equals((CharSequence)varVoiceChatInfo.getUrl(), (CharSequence)info.getUrl())) {
                    ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).resumePlayRecord(varPlayInfo);
                    varVoiceChatInfo.setValue("state", (Object)VoicePlayState.PLAYING);
                    if (VoiceChatHandler.this.lifecycle != null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                VoiceChatHandler.this.lifecycle.onStart();
                            }
                        });
                    }
                }
            }
        }, 0L);
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="time", thread=1)
    void onRecordTimeChange(KvoEventIntent event) {
        if (this.recordView != null) {
            this.recordView.updateTime(((AudioRecordInfo)event.source()).getTime() / 1000L);
        }
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="state", thread=1)
    void onAudioRecordStateChanged(KvoEventIntent event) {
        AudioRecordInfo.State state = (AudioRecordInfo.State)event.newValue();
        final AudioRecordInfo info = (AudioRecordInfo)event.source();
        MLog.info((Object)TAG, (String)"onAudioRecordStateChanged info: %d, oldState: %s, newState: %s", (Object[])new Object[]{info.hashCode(), event.oldValue(), state});
        if (state == AudioRecordInfo.State.COMPLETE) {
            if (this.lifecycle != null) {
                this.lifecycle.onRecordSuccess(info.getTotalTime());
            }
            this.clearRecord(info == this.recordingInfo);
            ISendMsgState msgState = this.behavior.sendMsg(info.getLocalId(), info.getTotalTime(), new ISendMsgCallback(){

                public void onSuccess() {
                    MLog.info((Object)VoiceChatHandler.TAG, (String)"send msg success", (Object[])new Object[0]);
                    if (VoiceChatHandler.this.lifecycle != null) {
                        VoiceChatHandler.this.lifecycle.onSuccess(info.getTotalTime());
                    }
                }

                public void onFail() {
                    MLog.error((Object)VoiceChatHandler.TAG, (String)"send msg fail", (Object[])new Object[0]);
                }
            });
            if (msgState != null) {
                msgState.prepare();
                this.sendMsgStateMap.put(info.getLocalId(), msgState);
            }
        } else if (state == AudioRecordInfo.State.ERROR) {
            this.clearRecord(info == this.recordingInfo);
            this.unbindRecord(info);
        } else if (state == AudioRecordInfo.State.UPLOAD_SUCCESS) {
            this.unbindRecord(info);
        } else if (state == AudioRecordInfo.State.UPLOAD_FAILED) {
            this.unbindRecord(info);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioUploadInfo.class, thread=2)
    public void onAudioUploadStateChanged(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioUploadInfo info = (AudioUploadInfo)event.source();
        AudioUploadInfo.State state = (AudioUploadInfo.State)event.newValue();
        MLog.info((Object)TAG, (String)"onAudioUploadStateChanged info: %d, oldState: %s, newState: %s", (Object[])new Object[]{info.hashCode(), event.oldValue(), state});
        if (state == AudioUploadInfo.State.CANCEL || state == AudioUploadInfo.State.FAILED) {
            ISendMsgState msgState = this.sendMsgStateMap.remove(info.getLocalId());
            if (msgState != null) {
                msgState.fail();
            }
            this.mBinder.clearKvoConnection(this.getBindKey(info));
        } else if (state == AudioUploadInfo.State.COMPLETE) {
            ISendMsgState msgState = this.sendMsgStateMap.remove(info.getLocalId());
            if (msgState != null) {
                msgState.finish(info.getUrl());
            }
            this.mBinder.clearKvoConnection(this.getBindKey(info));
        }
    }

    @KvoMethodAnnotation(sourceClass=AudioRecordInfo.class, name="uploadInfo", thread=2)
    public void onAudioRecordUpload(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        AudioUploadInfo uploadInfo = (AudioUploadInfo)event.newValue();
        if (uploadInfo != null) {
            this.addUpload(uploadInfo.getLocalId(), uploadInfo);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=AudioPlayInfo.class, thread=1)
    public void onAudioPlayStateChanged(KvoEventIntent event) {
        AudioPlayInfo.State state = (AudioPlayInfo.State)event.newValue();
        MLog.info((Object)TAG, (String)"onAudioPlayStateChanged oldState: %s, newState: %s", (Object[])new Object[]{event.oldValue(), state});
        AudioPlayInfo info = (AudioPlayInfo)event.source();
        if (state == AudioPlayInfo.State.ERROR) {
            if (this.voiceChatInfo != null) {
                this.voiceChatInfo.setValue("state", (Object)VoicePlayState.ERROR);
            }
            this.stopPlay();
        } else if (state == AudioPlayInfo.State.START) {
            if (this.voiceChatInfo != null) {
                this.voiceChatInfo.setValue("state", (Object)VoicePlayState.PLAYING);
            }
        } else if (state == AudioPlayInfo.State.PAUSE) {
            if (this.voiceChatInfo != null) {
                this.voiceChatInfo.setValue("state", (Object)VoicePlayState.PAUSE);
            }
        } else if (state == AudioPlayInfo.State.COMPLETE) {
            if (this.voiceChatInfo != null) {
                this.voiceChatInfo.setValue("state", (Object)VoicePlayState.COMPLETE);
            }
            this.stopPlay();
        } else if (state == AudioPlayInfo.State.DOWNLOAD_FAILED) {
            if (this.voiceChatInfo != null) {
                this.voiceChatInfo.setValue("state", (Object)VoicePlayState.ERROR);
            }
            this.stopPlay();
        }
    }

    @KvoMethodAnnotation(name="time", sourceClass=AudioPlayInfo.class, thread=1)
    public void onAudioPlayProgress(KvoEventIntent event) {
        AudioPlayInfo info = (AudioPlayInfo)event.source();
        AudioPlayInfo.State state = info.getState();
        if ((state == AudioPlayInfo.State.START || state == AudioPlayInfo.State.RESUME) && this.voiceChatInfo != null) {
            this.voiceChatInfo.setValue("progress", (Object)info.getTime());
        }
    }

    @NotNull
    public View createVoiceView(Context context, boolean me) {
        return new VoiceChatView(context, me, this);
    }

    public void setLifecycle(@NotNull IRecordLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void allowRecord(boolean show, boolean enable, @NotNull String disableTips) {
        if (this.recordView == null) {
            return;
        }
        this.recordView.setEnable(enable, disableTips);
        if (show) {
            this.recordView.setVisibility(0);
        } else {
            this.recordView.setVisibility(8);
        }
    }

    public void onDeleteMsg(@NotNull String audioUrl) {
        if (this.voiceChatInfo != null && StringUtils.equal((String)this.voiceChatInfo.getUrl(), (String)audioUrl)) {
            this.stopPlay();
        }
    }

    private void stopPlay() {
        this.mQueueTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                VoiceChatInfo voiceInfo = VoiceChatHandler.this.voiceChatInfo;
                VoiceChatHandler.this.voiceChatInfo = null;
                AudioPlayInfo info = VoiceChatHandler.this.playInfo;
                VoiceChatHandler.this.playInfo = null;
                if (voiceInfo != null && info != null && TextUtils.equals((CharSequence)voiceInfo.getUrl(), (CharSequence)info.getRecordUrl())) {
                    ((IRecordService)ServiceManagerProxy.getServiceManager().getService(IRecordService.class)).stopPlayRecord(info);
                    VoiceChatHandler.this.mBinder.clearKvoConnection(AudioPlayInfo.class.getName());
                    voiceInfo.setValue("state", (Object)VoicePlayState.STOP);
                }
            }
        }, 0L);
    }

    private void clearRecord(boolean resetView) {
        if (this.lifecycle != null) {
            this.lifecycle.onFinish();
        }
        if (resetView && this.recordView != null) {
            this.recordView.resetAll();
        }
    }

    private void addUpload(String localId, AudioUploadInfo info) {
        if (!TextUtils.isEmpty((CharSequence)localId) && info != null) {
            this.mBinder.singleBindSourceTo(this.getBindKey(info), (KvoSource)info);
        }
    }

    private void unbindRecord(AudioRecordInfo info) {
        MLog.info((Object)TAG, (String)"unbindRecord info: %s, recordingInfo: %s", (Object[])new Object[]{info, this.recordingInfo});
        if (info != null) {
            this.mBinder.clearKvoConnection(this.getBindKey(info));
            if (this.recordingInfo == info) {
                this.recordingInfo = null;
            }
        }
    }

    private String getBindKey(Object kvoSource) {
        String key = kvoSource.getClass().getName() + kvoSource.hashCode();
        MLog.debug((Object)TAG, (String)"getBindKey key: %s", (Object[])new Object[]{key});
        return key;
    }
}

