/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.mediav1impl.watcher.strategy;

import android.content.Context;
import android.view.ViewGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.voice.base.bean.event.OnNoMatchCodeRateCallback;
import com.yy.hiyo.voice.base.mediav1.bean.CdnStreamInfo;
import com.yy.hiyo.voice.base.mediav1.bean.From;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.bean.StreamHolder;
import com.yy.hiyo.voice.base.mediav1.bean.StreamInfo;
import com.yy.hiyo.voice.base.mediav1.bean.StreamKt;
import com.yy.hiyo.voice.base.mediav1.bean.StreamSubType;
import com.yy.hiyo.voice.base.mediav1.bean.StreamType;
import com.yy.hiyo.voice.base.mediav1.protocal.IStreamManager;
import com.yy.hiyo.voice.base.mediav1.protocal.IWatcherManager;
import com.yy.hiyo.voice.base.mediav1.protocal.WatchLiveStrategy;
import com.yy.voice.mediav1impl.VideoUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J4\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/yy/voice/mediav1impl/watcher/strategy/LunMicRadioWatcherStrategy;", "Lcom/yy/hiyo/voice/base/mediav1/protocal/WatchLiveStrategy;", "room", "Lcom/yy/hiyo/voice/base/mediav1/bean/IMediaRoom;", "(Lcom/yy/hiyo/voice/base/mediav1/bean/IMediaRoom;)V", "WAIT_CHECK_STREAM_GAP", "", "timeoutTask", "Lcom/yy/voice/mediav1impl/watcher/strategy/LunMicRadioWatcherStrategy$TimeOutTask;", "isRightState", "", "onStreamArrive", "", "holder", "Lcom/yy/hiyo/voice/base/mediav1/bean/StreamHolder;", "added", "", "Lcom/yy/hiyo/voice/base/mediav1/bean/StreamInfo;", "type", "Lcom/yy/hiyo/voice/base/mediav1/bean/StreamType;", "postTimeOutCheck", "uid", "removeTimeOutCheck", "startWatchVideo", "codeRate", "", "container", "Landroid/view/ViewGroup;", "callback", "Lcom/yy/hiyo/voice/base/bean/event/OnNoMatchCodeRateCallback;", "waitForTimeout", "stop", "updateStreamType", "streamSubType", "Lcom/yy/hiyo/voice/base/mediav1/bean/StreamSubType;", "updateWatchUid", "TimeOutTask", "voice_debug"})
public final class LunMicRadioWatcherStrategy
extends WatchLiveStrategy {
    private final long WAIT_CHECK_STREAM_GAP = 5000L;
    private final TimeOutTask timeoutTask;

    public void onStreamArrive(@NotNull StreamHolder holder, @NotNull List<? extends StreamInfo> added, @NotNull StreamType type) {
        Object v0;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull(added, (String)"added");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            super.onStreamArrive(holder, added, type);
            MLog.info((Object)this.getTAG(), (String)("onStreamArrive type[" + type + "], targetStream[" + this.getMTargetStream() + ']'), (Object[])new Object[0]);
            Iterable iterable = added;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                StreamInfo it = (StreamInfo)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getUid(), (Object)String.valueOf(this.getMWatchUid()))) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        StreamInfo find = v0;
        if (find != null) {
            if (type == StreamType.STREAM_TYPE_CDN_AV) {
                MLog.info((Object)this.getTAG(), (String)("onStreamArrive find target uid:" + this.getMWatchUid() + "'s cdn stream, notify now"), (Object[])new Object[0]);
                this.removeTimeOutCheck();
                this.notifyStreamStateChange(find, false);
            } else if (type == StreamType.STREAM_TYPE_THUNDER_VIDEO) {
                MLog.info((Object)this.getTAG(), (String)("onStreamArrive find target uid:" + this.getMWatchUid() + "'s thunder stream, waiting cdn start"), (Object[])new Object[0]);
                IStreamManager iStreamManager = this.getRoom().getStreamManager();
                if (iStreamManager != null) {
                    iStreamManager.forceRefreshLineInfo();
                }
                this.postTimeOutCheck(this.getMWatchUid());
            }
        }
    }

    public void updateWatchUid(long uid) {
        if (this.getMWatchUid() != 0L && this.getMWatchUid() != uid) {
            StreamInfo streamInfo = this.getCurStream();
            if (streamInfo != null) {
                StreamInfo streamInfo2 = streamInfo;
                boolean bl = false;
                boolean bl2 = false;
                StreamInfo it = streamInfo2;
                boolean bl3 = false;
                this.notifyStreamStateChange(it, true);
            }
        }
        this.updateStreamType(StreamSubType.STREAM_SUBTYPE_CDN_FLV);
        super.updateWatchUid(uid);
        Function0<Unit> $fun$checkCache$2 = new Function0<Unit>(this, uid){
            final /* synthetic */ LunMicRadioWatcherStrategy this$0;
            final /* synthetic */ long $uid;

            public final void invoke() {
                LunMicRadioWatcherStrategy.access$removeTimeOutCheck(this.this$0);
                StreamInfo cdnStream = null;
                StreamInfo thunderStream = null;
                Object object = this.this$0.getRoom().getStreamManager();
                if (object != null && (object = object.getStreamHolder()) != null && (object = object.getStreams()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        StreamInfo it = (StreamInfo)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getUid(), (Object)String.valueOf(this.$uid))) continue;
                        if (it.getType() == StreamKt.getCdnType() && cdnStream == null) {
                            cdnStream = it;
                            continue;
                        }
                        if (it.getType() != StreamKt.getThunderType() || thunderStream != null) continue;
                        thunderStream = it;
                    }
                }
                if (cdnStream != null) {
                    StreamInfo streamInfo = cdnStream;
                    if (streamInfo == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.notifyStreamStateChange(streamInfo, false);
                } else if (thunderStream != null) {
                    LunMicRadioWatcherStrategy.access$postTimeOutCheck(this.this$0, this.$uid);
                } else {
                    MLog.info((Object)LunMicRadioWatcherStrategy.access$getTAG$p(this.this$0), (String)("wait uid:" + this.$uid), (Object[])new Object[0]);
                }
            }
            {
                this.this$0 = lunMicRadioWatcherStrategy;
                this.$uid = l;
                super(0);
            }
        };
        if (this.timeoutTask.getPending()) {
            if (this.timeoutTask.getCheckingUid() == uid) {
                MLog.info((Object)this.getTAG(), (String)("uid:" + uid + " is checking wait time out"), (Object[])new Object[0]);
            } else {
                $fun$checkCache$2.invoke();
            }
        } else {
            $fun$checkCache$2.invoke();
        }
    }

    private final void postTimeOutCheck(long uid) {
        this.removeTimeOutCheck();
        this.timeoutTask.setCheckingUid(uid);
        this.timeoutTask.setPending(true);
        YYTaskExecutor.execute((Runnable)this.timeoutTask, (long)this.WAIT_CHECK_STREAM_GAP);
    }

    private final void removeTimeOutCheck() {
        this.timeoutTask.setCheckingUid(0L);
        this.timeoutTask.setPending(false);
        YYTaskExecutor.removeTask((Runnable)this.timeoutTask);
    }

    public void updateStreamType(@NotNull StreamSubType streamSubType) {
        Intrinsics.checkParameterIsNotNull((Object)streamSubType, (String)"streamSubType");
        if (streamSubType == StreamSubType.STREAM_SUBTYPE_CDN_DASH || streamSubType == StreamSubType.STREAM_SUBTYPE_THUNDER_TRANS) {
            super.updateStreamType(StreamSubType.STREAM_SUBTYPE_CDN_FLV);
        } else {
            super.updateStreamType(streamSubType);
        }
    }

    private final boolean isRightState() {
        return this.getMWatchUid() > 0L;
    }

    @Nullable
    public StreamInfo startWatchVideo(long uid, @NotNull String codeRate, @NotNull ViewGroup container, @Nullable OnNoMatchCodeRateCallback callback2, boolean waitForTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)codeRate, (String)"codeRate");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        super.startWatchVideo(uid, codeRate, container, callback2, waitForTimeout);
        Object object = this.getRoom().getStreamManager();
        List list = object != null && (object = object.getStreamHolder()) != null && (object = object.getStreams()) != null ? (List)object : CollectionsKt.emptyList();
        StreamSubType streamSubType = this.getMTargetStream();
        if (streamSubType == null) {
            streamSubType = StreamSubType.STREAM_SUBTYPE_CDN_FLV;
        }
        StreamInfo bestMatchLineInfo = VideoUtils.INSTANCE.getBestMatchLIneInfoForLunMic(codeRate, list, uid, streamSubType);
        if (bestMatchLineInfo != null) {
            this.setCurStream(bestMatchLineInfo);
            MLog.info((Object)this.getTAG(), (String)("startWatchVideo info:" + bestMatchLineInfo), (Object[])new Object[0]);
            IWatcherManager iWatcherManager = this.getRoom().getWatcherManager();
            if (iWatcherManager != null) {
                IWatcherManager.DefaultImpls.watchLive$default((IWatcherManager)iWatcherManager, (StreamInfo)bestMatchLineInfo, (ViewGroup)container, (From)From.NORMAL, (boolean)false, (int)8, null);
            }
            if (RuntimeContext.sIsDebuggable) {
                String strMsg = bestMatchLineInfo instanceof CdnStreamInfo ? "cdn\u89c2\u770b:" + bestMatchLineInfo.getCodeRate() : "\u6e90\u6d41\u89c2\u770b";
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)strMsg, (int)0);
                OnNoMatchCodeRateCallback onNoMatchCodeRateCallback = callback2;
                if (onNoMatchCodeRateCallback != null) {
                    onNoMatchCodeRateCallback.codeRadeChangeInfo(strMsg);
                }
            }
            return bestMatchLineInfo;
        }
        this.setCurStream(null);
        MLog.error((Object)this.getTAG(), (String)"startWatchVideo with no stream!!!!", (Object[])new Object[0]);
        return null;
    }

    public void stop() {
        super.stop();
        this.removeTimeOutCheck();
    }

    public LunMicRadioWatcherStrategy(@NotNull IMediaRoom room) {
        Intrinsics.checkParameterIsNotNull((Object)room, (String)"room");
        super(room);
        this.WAIT_CHECK_STREAM_GAP = 5000L;
        this.timeoutTask = new TimeOutTask();
    }

    public static final /* synthetic */ void access$setTAG$p(LunMicRadioWatcherStrategy $this, String string2) {
        $this.setTAG(string2);
    }

    public static final /* synthetic */ void access$removeTimeOutCheck(LunMicRadioWatcherStrategy $this) {
        $this.removeTimeOutCheck();
    }

    public static final /* synthetic */ void access$postTimeOutCheck(LunMicRadioWatcherStrategy $this, long uid) {
        $this.postTimeOutCheck(uid);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/yy/voice/mediav1impl/watcher/strategy/LunMicRadioWatcherStrategy$TimeOutTask;", "Ljava/lang/Runnable;", "(Lcom/yy/voice/mediav1impl/watcher/strategy/LunMicRadioWatcherStrategy;)V", "checkingUid", "", "getCheckingUid", "()J", "setCheckingUid", "(J)V", "pending", "", "getPending", "()Z", "setPending", "(Z)V", "run", "", "voice_debug"})
    public final class TimeOutTask
    implements Runnable {
        private long checkingUid;
        private boolean pending;

        public final long getCheckingUid() {
            return this.checkingUid;
        }

        public final void setCheckingUid(long l) {
            this.checkingUid = l;
        }

        public final boolean getPending() {
            return this.pending;
        }

        public final void setPending(boolean bl) {
            this.pending = bl;
        }

        @Override
        public void run() {
            StreamInfo bestMatchLineInfo;
            StreamInfo streamInfo;
            List streams;
            if (!LunMicRadioWatcherStrategy.this.isRightState() || this.checkingUid <= 0L || !this.pending) {
                MLog.info((Object)LunMicRadioWatcherStrategy.this.getTAG(), (String)("timeoutTask isRightState error!!! checkingUid:" + this.checkingUid + ", " + "pending:" + this.pending), (Object[])new Object[0]);
                return;
            }
            Object object = LunMicRadioWatcherStrategy.this.getRoom().getStreamManager();
            List list = streams = object != null && (object = object.getStreamHolder()) != null && (object = object.getStreams()) != null ? (List)object : CollectionsKt.emptyList();
            if (list != null) {
                Object v2;
                block6: {
                    Iterable iterable = list;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        StreamInfo it = (StreamInfo)t;
                        boolean bl3 = false;
                        String string2 = it.getUid();
                        boolean bl4 = false;
                        if (!(Long.parseLong(string2) == this.checkingUid)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                streamInfo = v2;
            } else {
                streamInfo = bestMatchLineInfo = null;
            }
            if (bestMatchLineInfo != null) {
                LunMicRadioWatcherStrategy.this.updateStreamType(bestMatchLineInfo.getSubType());
                LunMicRadioWatcherStrategy.this.notifyStreamStateChange(bestMatchLineInfo, false);
                this.pending = false;
                this.checkingUid = 0L;
            } else {
                MLog.error((Object)LunMicRadioWatcherStrategy.this.getTAG(), (String)("not match stream!!! uid:" + this.checkingUid), (Object[])new Object[0]);
            }
        }
    }
}

