/*
 * Decompiled with CFR 0.152.
 */
package com.yy.voice.mediav1impl.room;

import com.yy.hiyo.voice.base.mediav1.bean.CdnStreamInfo;
import com.yy.hiyo.voice.base.mediav1.bean.ServiceProvider;
import com.yy.hiyo.voice.base.mediav1.bean.StreamSubType;
import com.yy.hiyo.voice.base.mediav1.bean.StreamType;
import com.yy.hiyo.voice.base.mediav1.bean.ThunderVideoStreamInfo;
import com.yy.voice.mediav1impl.VideoUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.live.api.wath.MediaProtocol;
import tv.athena.live.api.wath.bean.LineStreamInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ*\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/yy/voice/mediav1impl/room/StreamInfoUtil;", "", "()V", "createCdnStreamInfo", "Lcom/yy/hiyo/voice/base/mediav1/bean/CdnStreamInfo;", "streamInfo", "Ltv/athena/live/api/wath/bean/LineStreamInfo;", "createThunderStreamInfo", "Lcom/yy/hiyo/voice/base/mediav1/bean/ThunderVideoStreamInfo;", "uid", "", "subType", "Lcom/yy/hiyo/voice/base/mediav1/bean/StreamSubType;", "createThunderTransStreamInfo", "id", "", "width", "height", "getServiceProvider", "Lcom/yy/hiyo/voice/base/mediav1/bean/ServiceProvider;", "provider", "voice_debug"})
public final class StreamInfoUtil {
    public static final StreamInfoUtil INSTANCE;

    @NotNull
    public final CdnStreamInfo createCdnStreamInfo(@NotNull LineStreamInfo streamInfo) {
        CdnStreamInfo cdnStreamInfo;
        Intrinsics.checkParameterIsNotNull((Object)streamInfo, (String)"streamInfo");
        streamInfo.getServiceProvider();
        if (streamInfo.getMediaProtocol() == MediaProtocol.DASH) {
            Object object = (Long)CollectionsKt.firstOrNull((List)streamInfo.getJoinUids());
            if (object == null || (object = String.valueOf((Long)object)) == null) {
                object = "0";
            }
            cdnStreamInfo = new CdnStreamInfo(StreamType.STREAM_TYPE_CDN_AV, StreamSubType.STREAM_SUBTYPE_CDN_DASH, (String)object, (Object)streamInfo, streamInfo.getStreamDefinition(), this.getServiceProvider(streamInfo.getServiceProvider()));
        } else {
            Object object = (Long)CollectionsKt.firstOrNull((List)streamInfo.getJoinUids());
            if (object == null || (object = String.valueOf((Long)object)) == null) {
                object = "0";
            }
            cdnStreamInfo = new CdnStreamInfo(StreamType.STREAM_TYPE_CDN_AV, StreamSubType.STREAM_SUBTYPE_CDN_FLV, (String)object, (Object)streamInfo, streamInfo.getStreamDefinition(), this.getServiceProvider(streamInfo.getServiceProvider()));
        }
        return cdnStreamInfo;
    }

    @NotNull
    public final ThunderVideoStreamInfo createThunderStreamInfo(@NotNull String uid, @NotNull StreamSubType subType) {
        Intrinsics.checkParameterIsNotNull((Object)uid, (String)"uid");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        return new ThunderVideoStreamInfo(subType, uid, 0, 0, 0, null, 56, null);
    }

    public static /* synthetic */ ThunderVideoStreamInfo createThunderStreamInfo$default(StreamInfoUtil streamInfoUtil, String string2, StreamSubType streamSubType, int n, Object object) {
        if ((n & 2) != 0) {
            streamSubType = StreamSubType.STREAM_SUBTYPE_THUNDER_RAW;
        }
        return streamInfoUtil.createThunderStreamInfo(string2, streamSubType);
    }

    @NotNull
    public final ThunderVideoStreamInfo createThunderTransStreamInfo(@NotNull String uid, int id2, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)uid, (String)"uid");
        String codeRate = VideoUtils.INSTANCE.getDefinitionByTransId(id2);
        return new ThunderVideoStreamInfo(StreamSubType.STREAM_SUBTYPE_THUNDER_TRANS, uid, id2, width, height, codeRate);
    }

    public static /* synthetic */ ThunderVideoStreamInfo createThunderTransStreamInfo$default(StreamInfoUtil streamInfoUtil, String string2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return streamInfoUtil.createThunderTransStreamInfo(string2, n, n2, n3);
    }

    private final ServiceProvider getServiceProvider(int provider) {
        ServiceProvider serviceProvider;
        switch (provider) {
            case 1: {
                serviceProvider = ServiceProvider.ALIYUN;
                break;
            }
            case 3: {
                serviceProvider = ServiceProvider.WANGSU;
                break;
            }
            case 4: {
                serviceProvider = ServiceProvider.TENCENT;
                break;
            }
            default: {
                serviceProvider = ServiceProvider.UNKNOWN;
            }
        }
        return serviceProvider;
    }

    private StreamInfoUtil() {
    }

    static {
        StreamInfoUtil streamInfoUtil;
        INSTANCE = streamInfoUtil = new StreamInfoUtil();
    }
}

