/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.translate;

import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.span.ChainSpan;
import com.yy.base.cache.JCache;
import com.yy.base.cache.JCacheContainer;
import com.yy.base.cache.JCacheKey;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.translate.R;
import com.yy.hiyo.translate.TranslateService;
import com.yy.hiyo.translate.base.ITranslate;
import com.yy.hiyo.translate.base.callback.ITranslateCallback;
import com.yy.hiyo.translate.base.data.TranslateModuleData;
import com.yy.hiyo.translate.base.data.bean.JTransTextData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.base.api.translate.TranslateReq;
import net.ihago.base.api.translate.TranslateRsp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\"\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u001cH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/yy/hiyo/translate/TranslateService;", "Lcom/yy/hiyo/translate/base/ITranslate;", "()V", "mData", "Lcom/yy/hiyo/translate/base/data/TranslateModuleData;", "getMData", "()Lcom/yy/hiyo/translate/base/data/TranslateModuleData;", "mData$delegate", "Lkotlin/Lazy;", "mTransTextDataCache", "Lcom/yy/base/cache/JCache;", "Lcom/yy/hiyo/translate/base/data/bean/JTransTextData;", "kotlin.jvm.PlatformType", "appendAtText", "", "atMsg", "", "transText", "callback", "Lkotlin/Function1;", "Landroid/text/Spannable;", "data", "handleRichText", "Lkotlin/Pair;", "originText", "transTextData", "targetLang", "translate", "Lcom/yy/hiyo/translate/base/callback/ITranslateCallback;", "Companion", "translate_debug"})
public final class TranslateService
implements ITranslate {
    private final JCache<JTransTextData> mTransTextDataCache;
    private final Lazy mData$delegate;
    @NotNull
    public static final String TAG = "TranslateService";
    @NotNull
    private static final Pattern AT_PATTERN;
    public static final Companion Companion;

    private final TranslateModuleData getMData() {
        Lazy lazy = this.mData$delegate;
        TranslateService translateService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TranslateModuleData)lazy.getValue();
    }

    @NotNull
    public TranslateModuleData data() {
        return this.getMData();
    }

    @NotNull
    public JTransTextData transTextData(@NotNull String originText, @NotNull String targetLang) {
        Intrinsics.checkParameterIsNotNull((Object)originText, (String)"originText");
        Intrinsics.checkParameterIsNotNull((Object)targetLang, (String)"targetLang");
        Object object = this.mTransTextDataCache.get(JCacheKey.buildCacheKey((Object[])new Object[]{originText, targetLang}));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mTransTextDataCache.get(\u2026(originText, targetLang))");
        return (JTransTextData)object;
    }

    public void translate(@NotNull String originText, @NotNull String targetLang, @Nullable ITranslateCallback callback) {
        block1: {
            JTransTextData transTextData;
            block2: {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)originText, (String)"originText");
                    Intrinsics.checkParameterIsNotNull((Object)targetLang, (String)"targetLang");
                    transTextData = this.transTextData(originText, targetLang);
                    if (!transTextData.isTranslated()) break block0;
                    ITranslateCallback iTranslateCallback = callback;
                    if (iTranslateCallback == null) break block1;
                    iTranslateCallback.onSuccess(transTextData, true);
                    break block1;
                }
                transTextData.setValue("transState", (Object)1);
                Pair<String, String> textPair = this.handleRichText(originText);
                String requestText = (String)textPair.getFirst();
                if (StringUtils.isEmpty((String)requestText)) break block2;
                String atText = (String)textPair.getSecond();
                TranslateReq translateReq = new TranslateReq(requestText, targetLang);
                ProtoManager.getInstance().sendRpc((AndroidMessage)translateReq, (IProtoCallback)new SimpleProtoCallback<TranslateRsp>(this, atText, transTextData, callback){
                    final /* synthetic */ TranslateService this$0;
                    final /* synthetic */ String $atText;
                    final /* synthetic */ JTransTextData $transTextData;
                    final /* synthetic */ ITranslateCallback $callback;

                    public void onResponse(@NotNull TranslateRsp res, long code, @Nullable String msgTip) {
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                            MLog.debug((Object)"TranslateService", (String)("onResponse = " + res), (Object[])new Object[0]);
                            if (!TextUtils.isEmpty((CharSequence)this.$atText)) {
                                TranslateService.access$appendAtText(this.this$0, this.$atText, res.txt, (Function1)new Function1<Spannable, Unit>(this){
                                    final /* synthetic */ translate.1 this$0;

                                    public final void invoke(@NotNull Spannable it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        this.this$0.$transTextData.setValue("transText", (Object)it);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            } else {
                                this.$transTextData.setValue("transText", (Object)res.txt);
                            }
                            this.$transTextData.setValue("transState", (Object)2);
                            ITranslateCallback iTranslateCallback = this.$callback;
                            if (iTranslateCallback == null) break block2;
                            iTranslateCallback.onSuccess(this.$transTextData, false);
                        }
                    }

                    public void onError(@NotNull String reason, int code) {
                        block0: {
                            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                            MLog.info((Object)"TranslateService", (String)("onError = " + reason), (Object[])new Object[0]);
                            this.$transTextData.setValue("transState", (Object)0);
                            ITranslateCallback iTranslateCallback = this.$callback;
                            if (iTranslateCallback == null) break block0;
                            iTranslateCallback.onFailed(code, reason);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$atText = $captured_local_variable$1;
                        this.$transTextData = $captured_local_variable$2;
                        this.$callback = $captured_local_variable$3;
                    }
                });
                break block1;
            }
            transTextData.setValue("transText", (Object)"");
            transTextData.setValue("transState", (Object)2);
            ITranslateCallback iTranslateCallback = callback;
            if (iTranslateCallback == null) break block1;
            iTranslateCallback.onSuccess(transTextData, false);
        }
    }

    private final void appendAtText(String atMsg, String transText, Function1<? super Spannable, Unit> callback) {
        ChainSpan.Companion.of$default((ChainSpan.Companion)ChainSpan.Companion, null, (int)1, null).append((CharSequence)atMsg, new Object[]{new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.channel_chat_text_link))}).append((CharSequence)transText).build(callback);
    }

    private final Pair<String, String> handleRichText(String originText) {
        String requestText = originText;
        Matcher matcher = AT_PATTERN.matcher(requestText);
        String atText = null;
        if (matcher.find()) {
            atText = matcher.group();
        }
        if (!TextUtils.isEmpty((CharSequence)atText)) {
            String string = atText;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            requestText = StringsKt.substringAfter$default((String)requestText, (String)string, null, (int)2, null);
        }
        String string = EmojiManager.INSTANCE.removeTextEmoji(requestText);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EmojiManager.INSTANCE.removeTextEmoji(requestText)");
        requestText = string;
        MLog.debug((Object)TAG, (String)("originText = " + originText + ", requestText = " + requestText + " atMsg = " + atText), (Object[])new Object[0]);
        return new Pair((Object)requestText, (Object)atText);
    }

    public TranslateService() {
        JCache jCache = JCacheContainer.buildCache((JCacheContainer.JCacheBuilder)new JCacheContainer.JCacheBuilder().clazz(JTransTextData.class).minHardSize(128).cacheController((JCache.CacheController)new JCache.CacheController<JTransTextData>(){

            @Nullable
            public JTransTextData createNewCacheObject(@NotNull JCacheKey cacheKey) {
                Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
                Object object = cacheKey.keyAt(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cacheKey.keyAt(0)");
                String string = (String)object;
                Object object2 = cacheKey.keyAt(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"cacheKey.keyAt(1)");
                return new JTransTextData(string, (String)object2);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)jCache, (String)"JCacheContainer.buildCac\u2026        }\n            }))");
        this.mTransTextDataCache = jCache;
        this.mData$delegate = LazyKt.lazy((Function0)mData.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("^@([^@\\s]*)\\s", 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"^@([^@\\\u2026Pattern.CASE_INSENSITIVE)");
        AT_PATTERN = pattern;
    }

    public static final /* synthetic */ void access$appendAtText(TranslateService $this, String atMsg, String transText, Function1 callback) {
        $this.appendAtText(atMsg, transText, (Function1<? super Spannable, Unit>)callback);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/translate/TranslateService$Companion;", "", "()V", "AT_PATTERN", "Ljava/util/regex/Pattern;", "getAT_PATTERN", "()Ljava/util/regex/Pattern;", "TAG", "", "translate_debug"})
    public static final class Companion {
        @NotNull
        public final Pattern getAT_PATTERN() {
            return AT_PATTERN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

