/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.teamup.seat;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.Observer;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.unifyconfig.config.TeamUpGameRoomElementConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.TeamUpSeatConfig;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.ITeamUpGameService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.teamup.R;
import com.yy.hiyo.channel.plugins.teamup.seat.TeamUpLessSeatItem;
import com.yy.hiyo.channel.plugins.teamup.seat.TeamUpNormalSeatItem;
import com.yy.hiyo.channel.plugins.teamup.seat.TeamUpSeatItemHolder;
import com.yy.hiyo.channel.plugins.teamup.seat.TeamUpSeatPresenter;
import com.yy.hiyo.channel.plugins.teamup.seat.TeamUpSeatViewWrapper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011H\u0014J\b\u0010\u0014\u001a\u00020\u0002H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0003J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/yy/hiyo/channel/plugins/teamup/seat/TeamUpSeatPresenter;", "Lcom/yy/hiyo/channel/component/seat/SeatPresenter;", "Lcom/yy/hiyo/channel/plugins/teamup/seat/TeamUpSeatViewWrapper;", "()V", "kvoBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "mSeatCount", "", "getMSeatCount", "()I", "setMSeatCount", "(I)V", "mSeatsObserver", "Landroidx/lifecycle/Observer;", "", "Lcom/yy/hiyo/channel/component/seat/bean/SeatItem;", "createSeatItems", "", "seatList", "Lcom/yy/hiyo/channel/base/bean/SeatUser;", "createSeatViewWrapper", "getCurGid", "", "onDestroy", "", "onHandleNotify", "notify", "Lcom/yy/hiyo/channel/base/bean/ChannelNotify;", "onInit", "mvpContext", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "requestGidSeatConfig", "updateSeatConfig", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "updateSeatCount", "gid", "count", "Companion", "teamup_debug"})
public final class TeamUpSeatPresenter
extends SeatPresenter<TeamUpSeatViewWrapper> {
    private final KvoBinder kvoBinder = new KvoBinder((Object)this);
    private final Observer<List<SeatItem>> mSeatsObserver = mSeatsObserver.1.INSTANCE;
    private int mSeatCount = 8;
    @NotNull
    public static final String TAG = "TeamUpSeatPresenter";
    public static final Companion Companion = new Companion(null);

    public final int getMSeatCount() {
        return this.mSeatCount;
    }

    public final void setMSeatCount(int n) {
        this.mSeatCount = n;
    }

    public void onInit(@Nullable IChannelPageContext<?> mvpContext) {
        super.onInit(mvpContext);
        this.seats().observeForever(this.mSeatsObserver);
        this.requestGidSeatConfig();
    }

    @NotNull
    protected TeamUpSeatViewWrapper createSeatViewWrapper() {
        TeamUpSeatViewWrapper wrapper;
        block1: {
            TeamUpSeatConfig info = ((ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class)).getGidSeatConfig(this.getCurGid());
            this.mSeatCount = info.getCount() != -1 ? info.getCount() : TeamUpGameRoomElementConfig.Companion.getDefaultSeatCount(this.getCurGid());
            IChannelPageContext iChannelPageContext = (IChannelPageContext)this.getMvpContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannelPageContext, (String)"mvpContext");
            wrapper = new TeamUpSeatViewWrapper((IChannelPageContext<AbsPage>)iChannelPageContext, (SeatMvp.IView.OnSeatItemListener)this, this.mSeatCount);
            wrapper.setPresenter((SeatMvp.IPresenter)this);
            MultiTypeAdapter multiTypeAdapter = wrapper.getAdapter();
            if (multiTypeAdapter != null) {
                multiTypeAdapter.register(TeamUpLessSeatItem.class, (ItemViewBinder)new BaseItemBinder<SeatItem, TeamUpSeatItemHolder>(this){
                    final /* synthetic */ TeamUpSeatPresenter this$0;

                    @NotNull
                    protected TeamUpSeatItemHolder onCreateViewHolder(@NotNull LayoutInflater inflater, @NotNull ViewGroup parent) {
                        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
                        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                        View view = this.createItemView(inflater, parent, R.layout.team_up_seat_item);
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"createItemView(inflater,\u2026layout.team_up_seat_item)");
                        IChannelPageContext iChannelPageContext = (IChannelPageContext)this.this$0.getMvpContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iChannelPageContext, (String)"mvpContext");
                        return new TeamUpSeatItemHolder(view, (IChannelPageContext<AbsPage>)iChannelPageContext);
                    }

                    protected void onBindViewHolder(@NotNull TeamUpSeatItemHolder holderGame, @NotNull SeatItem item) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)holderGame), (String)"holderGame");
                        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                        super.onBindViewHolder((BaseItemBinder.ViewHolder)holderGame, (Object)item);
                        holderGame.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)this.this$0);
                    }

                    protected long getItemId(@NotNull SeatItem item) {
                        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                        return item.index;
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            }
            MultiTypeAdapter multiTypeAdapter2 = wrapper.getAdapter();
            if (multiTypeAdapter2 == null) break block1;
            multiTypeAdapter2.register(TeamUpNormalSeatItem.class, (ItemViewBinder)new BaseItemBinder<SeatItem, TeamUpSeatItemHolder>(this){
                final /* synthetic */ TeamUpSeatPresenter this$0;

                @NotNull
                protected TeamUpSeatItemHolder onCreateViewHolder(@NotNull LayoutInflater inflater, @NotNull ViewGroup parent) {
                    Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
                    Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                    View view = this.createItemView(inflater, parent, R.layout.team_up_seat_normal_item);
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"createItemView(inflater,\u2026team_up_seat_normal_item)");
                    IChannelPageContext iChannelPageContext = (IChannelPageContext)this.this$0.getMvpContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannelPageContext, (String)"mvpContext");
                    return new TeamUpSeatItemHolder(view, (IChannelPageContext<AbsPage>)iChannelPageContext);
                }

                protected void onBindViewHolder(@NotNull TeamUpSeatItemHolder holderGame, @NotNull SeatItem item) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)holderGame), (String)"holderGame");
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    super.onBindViewHolder((BaseItemBinder.ViewHolder)holderGame, (Object)item);
                    holderGame.setOnSeatItemListener((SeatMvp.IView.OnSeatItemListener)this.this$0);
                }

                protected long getItemId(@NotNull SeatItem item) {
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    return item.index;
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        return wrapper;
    }

    public void onHandleNotify(@Nullable ChannelNotify notify2) {
    }

    private final void requestGidSeatConfig() {
        MLog.info((Object)TAG, (String)"requestGidSeatConfig", (Object[])new Object[0]);
        this.kvoBinder.clearAllKvoConnections();
        TeamUpSeatConfig info = ((ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class)).getGidSeatConfig(this.getCurGid());
        if (info.getCount() != -1) {
            this.updateSeatCount(info.getGid(), info.getCount());
        } else {
            this.kvoBinder.singleBindSourceTo((KvoSource)info);
            ((ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class)).requestTeamUpSeatConfig(info);
        }
    }

    @KvoMethodAnnotation(name="kvo_gid_seat_count", sourceClass=TeamUpSeatConfig.class, thread=1)
    private final void updateSeatConfig(KvoEventIntent event) {
        KvoSource kvoSource = event.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source()");
        TeamUpSeatConfig info = (TeamUpSeatConfig)kvoSource;
        if (info.getCount() != -1) {
            this.mSeatCount = info.getCount();
            this.updateSeatCount(info.getGid(), this.mSeatCount);
        }
    }

    private final void updateSeatCount(String gid, int count) {
        MLog.info((Object)TAG, (String)("updateSeatCount gid:" + gid + " count:" + count), (Object[])new Object[0]);
        if (Intrinsics.areEqual((Object)gid, (Object)this.getCurGid()) ^ true) {
            return;
        }
        if (this.mSeatViewWrapper instanceof TeamUpSeatViewWrapper) {
            ((TeamUpSeatViewWrapper)this.mSeatViewWrapper).updateItemCount(count);
        }
    }

    private final String getCurGid() {
        IPluginService iPluginService = this.getChannel().getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        String string2 = channelPluginData.getPluginId();
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.kvoBinder.clearAllKvoConnections();
    }

    @NotNull
    protected List<SeatItem> createSeatItems(@Nullable List<SeatUser> seatList) {
        List list;
        List<SeatUser> list2 = seatList;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        List seatItems = new ArrayList(list2.size());
        if (this.mSeatCount == 5) {
            for (SeatUser seatUser : seatList) {
                TeamUpLessSeatItem item = new TeamUpLessSeatItem();
                this.initSeat(item, seatUser);
                seatItems.add(item);
            }
            list = seatItems;
        } else {
            for (SeatUser seatUser : seatList) {
                TeamUpNormalSeatItem item = new TeamUpNormalSeatItem();
                this.initSeat(item, seatUser);
                seatItems.add(item);
            }
            list = seatItems;
        }
        return list;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/plugins/teamup/seat/TeamUpSeatPresenter$Companion;", "", "()V", "TAG", "", "teamup_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

