/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.sticker;

import androidx.annotation.Keep;
import androidx.lifecycle.MutableLiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@Keep
public class StickerData {
    private int id;
    private String operationType;
    private String name;
    private String md5;
    private String tip;
    private String url;
    private String thumb;
    private String resourcePath;
    private String expendJson;
    private Boolean isChecked;
    private transient MutableLiveData<Integer> downloadStatus = new MutableLiveData();

    public String getExpendJson() {
        return this.expendJson;
    }

    public void setExpendJson(String expendJson) {
        this.expendJson = expendJson;
    }

    public Boolean getIsChecked() {
        return this.isChecked;
    }

    public void setIsChecked(Boolean isChecked) {
        this.isChecked = isChecked;
    }

    public String getThumb() {
        return this.thumb;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDownloadStatus(int status) {
        this.downloadStatus.postValue((Object)status);
    }

    public MutableLiveData<Integer> getDownloadStatus() {
        return this.downloadStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StickerData data = (StickerData)o;
        return this.id == data.id && this.md5.equals(data.md5) && this.url.equals(data.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.md5, this.url);
    }

    public String toString() {
        return "StickerData{id=" + this.id + ", operationType='" + this.operationType + '\'' + ", name='" + this.name + '\'' + ", md5='" + this.md5 + '\'' + ", tip='" + this.tip + '\'' + ", url='" + this.url + '\'' + ", thumb='" + this.thumb + '\'' + ", resourcePath='" + this.resourcePath + '\'' + ", expendJson='" + this.expendJson + '\'' + ", isChecked=" + this.isChecked;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownStatus {
        public static final int unDownloading = 0;
        public static final int downloading = 1;
    }
}

