/*
 * Decompiled with CFR 0.152.
 */
package com.yy.socialplatformbase.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.socialplatformbase.data.BBSShareData;
import com.yy.socialplatformbase.data.HagoShareData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class ShareData
implements Parcelable {
    private int type = 0;
    private int to = 1;
    private String title;
    private String imgPath;
    private String videoPath;
    private String gotoUrl;
    private String text;
    public boolean isSystemShare = false;
    public String systemSharePkgName;
    private Map<String, Object> ext;
    @Nullable
    private HagoShareData hagoShareData;
    @Nullable
    private BBSShareData mBBSShareData;
    public static final Parcelable.Creator<ShareData> CREATOR = new Parcelable.Creator<ShareData>(){

        public ShareData createFromParcel(Parcel source) {
            return new ShareData(source);
        }

        public ShareData[] newArray(int size) {
            return new ShareData[size];
        }
    };

    private ShareData() {
    }

    public int getType() {
        return this.type;
    }

    public int getTo() {
        return this.to;
    }

    public String getTitle() {
        return this.title;
    }

    public String getImgPath() {
        return this.imgPath;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    public String getGotoUrl() {
        return this.gotoUrl;
    }

    public String getText() {
        return this.text;
    }

    public BBSShareData getBBSShareData() {
        return this.mBBSShareData;
    }

    public synchronized void addExt(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        if (this.ext == null) {
            this.ext = new HashMap<String, Object>();
        }
        this.ext.put(key, value);
    }

    @Nullable
    public synchronized Object getExt(String key) {
        return this.getExt(key, null);
    }

    @Nullable
    public synchronized Object getExt(String key, Object defaultValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return defaultValue;
        }
        if (this.ext != null && this.ext.containsKey(key)) {
            return this.ext.get(key);
        }
        return defaultValue;
    }

    @Nullable
    public HagoShareData getHagoShareData() {
        return this.hagoShareData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ShareData shareData) {
        return new Builder(shareData);
    }

    public String toString() {
        return "ShareData{type=" + this.type + ", to=" + this.to + ", imgPath=" + this.imgPath + ", audioPath=" + this.videoPath + ", gotoUrl=" + this.gotoUrl + ", text=" + this.text + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.type);
        dest.writeInt(this.to);
        dest.writeString(this.title);
        dest.writeString(this.imgPath);
        dest.writeString(this.videoPath);
        dest.writeString(this.gotoUrl);
        dest.writeString(this.text);
        dest.writeByte(this.isSystemShare ? (byte)1 : 0);
        dest.writeString(this.systemSharePkgName);
        dest.writeMap(this.ext);
        dest.writeParcelable((Parcelable)this.hagoShareData, flags);
        dest.writeParcelable((Parcelable)this.mBBSShareData, flags);
    }

    protected ShareData(Parcel in) {
        this.type = in.readInt();
        this.to = in.readInt();
        this.title = in.readString();
        this.imgPath = in.readString();
        this.videoPath = in.readString();
        this.gotoUrl = in.readString();
        this.text = in.readString();
        this.isSystemShare = in.readByte() != 0;
        this.systemSharePkgName = in.readString();
        this.ext = (Map)in.readParcelable(HashMap.class.getClassLoader());
        this.hagoShareData = (HagoShareData)in.readParcelable(HagoShareData.class.getClassLoader());
        this.mBBSShareData = (BBSShareData)in.readParcelable(BBSShareData.class.getClassLoader());
    }

    public static class To {
        public static final int TO_FRIENDS = 1;
        public static final int TO_DYNAMICS = 2;
        public static final int TO_HAGO_IM = 3;
        public static final int TO_HAGO_CHANNEL = 4;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ToInt {
        }
    }

    public static class Type {
        public static final int TEXT = 0;
        public static final int IMAGE = 1;
        public static final int LINK = 2;
        public static final int VIDEO = 3;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface TypeInt {
        }
    }

    public static class Builder {
        private ShareData mShareData = new ShareData();

        private Builder() {
        }

        private Builder(ShareData shareData) {
            this.mShareData.to = shareData.to;
            this.mShareData.type = shareData.type;
            this.mShareData.title = shareData.title;
            this.mShareData.imgPath = shareData.imgPath;
            this.mShareData.videoPath = shareData.videoPath;
            this.mShareData.gotoUrl = shareData.gotoUrl;
            this.mShareData.text = shareData.text;
            this.mShareData.isSystemShare = shareData.isSystemShare;
            this.mShareData.systemSharePkgName = shareData.systemSharePkgName;
            this.mShareData.hagoShareData = shareData.hagoShareData;
            this.mShareData.mBBSShareData = shareData.mBBSShareData;
        }

        public Builder type(int type) {
            this.mShareData.type = type;
            return this;
        }

        public Builder to(int to) {
            this.mShareData.to = to;
            return this;
        }

        public Builder title(String title) {
            this.mShareData.title = title;
            return this;
        }

        public Builder imgPath(String path) {
            this.mShareData.imgPath = path;
            return this;
        }

        public Builder videoPath(String path) {
            this.mShareData.videoPath = path;
            return this;
        }

        public Builder gotoUrl(String url) {
            this.mShareData.gotoUrl = url;
            return this;
        }

        public Builder text(String text) {
            this.mShareData.text = text;
            return this;
        }

        public Builder systemShare(boolean isSystemShare) {
            this.mShareData.isSystemShare = isSystemShare;
            return this;
        }

        public Builder systemSharePkgName(String pkgName) {
            this.mShareData.systemSharePkgName = pkgName;
            return this;
        }

        public Builder hagoShareData(@NonNull HagoShareData hagoShareData) {
            this.mShareData.hagoShareData = hagoShareData;
            return this;
        }

        public Builder addExt(String key, Object value) {
            this.mShareData.addExt(key, value);
            return this;
        }

        public Builder bbsShareData(@NonNull BBSShareData bbsShareData) {
            this.mShareData.mBBSShareData = bbsShareData;
            return this;
        }

        public ShareData build() {
            return this.mShareData;
        }
    }
}

