/*
 * Decompiled with CFR 0.152.
 */
package com.yy.socialplatformbase;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.yy.socialplatformbase.AbsPlatformAdapter;

public class ThirdPartyPlatformHelper {
    private static ThirdPartyPlatformHelper sInstance = new ThirdPartyPlatformHelper();
    private static IPlatformCreator sPlatformCreator;

    private ThirdPartyPlatformHelper() {
    }

    public static void init(Activity activity, IPlatformCreator platformCreator) {
        sPlatformCreator = platformCreator;
    }

    public static boolean hadInit() {
        return sPlatformCreator != null;
    }

    public static ThirdPartyPlatformHelper getInstance() {
        if (sPlatformCreator == null) {
            throw new RuntimeException("Must call init first!");
        }
        return sInstance;
    }

    public AbsPlatformAdapter getPlatform(int platformId) {
        return sPlatformCreator.getPlatform(platformId);
    }

    public static boolean appInstalled(Context ctx, String pkgName) {
        return ThirdPartyPlatformHelper.appInstalled(ctx, pkgName, 0);
    }

    public static boolean appInstalled(Context ctx, String pkgName, int flag) {
        boolean installed = false;
        try {
            PackageManager packageManager = ctx.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, flag);
            installed = null != packageInfo;
        }
        catch (PackageManager.NameNotFoundException e) {
            installed = false;
        }
        return installed;
    }

    public static interface IPlatformCreator {
        public AbsPlatformAdapter getPlatform(int var1);
    }
}

