/*
 * Decompiled with CFR 0.152.
 */
package com.yy.socialplatformbase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import com.yy.base.HagoFileProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum ShareClient {
    instance;

    private static final String TAG = "ShareClient";

    public void startSystemShare(final Context ctx, final ShareData shareData, final String shareTarget) {
        if (shareData == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                File file;
                Intent sendIntent = new Intent();
                sendIntent.setAction("android.intent.action.SEND");
                if (shareData.getType() == 0) {
                    if (FP.empty((CharSequence)shareData.getText())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == TEXT, shareData.text must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    sendIntent.setType("text/*");
                } else if (shareData.getType() == 2) {
                    if (FP.empty((CharSequence)shareData.getGotoUrl())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == LINK, shareData.url must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.putExtra("android.intent.extra.TEXT", shareData.getGotoUrl());
                    sendIntent.setType("text/*");
                } else if (shareData.getType() == 1) {
                    if (FP.empty((CharSequence)shareData.getImgPath())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == IMAGE, shareData.imgPath must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.setType("image/*");
                    file = new File(shareData.getImgPath());
                    try {
                        Uri uri = null;
                        uri = Build.VERSION.SDK_INT >= 24 ? HagoFileProvider.getUriForFile((Context)RuntimeContext.sApplicationContext, (String)(RuntimeContext.sApplicationContext.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
                        if (uri != null) {
                            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareClient.TAG, (Throwable)e);
                    }
                    if (!FP.empty((CharSequence)shareData.getText())) {
                        sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    }
                } else if (shareData.getType() == 3) {
                    if (FP.empty((CharSequence)shareData.getVideoPath())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == VIDEO, shareData.audioPath must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.setType("video/*");
                    file = new File(shareData.getVideoPath());
                    try {
                        Uri uri = Build.VERSION.SDK_INT >= 24 ? HagoFileProvider.getUriForFile((Context)RuntimeContext.sApplicationContext, (String)(RuntimeContext.sApplicationContext.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
                        if (uri != null) {
                            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareClient.TAG, (Throwable)e);
                    }
                    if (!FP.empty((CharSequence)shareData.getText())) {
                        sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    }
                }
                sendIntent.setComponent(new ComponentName(shareData.systemSharePkgName, shareTarget));
                sendIntent.setFlags(0x10000001);
                if (sendIntent.resolveActivity(ctx.getPackageManager()) != null) {
                    try {
                        ctx.startActivity(sendIntent);
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareClient.TAG, (Throwable)e);
                    }
                }
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
    }

    public void startSystemShare(final Context ctx, final ShareData shareData) {
        if (shareData == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Uri uri;
                File file;
                Intent sendIntent = new Intent();
                sendIntent.setAction("android.intent.action.SEND");
                if (shareData.getType() == 0) {
                    if (FP.empty((CharSequence)shareData.getText())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == TEXT, shareData.text must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    sendIntent.setType("text/*");
                } else if (shareData.getType() == 1) {
                    if (FP.empty((CharSequence)shareData.getImgPath())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == IMAGE, shareData.imgPath must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.setType("image/*");
                    file = new File(shareData.getImgPath());
                    try {
                        uri = null;
                        uri = Build.VERSION.SDK_INT >= 24 ? HagoFileProvider.getUriForFile((Context)RuntimeContext.sApplicationContext, (String)(RuntimeContext.sApplicationContext.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
                        if (uri != null) {
                            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareClient.TAG, (Throwable)e);
                    }
                    if (!FP.empty((CharSequence)shareData.getText())) {
                        sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    }
                } else if (shareData.getType() == 3) {
                    if (FP.empty((CharSequence)shareData.getVideoPath())) {
                        MLog.error((Object)ShareClient.TAG, (String)"type == VIDEO, shareData.audioPath must not be null", (Object[])new Object[0]);
                        return;
                    }
                    sendIntent.setType("video/*");
                    file = new File(shareData.getVideoPath());
                    try {
                        uri = Build.VERSION.SDK_INT >= 24 ? HagoFileProvider.getUriForFile((Context)RuntimeContext.sApplicationContext, (String)(RuntimeContext.sApplicationContext.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
                        if (uri != null) {
                            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)ShareClient.TAG, (Throwable)e);
                    }
                    if (!FP.empty((CharSequence)shareData.getText())) {
                        sendIntent.putExtra("android.intent.extra.TEXT", shareData.getText());
                    }
                }
                sendIntent.setPackage(shareData.systemSharePkgName);
                Intent chooser = Intent.createChooser((Intent)sendIntent, (CharSequence)"Share to");
                try {
                    ctx.startActivity(chooser);
                }
                catch (Exception e) {
                    MLog.error((Object)ShareClient.TAG, (Throwable)e);
                }
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
    }

    public ArrayList<String> getSupportShareTarget(Context ctx, String pkgName, int type) {
        PackageManager pkgMgr = ctx.getPackageManager();
        Intent intent = new Intent("android.intent.action.SEND", null);
        intent.addCategory("android.intent.category.DEFAULT");
        if (type == 0) {
            intent.setType("text/*");
        } else if (type == 3) {
            intent.setType("video/*");
        } else {
            intent.setType("image/*");
        }
        ArrayList<String> target = new ArrayList<String>();
        try {
            List resolveInfoList = pkgMgr.queryIntentActivities(intent, 0);
            for (int i = 0; i < resolveInfoList.size(); ++i) {
                ResolveInfo ri = (ResolveInfo)resolveInfoList.get(i);
                if (TextUtils.isEmpty((CharSequence)pkgName) || !pkgName.equals(ri.activityInfo.packageName)) continue;
                target.add(ri.activityInfo.name);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return target;
    }
}

