/*
 * Decompiled with CFR 0.152.
 */
package com.yy.socialplatformbase;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.CallSuper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IAdCacheCallBack;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.callback.IUserCallBack;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.socialplatformbase.platform.IPlatformAvailableCallBack;
import com.yy.socialplatformbase.platform.IPlatformInterceptor;
import java.util.List;

public abstract class AbsPlatformAdapter {
    protected int mId;
    protected Context mContext;
    private IPlatformInterceptor mInterceptor;

    public AbsPlatformAdapter(Context context, int id) {
        this.mId = id;
        this.mContext = context;
    }

    public void onActivityCreate() {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onAppDestroy() {
    }

    public int getId() {
        return this.mId;
    }

    public void checkToken() {
    }

    public void setInterceptor(IPlatformInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public abstract void login(ILoginCallBack var1);

    public abstract void logout();

    @CallSuper
    public void share(ShareData data, IShareCallBack callBack) {
        if (this.mInterceptor != null) {
            this.mInterceptor.share(data);
        }
    }

    public void getUserInfo(IUserCallBack callBack) {
        if (callBack != null) {
            callBack.onError(105, new RuntimeException(""));
        }
    }

    public void getFriendList(IGetFirendListCallBack callBack) {
        if (callBack != null) {
            callBack.onError(105, new RuntimeException(""));
        }
    }

    public abstract String getPlatformPkgName();

    public String getPlatformAppName() {
        return null;
    }

    public boolean isPlatformInstall() {
        String pkgName = this.getPlatformPkgName();
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            return ThirdPartyPlatformHelper.appInstalled(this.mContext, pkgName);
        }
        return false;
    }

    public void getPlatformVersion(final IPlatformAvailableCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int version = -1;
                String versionName = "";
                boolean isServicesAvailable = false;
                try {
                    PackageInfo info = RuntimeContext.sApplicationContext.getPackageManager().getPackageInfo(AbsPlatformAdapter.this.getPlatformPkgName(), 0);
                    version = info.versionCode;
                    versionName = info.versionName;
                    isServicesAvailable = info != null;
                }
                catch (PackageManager.NameNotFoundException e) {
                    MLog.error((Object)"AbsPlatformAdapter", (String)"[logGooglePlayServiceVersion]", (Throwable)e, (Object[])new Object[0]);
                }
                if (callBack != null) {
                    callBack.onCallBack(isServicesAvailable, version, versionName, AbsPlatformAdapter.this.getPlatformPkgName());
                }
            }
        });
    }

    public void loadAd(String placementId, AdEntity adEntity, int advertiseType, ViewGroup adContainer, IAdCallback callback, int adBannerSize) {
    }

    public void registerViewForAd(AdEntity adEntity, View adView, RelativeLayout adChoicesContainer, FrameLayout adMediaViewContainer, RelativeLayout adIconContainer, List<View> clickableViews, IAdCallback callback) {
    }

    public void cacheAd(String placementId, int advertiseType, IAdCacheCallBack callback) {
    }

    public void pauseAdView(String placementId) {
    }

    public void resumeAdView(String placementId) {
    }

    public void destroyAdView(String placementId) {
    }

    public boolean isRewardVideoAdLoaded(AdEntity adEntity) {
        return false;
    }

    public void initSdk() {
    }

    public String getPlatformUserId() {
        MLog.error((Object)"AbsPlatformAdapter", (String)StringUtils.format((String)"platform not implement this method or do not invoke super!! mId=%d", (Object[])new Object[]{this.mId}), (Object[])new Object[0]);
        return "";
    }

    public Object handleMessageSync(Message msg) {
        return null;
    }

    public void onNewIntent(Intent intent) {
    }

    public void openTestSuit() {
    }

    public void openTestTool() {
    }
}

