/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.search;

import android.os.Bundle;
import android.os.Message;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IQueryOnlineCallBack;
import com.yy.base.cache.JCache;
import com.yy.base.cache.JCacheContainer;
import com.yy.base.cache.JCacheKey;
import com.yy.base.cache.JCacheValue;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.list.KvoPageList;
import com.yy.base.logger.MLog;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.base.ISearchFriend;
import com.yy.hiyo.im.base.ISearchFriendList;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.search.SearGameBean;
import com.yy.hiyo.search.SearchService;
import com.yy.hiyo.search.base.ISearchService;
import com.yy.hiyo.search.base.data.SearchModuleData;
import com.yy.hiyo.search.base.data.bean.ChannelModuleBean;
import com.yy.hiyo.search.base.data.bean.GroupResultBean;
import com.yy.hiyo.search.base.data.bean.RoomResultBean;
import com.yy.hiyo.search.base.data.bean.UserResultBean;
import com.yy.hiyo.search.base.data.bean.UserResultExtraInfo;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.location.LocationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ihago.channel.srv.csearch.ChannelResult;
import net.ihago.channel.srv.csearch.EFilterType;
import net.ihago.channel.srv.csearch.ExtInfo;
import net.ihago.channel.srv.csearch.SearchChannelReq;
import net.ihago.channel.srv.csearch.SearchChannelRes;
import net.ihago.rec.srv.home.HomeEntranceStatic;
import net.ihago.rec.srv.home.SearchGamesReq;
import net.ihago.rec.srv.home.SearchGamesRes;
import net.ihago.room.api.rrec.ECategory;
import net.ihago.room.api.rrec.GetModuleChannelsReq;
import net.ihago.room.api.rrec.GetModuleChannelsRes;
import net.ihago.room.api.rrec.RoomTabItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u001e\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020%2\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016J\u0018\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020#H\u0016J\u0010\u00100\u001a\u00020\u00142\u0006\u0010/\u001a\u00020#H\u0016J \u00101\u001a\u00020\u00142\u0006\u0010,\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020#H\u0002J\u0016\u00105\u001a\u00020\u00142\f\u00106\u001a\b\u0012\u0004\u0012\u00020#07H\u0016J\u0016\u00108\u001a\u00020\u00142\f\u00106\u001a\b\u0012\u0004\u0012\u00020#09H\u0016J\b\u0010:\u001a\u00020\u0014H\u0016J&\u0010;\u001a\u00020\u00142\u0006\u0010,\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016J(\u0010<\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010\u001cH\u0002J(\u0010>\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0002J(\u0010?\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0002J(\u0010@\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010A\u001a\u00020#2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010\u001cH\u0002J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010/\u001a\u00020#H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/yy/hiyo/search/SearchService;", "Lcom/yy/hiyo/search/base/ISearchService;", "()V", "mData", "Lcom/yy/hiyo/search/base/data/SearchModuleData;", "getMData", "()Lcom/yy/hiyo/search/base/data/SearchModuleData;", "mData$delegate", "Lkotlin/Lazy;", "mLocationInfo", "Lcom/yy/location/LocationInfo;", "getMLocationInfo", "()Lcom/yy/location/LocationInfo;", "mLocationInfo$delegate", "userResultExtraInfoCache", "Lcom/yy/base/cache/JCache;", "Lcom/yy/hiyo/search/base/data/bean/UserResultExtraInfo;", "kotlin.jvm.PlatformType", "data", "doSearchChannel", "", "eFilterType", "Lnet/ihago/channel/srv/csearch/EFilterType;", "content", "", "page", "Lcommon/Page;", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "Lnet/ihago/channel/srv/csearch/SearchChannelRes;", "enterChannel", "enterParam", "Lcom/yy/hiyo/channel/base/EnterParam;", "enterChannelModule", "moduleId", "", "catId", "", "moduleName", "isShowModule", "", "extendInfo", "Lnet/ihago/channel/srv/csearch/ExtInfo;", "loadNextPage", "searchType", "openUserInChannel", "channelId", "uid", "openUserProfile", "queryChannelByModuleId", "moduleBean", "Lcom/yy/hiyo/search/base/data/bean/ChannelModuleBean;", "num", "queryInChannel", "uidList", "", "queryOnlineStatus", "", "resetData", "search", "searchGame", "Lnet/ihago/rec/srv/home/SearchGamesRes;", "searchGroup", "searchRoom", "searchUser", "offset", "Lcom/yy/hiyo/im/base/ISearchFriendList;", "userResultExtraInfo", "Companion", "search_debug"})
public final class SearchService
implements ISearchService {
    private final JCache<UserResultExtraInfo> userResultExtraInfoCache;
    private final Lazy mData$delegate;
    private final Lazy mLocationInfo$delegate;
    @NotNull
    public static final String TAG = "SearchService";
    public static final int DEFAULT_USER_SEARCH_PAGE_LIMIT = 15;
    public static final Companion Companion = new Companion(null);

    private final SearchModuleData getMData() {
        Lazy lazy = this.mData$delegate;
        SearchService searchService2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SearchModuleData)lazy.getValue();
    }

    private final LocationInfo getMLocationInfo() {
        Lazy lazy = this.mLocationInfo$delegate;
        SearchService searchService2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocationInfo)lazy.getValue();
    }

    @NotNull
    public SearchModuleData data() {
        return this.getMData();
    }

    public void search(int searchType, @NotNull String content, @Nullable ICommonCallback<?> callback) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (StringsKt.isBlank((CharSequence)content)) {
            MLog.info((Object)TAG, (String)("searching content is blank. type " + searchType), (Object[])new Object[0]);
        }
        this.getMData().setValue("curSearchContent", (Object)content);
        switch (searchType) {
            case 1: {
                this.searchUser(content, 0L, callback);
                break;
            }
            case 3: {
                Page page = new Page.Builder().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().build()");
                this.searchGroup(content, page, callback);
                break;
            }
            case 2: {
                Page page = new Page.Builder().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().build()");
                this.searchRoom(content, page, callback);
                break;
            }
            case 4: {
                Page page = new Page.Builder().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().build()");
                this.searchGame(content, page, callback);
                break;
            }
            default: {
                MLog.error((Object)TAG, (String)"search type none", (Object[])new Object[0]);
            }
        }
    }

    public void loadNextPage(int searchType, @Nullable ICommonCallback<?> callback) {
        switch (searchType) {
            case 1: {
                String string2 = this.getMData().curSearchContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mData.curSearchContent");
                this.searchUser(string2, this.getMData().userSearchResultList.offset, callback);
                break;
            }
            case 3: {
                KvoPageList list = this.getMData().groupSearchResultList;
                String string3 = this.getMData().curSearchContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mData.curSearchContent");
                Page page = new Page.Builder().limit(Long.valueOf(list.limit)).offset(Long.valueOf(list.offset)).snap(Long.valueOf(list.snapshot)).total(Long.valueOf(list.total)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().limit(lis\u2026total(list.total).build()");
                this.searchGroup(string3, page, callback);
                break;
            }
            case 2: {
                KvoPageList list = this.getMData().roomSearchResultList;
                String string4 = this.getMData().curSearchContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mData.curSearchContent");
                Page page = new Page.Builder().limit(Long.valueOf(list.limit)).offset(Long.valueOf(list.offset)).snap(Long.valueOf(list.snapshot)).total(Long.valueOf(list.total)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().limit(lis\u2026total(list.total).build()");
                this.searchRoom(string4, page, callback);
                break;
            }
            case 4: {
                KvoPageList list = this.getMData().gameSearchResultList;
                String string5 = this.getMData().curSearchContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"mData.curSearchContent");
                Page page = new Page.Builder().limit(Long.valueOf(list.limit)).offset(Long.valueOf(list.offset)).snap(Long.valueOf(list.snapshot)).total(Long.valueOf(list.total)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"Page.Builder().limit(lis\u2026total(list.total).build()");
                this.searchGame(string5, page, callback);
                break;
            }
            default: {
                MLog.error((Object)TAG, (String)"search type none", (Object[])new Object[0]);
            }
        }
    }

    private final void searchUser(String content, long offset, ICommonCallback<ISearchFriendList> callback) {
        Bundle bundle = new Bundle();
        bundle.putInt("index", (int)offset);
        String string2 = content;
        String string3 = "content";
        Bundle bundle2 = bundle;
        boolean bl = false;
        String string4 = string2;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        bundle2.putString(string3, string5);
        bundle.putInt("plimit", 15);
        Message msg = Message.obtain();
        msg.what = ImBaseMsgDef.SEARCH_FRIEND_WITH_SEARCH_TEXT;
        Message message = msg;
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"msg");
        message.setData(bundle);
        msg.obj = new ICommonCallback<BaseResponseBean<ISearchFriendList>>(this, content, callback, offset){
            final /* synthetic */ SearchService this$0;
            final /* synthetic */ String $content;
            final /* synthetic */ ICommonCallback $callback;
            final /* synthetic */ long $offset;

            /*
             * Unable to fully structure code
             */
            public void onSuccess(@Nullable BaseResponseBean<ISearchFriendList> data, Object ... ext) {
                block11: {
                    block10: {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                        if (Intrinsics.areEqual((Object)this.$content, (Object)SearchService.access$getMData$p((SearchService)this.this$0).curSearchContent) ^ true) {
                            return;
                        }
                        if (data == null) {
                            v0 = this.$callback;
                            if (v0 != null) {
                                v0.onFail(-2, "data is null", new Object[0]);
                            }
                            MLog.error((Object)"SearchService", (String)"searchUser result is null", (Object[])new Object[0]);
                            return;
                        }
                        if (!data.isSuccess()) break block10;
                        if (data.data == null) ** GOTO lbl-1000
                        v1 = data.data;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"data.data");
                        if (((ISearchFriendList)v1).getList() != null) {
                            var4_3 = false;
                            searchFriendList = new ArrayList<E>();
                            var5_6 = false;
                            uidList = new ArrayList<E>();
                            v2 = data.data;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"data.data");
                            v3 = ((ISearchFriendList)v2).getList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"data.data.list");
                            $this$forEach$iv = v3;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (ISearchFriend)element$iv;
                                $i$a$-forEach-SearchService$searchUser$1$onSuccess$1 = false;
                                v4 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                                uidList.add(v4.getUid());
                                v5 = it.getUid();
                                v6 = it.getAvatarUrl();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.avatarUrl");
                                v7 = it.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it.name");
                                searchFriendList.add(new UserResultBean(v5, v6, v7, it.getVid(), false, null, (v8 = ServiceManagerProxy.getServiceManager()) != null && (v8 = (IRelationService)v8.getService(IRelationService.class)) != null ? v8.getRelationLocal(it.getUid()) : null, 48, null));
                            }
                            newOffset = this.$offset + (long)searchFriendList.size();
                            SearchService.access$getMData$p((SearchService)this.this$0).userSearchResultList.combineList(searchFriendList, 1L, (long)searchFriendList.size(), searchFriendList.size() < 15 ? newOffset : (long)0x7FFFFFFF, this.$offset, newOffset);
                            var7_10 = uidList;
                            var8_12 = false;
                            if (var7_10.isEmpty() == false) {
                                this.this$0.queryOnlineStatus(uidList);
                                this.this$0.queryInChannel(uidList);
                            }
                            v9 = this.$callback;
                            if (v9 != null) {
                                v9.onSuccess(data.data, new Object[0]);
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            SearchService.access$getMData$p((SearchService)this.this$0).userSearchResultList.combineList(CollectionsKt.emptyList(), 1L, 0L, this.$offset, this.$offset, this.$offset);
                            v10 = this.$callback;
                            if (v10 != null) {
                                v10.onSuccess(data.data, new Object[0]);
                            }
                        }
                        break block11;
                    }
                    v11 = this.$callback;
                    if (v11 != null) {
                        v11.onFail(data.code, data.message, new Object[0]);
                    }
                    MLog.error((Object)"SearchService", (String)("searchUser failed code: " + data.code), (Object[])new Object[0]);
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    MLog.error((Object)"SearchService", (String)("searchUser failed, search content: " + this.$content), (Object[])new Object[0]);
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block0;
                    iCommonCallback.onFail(-1, "search error", new Object[0]);
                }
            }
            {
                this.this$0 = $outer;
                this.$content = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                this.$offset = $captured_local_variable$3;
            }
        };
        MsgDispatcher.getInstance().sendMessageSync(msg);
    }

    private final void searchGroup(String content, Page page, ICommonCallback<SearchChannelRes> callback) {
        this.doSearchChannel(EFilterType.FT_BASE, content, page, (ICommonCallback<SearchChannelRes>)((ICommonCallback)new ICommonCallback<SearchChannelRes>(this, content, callback, page){
            final /* synthetic */ SearchService this$0;
            final /* synthetic */ String $content;
            final /* synthetic */ ICommonCallback $callback;
            final /* synthetic */ Page $page;

            /*
             * WARNING - void declaration
             */
            public void onSuccess(@Nullable SearchChannelRes data, Object ... ext) {
                block9: {
                    Collection<GroupResultBean> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    if (Intrinsics.areEqual((Object)this.$content, (Object)SearchService.access$getMData$p((SearchService)this.this$0).curSearchContent) ^ true) {
                        return;
                    }
                    if (data == null) {
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback != null) {
                            iCommonCallback.onFail(-2, "data is null", new Object[0]);
                        }
                        MLog.error((Object)"SearchService", (String)"searchGroup failed data is null", (Object[])new Object[0]);
                        return;
                    }
                    boolean bl = false;
                    List resultList = new ArrayList<E>();
                    if (SearchService.access$isShowModule(this.this$0, data.ext_info)) {
                        ExtInfo extInfo = data.ext_info;
                        if (extInfo != null) {
                            ExtInfo extInfo2 = extInfo;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ExtInfo $this$run = extInfo2;
                            boolean bl4 = false;
                            Long l = $this$run.module_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"module_id");
                            long l2 = l;
                            String string2 = $this$run.module_name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module_name");
                            String string3 = $this$run.module_icon;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"module_icon");
                            Integer n = $this$run.module_cat_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"module_cat_id");
                            ChannelModuleBean groupModule = new ChannelModuleBean(l2, string2, string3, n.intValue());
                            resultList.add(groupModule);
                            SearchService.access$queryChannelByModuleId(this.this$0, 3, groupModule, 2L);
                        }
                    }
                    List list = data.channels;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable iterable = list;
                    List list2 = resultList;
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Integer n;
                        void channel;
                        ChannelResult channelResult = (ChannelResult)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        void v8 = channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"channel");
                        GroupResultBean resultData = GroupResultBean.Companion.build((ChannelResult)v8);
                        Integer n2 = channel.second_type;
                        if (n2 == null || n2 != 0) {
                            n = channel.second_type;
                        } else {
                            Integer n3 = channel.first_type;
                            n = n3 == null || n3 != 0 ? channel.first_type : Integer.valueOf(0);
                        }
                        Integer tagId = n;
                        IChannelCenterService iChannelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                        Integer n4 = tagId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"tagId");
                        resultData.setClassificationData(iChannelCenterService.getGroupCategoryFromCache(n4.intValue()));
                        GroupResultBean groupResultBean = resultData;
                        collection.add(groupResultBean);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll((Collection)collection);
                    KvoPageList kvoPageList = SearchService.access$getMData$p((SearchService)this.this$0).groupSearchResultList;
                    Long l = data.page.snap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"data.page.snap");
                    long l3 = l;
                    Long l4 = data.page.limit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"data.page.limit");
                    long l5 = l4;
                    Long l6 = data.page.total;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l6, (String)"data.page.total");
                    long l7 = l6;
                    Long l8 = this.$page.offset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l8, (String)"page.offset");
                    long l9 = l8;
                    Long l10 = data.page.offset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l10, (String)"data.page.offset");
                    kvoPageList.combineList(resultList, l3, l5, l7, l9, l10.longValue());
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block9;
                    iCommonCallback.onSuccess((Object)data, new Object[0]);
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                ICommonCallback iCommonCallback = this.$callback;
                if (iCommonCallback != null) {
                    iCommonCallback.onFail(errCode, msg, new Object[0]);
                }
                MLog.error((Object)"SearchService", (String)("searchGroup failed " + errCode), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
                this.$content = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                this.$page = $captured_local_variable$3;
            }
        }));
    }

    private final void searchGame(String content, Page page, ICommonCallback<SearchGamesRes> callback) {
        SearchGamesReq req = new SearchGamesReq.Builder().page(page).keyWords(content).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<SearchGamesRes>(this, content, page, callback){
            final /* synthetic */ SearchService this$0;
            final /* synthetic */ String $content;
            final /* synthetic */ Page $page;
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull SearchGamesRes data, long code, @Nullable String msgTip) {
                block3: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                        if (Intrinsics.areEqual((Object)this.$content, (Object)SearchService.access$getMData$p((SearchService)this.this$0).curSearchContent) ^ true) {
                            return;
                        }
                        if (!ProtoManager.isSuccessCode((long)code)) break block2;
                        boolean bl = false;
                        List resultList = new ArrayList<E>();
                        List list = data.HEStatic;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"data.HEStatic");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            GameInfo gameInfo;
                            HomeEntranceStatic searchResult = (HomeEntranceStatic)element$iv;
                            boolean bl2 = false;
                            if (((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(searchResult.GID) == null) continue;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            GameInfo it = gameInfo;
                            boolean bl5 = false;
                            GameInfo gameInfo2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)gameInfo2, (String)"it");
                            resultList.add(new SearGameBean(gameInfo2));
                        }
                        KvoPageList kvoPageList = SearchService.access$getMData$p((SearchService)this.this$0).gameSearchResultList;
                        Long l = data.page.snap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"data.page.snap");
                        long l2 = l;
                        Long l3 = data.page.limit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"data.page.limit");
                        long l4 = l3;
                        Long l5 = data.page.total;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"data.page.total");
                        long l6 = l5;
                        Long l7 = this.$page.offset;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l7, (String)"page.offset");
                        long l8 = l7;
                        Long l9 = data.page.offset;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l9, (String)"data.page.offset");
                        kvoPageList.combineList(resultList, l2, l4, l6, l8, l9.longValue());
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback == null) break block3;
                        iCommonCallback.onSuccess((Object)data, new Object[0]);
                        break block3;
                    }
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block3;
                    iCommonCallback.onFail((int)code, msgTip, new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                return false;
            }
            {
                this.this$0 = $outer;
                this.$content = $captured_local_variable$1;
                this.$page = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    private final void searchRoom(String content, Page page, ICommonCallback<SearchChannelRes> callback) {
        this.doSearchChannel(EFilterType.FT_CHAT, content, page, (ICommonCallback<SearchChannelRes>)((ICommonCallback)new ICommonCallback<SearchChannelRes>(this, content, callback, page){
            final /* synthetic */ SearchService this$0;
            final /* synthetic */ String $content;
            final /* synthetic */ ICommonCallback $callback;
            final /* synthetic */ Page $page;

            /*
             * WARNING - void declaration
             */
            public void onSuccess(@Nullable SearchChannelRes data, Object ... ext) {
                block9: {
                    Collection<RoomResultBean> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    if (Intrinsics.areEqual((Object)this.$content, (Object)SearchService.access$getMData$p((SearchService)this.this$0).curSearchContent) ^ true) {
                        return;
                    }
                    if (data == null) {
                        ICommonCallback iCommonCallback = this.$callback;
                        if (iCommonCallback != null) {
                            iCommonCallback.onFail(-2, "data is null", new Object[0]);
                        }
                        MLog.error((Object)"SearchService", (String)"searchRoom failed data is null", (Object[])new Object[0]);
                        return;
                    }
                    boolean bl = false;
                    List resultList = new ArrayList<E>();
                    if (SearchService.access$isShowModule(this.this$0, data.ext_info)) {
                        ExtInfo extInfo = data.ext_info;
                        if (extInfo != null) {
                            ExtInfo extInfo2 = extInfo;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ExtInfo $this$run = extInfo2;
                            boolean bl4 = false;
                            Long l = $this$run.module_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"module_id");
                            long l2 = l;
                            String string2 = $this$run.module_name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module_name");
                            String string3 = $this$run.module_icon;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"module_icon");
                            Integer n = $this$run.module_cat_id;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"module_cat_id");
                            ChannelModuleBean roomModule = new ChannelModuleBean(l2, string2, string3, n.intValue());
                            resultList.add(roomModule);
                            SearchService.access$queryChannelByModuleId(this.this$0, 2, roomModule, 2L);
                        }
                    }
                    List list = data.channels;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable iterable = list;
                    List list2 = resultList;
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Integer n;
                        void channel;
                        ChannelResult channelResult = (ChannelResult)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        void v8 = channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"channel");
                        RoomResultBean resultData = RoomResultBean.Companion.build((ChannelResult)v8);
                        Integer n2 = channel.second_type;
                        if (n2 == null || n2 != 0) {
                            n = channel.second_type;
                        } else {
                            Integer n3 = channel.first_type;
                            n = n3 == null || n3 != 0 ? channel.first_type : Integer.valueOf(0);
                        }
                        Integer tagId = n;
                        IChannelCenterService iChannelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                        Integer n4 = tagId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"tagId");
                        resultData.setClassificationData(iChannelCenterService.getGroupCategoryFromCache(n4.intValue()));
                        RoomResultBean roomResultBean = resultData;
                        collection.add(roomResultBean);
                    }
                    collection = (List)destination$iv$iv;
                    list2.addAll((Collection)collection);
                    KvoPageList kvoPageList = SearchService.access$getMData$p((SearchService)this.this$0).roomSearchResultList;
                    Long l = data.page.snap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"data.page.snap");
                    long l3 = l;
                    Long l4 = data.page.limit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"data.page.limit");
                    long l5 = l4;
                    Long l6 = data.page.total;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l6, (String)"data.page.total");
                    long l7 = l6;
                    Long l8 = this.$page.offset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l8, (String)"page.offset");
                    long l9 = l8;
                    Long l10 = data.page.offset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l10, (String)"data.page.offset");
                    kvoPageList.combineList(resultList, l3, l5, l7, l9, l10.longValue());
                    ICommonCallback iCommonCallback = this.$callback;
                    if (iCommonCallback == null) break block9;
                    iCommonCallback.onSuccess((Object)data, new Object[0]);
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                ICommonCallback iCommonCallback = this.$callback;
                if (iCommonCallback != null) {
                    iCommonCallback.onFail(errCode, msg, new Object[0]);
                }
                MLog.error((Object)"SearchService", (String)("searchRoom failed " + errCode), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
                this.$content = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                this.$page = $captured_local_variable$3;
            }
        }));
    }

    private final void doSearchChannel(EFilterType eFilterType, String content, Page page, ICommonCallback<SearchChannelRes> callback) {
        String string2 = content;
        SearchChannelReq.Builder builder = new SearchChannelReq.Builder();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        SearchChannelReq.Builder req = builder.keyword(string4).page(page).filter_type(Integer.valueOf(eFilterType.getValue()));
        LocationInfo locationInfo = this.getMLocationInfo();
        if (locationInfo != null) {
            string2 = locationInfo;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it");
            req.latitude = string5.getLatitude();
            req.longitude = it.getLongitude();
        }
        ProtoManager.getInstance().sendRpc((AndroidMessage)req.build(), (IProtoCallback)new IProtoCallback<SearchChannelRes>(callback){
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull SearchChannelRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                if (ProtoManager.isSuccessCode((long)code)) {
                    this.$callback.onSuccess((Object)message, new Object[0]);
                } else {
                    this.$callback.onFail((int)code, msg, new Object[0]);
                }
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                this.$callback.onFail(code, reason, new Object[0]);
                return false;
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                this.$callback.onFail(-1, "time out", new Object[0]);
                return false;
            }

            public boolean needToken() {
                return !RuntimeContext.isHagoPartySdk();
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    private final void queryChannelByModuleId(int searchType, ChannelModuleBean moduleBean, long num) {
        GetModuleChannelsReq.Builder req = new GetModuleChannelsReq.Builder().offset(Long.valueOf(0L)).page_num(Long.valueOf(num)).module_id(Long.valueOf(moduleBean.getModuleId())).from(Integer.valueOf(1)).channel(AccountUtil.getLoginChannel());
        req.ab_frame36(Boolean.valueOf(true));
        int n = moduleBean.getCatId();
        if (n == ECategory.ESameCity.getValue()) {
            LocationInfo locationInfo = this.getMLocationInfo();
            if (locationInfo != null) {
                LocationInfo locationInfo2 = locationInfo;
                boolean bl = false;
                boolean bl2 = false;
                LocationInfo $this$run = locationInfo2;
                boolean bl3 = false;
                req.longitude(Double.valueOf($this$run.getLongitude())).latitude(Double.valueOf($this$run.getLatitude())).country($this$run.getCountry()).city($this$run.getCity());
            }
        }
        ProtoManager.getInstance().sendRpc((AndroidMessage)req.build(), (IProtoCallback)new IProtoCallback<GetModuleChannelsRes>(this, searchType, moduleBean){
            final /* synthetic */ SearchService this$0;
            final /* synthetic */ int $searchType;
            final /* synthetic */ ChannelModuleBean $moduleBean;

            public void onResponse(@NotNull GetModuleChannelsRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    boolean bl = false;
                    List resultList = new ArrayList<E>();
                    if (this.$searchType == 2) {
                        List list = message.channels;
                        if (list != null) {
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                RoomTabItem it = (RoomTabItem)element$iv;
                                boolean bl2 = false;
                                RoomTabItem roomTabItem = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)roomTabItem, (String)"it");
                                resultList.add(RoomResultBean.Companion.build(roomTabItem, this.$moduleBean));
                            }
                        }
                        SearchService.access$getMData$p((SearchService)this.this$0).roomsModuleData.set((Collection)resultList);
                    } else {
                        List list = message.channels;
                        if (list != null) {
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                RoomTabItem it = (RoomTabItem)element$iv;
                                boolean bl3 = false;
                                RoomTabItem roomTabItem = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)roomTabItem, (String)"it");
                                resultList.add(GroupResultBean.Companion.build(roomTabItem, this.$moduleBean));
                            }
                        }
                        SearchService.access$getMData$p((SearchService)this.this$0).groupsModuleData.set((Collection)resultList);
                    }
                } else {
                    MLog.info((Object)"SearchService", (String)("fetchChannelByModuleId failed, code: " + code + " msg: " + msg + " moduleId: " + this.$moduleBean.getModuleId()), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)"SearchService", (String)("fetchChannelByModuleId retryWhenError, " + "code: " + code + " reason: " + reason + " moduleId: " + this.$moduleBean.getModuleId()), (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)"SearchService", (String)("fetchChannelByModuleId retryWhenTimeout, moduleId: " + this.$moduleBean.getModuleId()), (Object[])new Object[0]);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$searchType = $captured_local_variable$1;
                this.$moduleBean = $captured_local_variable$2;
            }
        });
    }

    @NotNull
    public UserResultExtraInfo userResultExtraInfo(long uid) {
        Object object = this.userResultExtraInfoCache.get(JCacheKey.buildCacheKey((Object[])new Object[]{uid}));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"userResultExtraInfoCache\u2026heKey.buildCacheKey(uid))");
        return (UserResultExtraInfo)object;
    }

    public void queryInChannel(@NotNull List<Long> uidList) {
        block0: {
            Intrinsics.checkParameterIsNotNull(uidList, (String)"uidList");
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) == null) break block0;
            iServiceManager.queryUserInWhereChannel(false, true, uidList, new IChannelCenterService.IQueryUsersCurChannelCallBack(this, uidList){
                final /* synthetic */ SearchService this$0;
                final /* synthetic */ List $uidList;

                public void onSuccess(@Nullable HashMap<Long, String> uidAndCids) {
                    HashMap<Long, String> hashMap = uidAndCids;
                    if (hashMap != null && (hashMap = hashMap.entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)((Object)hashMap);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl = false;
                            K k = it.getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                            this.this$0.userResultExtraInfo(((Number)k).longValue()).setValue("in_channel_id", it.getValue());
                        }
                    }
                }

                public void onError(int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    MLog.info((Object)"SearchService", (String)("fetchLiveStatus failed, code: " + errorCode + ", uidList: " + this.$uidList), (Object[])new Object[0]);
                }
                {
                    this.this$0 = $outer;
                    this.$uidList = $captured_local_variable$1;
                }
            });
        }
    }

    public void queryOnlineStatus(@NotNull List<Long> uidList) {
        block0: {
            Intrinsics.checkParameterIsNotNull(uidList, (String)"uidList");
            boolean bl = false;
            ArrayList uidArrayList = new ArrayList();
            uidArrayList.addAll(uidList);
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IUserInfoService)iServiceManager.getService(IUserInfoService.class)) == null) break block0;
            iServiceManager.getOnlineStatus(uidArrayList, new IQueryOnlineCallBack(this, uidList){
                final /* synthetic */ SearchService this$0;
                final /* synthetic */ List $uidList;

                public void onSuccess(@Nullable HashMap<Long, Boolean> status) {
                    HashMap<Long, Boolean> hashMap = status;
                    if (hashMap != null && (hashMap = hashMap.entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)((Object)hashMap);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl = false;
                            K k = it.getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                            this.this$0.userResultExtraInfo(((Number)k).longValue()).setValue("online_status", it.getValue());
                        }
                    }
                }

                public void onError(@Nullable String errorCode, @Nullable Exception e) {
                    MLog.error((Object)"SearchService", (String)("fetchOnlineStatus failed, code: " + errorCode + ", uidList: " + this.$uidList), (Object[])new Object[0]);
                }
                {
                    this.this$0 = $outer;
                    this.$uidList = $captured_local_variable$1;
                }
            });
        }
    }

    private final boolean isShowModule(ExtInfo extendInfo) {
        if (extendInfo == null) {
            return false;
        }
        CharSequence charSequence = extendInfo.module_name;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Integer n = extendInfo.module_cat_id;
        int n2 = ECategory.ESameCity.getValue();
        if (n != null && n == n2 && this.getMLocationInfo() == null) {
            MLog.info((Object)TAG, (String)"module is TheSameCity, but location is null", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public void resetData() {
        SearchModuleData searchModuleData = this.getMData();
        boolean bl = false;
        boolean bl2 = false;
        SearchModuleData $this$with = searchModuleData;
        boolean bl3 = false;
        $this$with.setValue("curSearchContent", (Object)"");
        $this$with.lastEnterChannelId = "";
        $this$with.userSearchResultList.reset();
        $this$with.groupSearchResultList.reset();
        $this$with.roomSearchResultList.reset();
    }

    public void enterChannel(@NotNull EnterParam enterParam) {
        Intrinsics.checkParameterIsNotNull((Object)enterParam, (String)"enterParam");
        this.getMData().lastEnterChannelId = enterParam.roomId;
        Message message = Message.obtain();
        boolean bl = false;
        boolean bl2 = false;
        Message $this$apply = message;
        boolean bl3 = false;
        $this$apply.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        $this$apply.obj = enterParam;
        Message message2 = message;
        MsgDispatcher.getInstance().sendMessage(message2);
    }

    public void enterChannelModule(long moduleId, int catId, @NotNull String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.ChannelListMoreMsgDef.OPEN_MORE_LIST;
        Message message = msg;
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"msg");
        Bundle bundle = new Bundle();
        Message message2 = message;
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        $this$apply.putLong("group_id", moduleId);
        $this$apply.putString("group_name", moduleName);
        $this$apply.putInt("group_type", catId);
        Bundle bundle2 = bundle;
        message2.setData(bundle2);
        MsgDispatcher.getInstance().sendMessage(msg);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "result_more_click"));
    }

    public void openUserProfile(long uid) {
        if (uid > 0L) {
            ProfileReportBean bean = new ProfileReportBean();
            bean.setUid(Long.valueOf(uid));
            bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getSearch()));
            bean.setSource(2);
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_OPEN_PROFILE_NEW_WINDOW, -1, -1, (Object)bean);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "result_user_pic_but_click"));
        }
    }

    public void openUserInChannel(@NotNull String channelId, long uid) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)channelId, (int)30);
        HashMap extraInfo = new HashMap();
        ((Map)extraInfo).put("home_search_result_uid", uid);
        enterParam.extra = extraInfo;
        enterParam.entryInfo = new EntryInfo(FirstEntType.SEARCH, "2", null, 4, null);
        message.obj = enterParam;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public SearchService() {
        JCache jCache = JCacheContainer.buildCache(UserResultExtraInfo.class, (JCache.CacheController)((JCache.CacheController)new JCache.CacheController<UserResultExtraInfo>(){

            @Nullable
            public UserResultExtraInfo createNewCacheObject(@NotNull JCacheKey cacheKey) {
                Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
                UserResultExtraInfo info = new UserResultExtraInfo();
                Object object = cacheKey.keyAt(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cacheKey.keyAt(0)");
                info.uid = ((Number)object).longValue();
                return info;
            }

            public void onNeedRefresh(@NotNull JCacheKey cacheKey, @NotNull JCacheValue<UserResultExtraInfo> cacheObject) {
                Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
                Intrinsics.checkParameterIsNotNull(cacheObject, (String)"cacheObject");
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)jCache, (String)"JCacheContainer.buildCac\u2026xtraInfo?>) {}\n        })");
        this.userResultExtraInfoCache = jCache;
        this.mData$delegate = LazyKt.lazy((Function0)mData.2.INSTANCE);
        this.mLocationInfo$delegate = LazyKt.lazy((Function0)mLocationInfo.2.INSTANCE);
    }

    public static final /* synthetic */ SearchModuleData access$getMData$p(SearchService $this) {
        return $this.getMData();
    }

    public static final /* synthetic */ boolean access$isShowModule(SearchService $this, ExtInfo extendInfo) {
        return $this.isShowModule(extendInfo);
    }

    public static final /* synthetic */ void access$queryChannelByModuleId(SearchService $this, int searchType, ChannelModuleBean moduleBean, long num) {
        $this.queryChannelByModuleId(searchType, moduleBean, num);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/search/SearchService$Companion;", "", "()V", "DEFAULT_USER_SEARCH_PAGE_LIMIT", "", "TAG", "", "search_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

