/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.tools.revenue.calculator.bean.a;
import com.yy.hiyo.tools.revenue.calculator.bean.b;
import java.util.HashMap;
import java.util.Map;
import net.ihago.room.api.calculator.Egg;
import net.ihago.room.api.calculator.GetRoomCalculatorConfigReq;
import net.ihago.room.api.calculator.GetRoomCalculatorConfigRes;
import net.ihago.room.api.calculator.HatSpecialEffect;
import net.ihago.room.api.calculator.SpecialEffect;

public enum CalculatorStyleManager {
    INSTANCE;

    public static final int STYLE_COMMON = 1;
    public static final int STYLE_SPECIAL = 2;
    private String mVersion = "";
    private Map<Integer, a> mStyleDataMap = new HashMap<Integer, a>();
    private Map<Integer, String> mEggMap = new HashMap<Integer, String>();
    private Map<Integer, b> mHatMap = new HashMap<Integer, b>();

    public void getConfig() {
        GetRoomCalculatorConfigReq getRoomCalculatorConfigReq = new GetRoomCalculatorConfigReq.Builder().version(this.mVersion).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getRoomCalculatorConfigReq, (IProtoCallback)new IProtoCallback<GetRoomCalculatorConfigRes>(){

            public void a(@NonNull GetRoomCalculatorConfigRes getRoomCalculatorConfigRes, long l, String string2) {
                super.onResponse((AndroidMessage)getRoomCalculatorConfigRes, l, string2);
                if (!ProtoManager.isSuccessCode((long)l)) {
                    return;
                }
                if (CalculatorStyleManager.this.mVersion.equals(getRoomCalculatorConfigRes.config.version)) {
                    return;
                }
                CalculatorStyleManager.this.mVersion = getRoomCalculatorConfigRes.config.version;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTCalculator", (String)"getConfig version:%s", (Object[])new Object[]{CalculatorStyleManager.this.mVersion});
                }
                Map map = getRoomCalculatorConfigRes.config.effects;
                Map map2 = getRoomCalculatorConfigRes.config.eggs;
                Map map3 = getRoomCalculatorConfigRes.config.hatEffects;
                for (Map.Entry entry : map.entrySet()) {
                    SpecialEffect object2 = (SpecialEffect)entry.getValue();
                    a a2 = a.a(object2);
                    if (a2 == null) continue;
                    CalculatorStyleManager.this.mStyleDataMap.put(object2.effect_id, a2);
                }
                for (Map.Entry entry : map2.entrySet()) {
                    Egg egg = (Egg)entry.getValue();
                    CalculatorStyleManager.this.mEggMap.put(egg.egg_id, egg.egg_url);
                }
                for (Map.Entry entry : map3.entrySet()) {
                    HatSpecialEffect hatSpecialEffect = (HatSpecialEffect)entry.getValue();
                    CalculatorStyleManager.this.mHatMap.put(hatSpecialEffect.effect_id, new b(hatSpecialEffect.effect_id, hatSpecialEffect.effect_style, hatSpecialEffect.effect_url));
                }
            }

            public boolean retryWhenTimeout(boolean bl) {
                return false;
            }

            public boolean retryWhenError(boolean bl, String string2, int n) {
                return false;
            }

            public /* synthetic */ void onResponse(@NonNull AndroidMessage androidMessage, long l, String string2) {
                this.a((GetRoomCalculatorConfigRes)androidMessage, l, string2);
            }
        });
    }

    public a getData(int n) {
        if (this.mStyleDataMap.containsKey(n)) {
            return this.mStyleDataMap.get(n);
        }
        return new a();
    }

    public String getEggUrl(int n) {
        if (this.mEggMap.containsKey(n)) {
            return this.mEggMap.get(n);
        }
        return "";
    }

    public b getHatSpecialEffectData(int n) {
        if (this.mHatMap.containsKey(n)) {
            return this.mHatMap.get(n);
        }
        return null;
    }

    public String getHatUrl(int n) {
        if (this.mHatMap.containsKey(n) && this.mHatMap.get(n) != null) {
            return this.mHatMap.get(n).a();
        }
        return "";
    }

    public void addData(a a2) {
        if (a2 != null) {
            this.mStyleDataMap.put(a2.a(), a2);
        }
    }
}

