/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.redpacket;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.game.base.helper.ShortUrlUtil;
import com.yy.hiyo.share.base.DownloadCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.DataCallback;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import com.yy.hiyo.tools.revenue.R;
import java.net.URLEncoder;
import org.jetbrains.annotations.NotNull;

public class RedPacketShareProvider
extends ShareDataProvider {
    private static final String DEFAULT_IMG_URL = "https://o-in.ihago.net/ikxd/72cd71a1d5416c6fb8d0f4f70457d5cc/red_packet_bg.png";
    private static final String SHARE_URL_ARGS = "&appType=android&roomId=%s&roomTitle=%s&roomNum=%d&inviteUid=%d&userName=%s&userImg=%s";
    private static final String SHARE_URL_ROOM_TOKEN_ARG = "&roomToken=%s";
    private PlatformShareData shareData;
    private String mImageUrl;

    public void setShareData(@NotNull PlatformShareData data) {
        this.shareData = data;
        this.reset();
        this.preload();
    }

    public void setImageUrl(String mImageUrl) {
        this.mImageUrl = URLUtils.replaceUrl((String)mImageUrl);
    }

    protected void buildTitle(DataCallback<String> callback) {
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        String shareTitle = null;
        if (userInfoKS != null) {
            shareTitle = ResourceUtils.getString((int)R.string.short_tips_channel_share_red_packet);
        }
        callback.onData((Object)shareTitle);
    }

    protected void buildText(DataCallback<String> callback) {
        String title = this.getShareBundle().getTitle();
        String url = this.getShareBundle().getUrl();
        String text = StringUtils.format((String)"%s %s", (Object[])new Object[]{title, url});
        callback.onData((Object)text);
    }

    protected void buildImage(final DataCallback<String> callback) {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_ROOM_SHARE);
        String imgUrl = this.mImageUrl;
        if (FP.empty((CharSequence)imgUrl)) {
            imgUrl = DEFAULT_IMG_URL;
        }
        ((IIntlShareService)ServiceManagerProxy.getService(IIntlShareService.class)).downloadShareImage(imgUrl, new DownloadCallback(){

            public void onSuccess(String url, String path) {
                callback.onData((Object)path);
            }

            public void onFail(String url) {
                callback.onData(null);
            }
        });
    }

    protected void buildUrl(final DataCallback<String> callback) {
        String baseUrl = this.getBaseShareUrl();
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily) {
            String url = StringUtils.format((String)baseUrl, (Object[])new Object[]{this.shareData.getInviteData().channelId});
            ShortUrlUtil.getShortUrl((String)url, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                public void onSuccess(String input, String shortUrl) {
                    callback.onData((Object)shortUrl);
                }

                public void onError(String input, int code, String msg) {
                    callback.onData((Object)input);
                }
            });
        } else {
            UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
            if (userInfoKS != null && this.shareData != null) {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append(baseUrl);
                urlBuilder.append(StringUtils.formatWitUSLocal((String)SHARE_URL_ARGS, (Object[])new Object[]{this.shareData.getInviteData().channelId, URLEncoder.encode(this.shareData.getInviteData().channelName), this.shareData.getInviteData().onlineCount, userInfoKS.uid, URLEncoder.encode(userInfoKS.nick), URLEncoder.encode(URLUtils.replaceUrl((String)userInfoKS.avatar))}));
                this.shareData.getInviteData().tokenProvider.getToken(token -> {
                    if (!FP.empty((CharSequence)token)) {
                        urlBuilder.append(StringUtils.formatWitUSLocal((String)SHARE_URL_ROOM_TOKEN_ARG, (Object[])new Object[]{token}));
                    }
                    ShortUrlUtil.getShortUrl((String)urlBuilder.toString(), (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                        public void onSuccess(String input, String shortUrl) {
                            callback.onData((Object)shortUrl);
                        }

                        public void onError(String input, int code, String msg) {
                            callback.onData((Object)input);
                        }
                    });
                });
            }
            ShortUrlUtil.getShortUrl((String)baseUrl, (ShortUrlUtil.IGetShortUrl)new ShortUrlUtil.IGetShortUrl(){

                public void onSuccess(String input, String shortUrl) {
                    callback.onData((Object)shortUrl);
                }

                public void onError(String input, int code, String msg) {
                    callback.onData((Object)input);
                }
            });
        }
    }

    private String getBaseShareUrl() {
        AConfigData configData;
        if (this.shareData != null && this.shareData.getInviteData() != null && this.shareData.getInviteData().isFamily && (configData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig) {
            CommonConfigData data = ((CommonConfig)configData).getData();
            String familyUrl = data.familyDetailUrl;
            if (StringUtils.isNotEmpty((String)familyUrl)) {
                return URLUtils.replaceUrl((String)URLUtils.addParam((String)familyUrl, (String)"useNativeDetail", (String)"true"));
            }
        }
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        StringBuilder urlBuilder = new StringBuilder();
        if (type == EnvSettingType.Product) {
            urlBuilder.append("https://www.ihago.net/a/voice-share/index.html");
        } else {
            urlBuilder.append(DebugTestUriProvider.TEST_OLA_PARTY_HOST + "/a/voice-share/index.html");
        }
        urlBuilder.append("?").append(UriProvider.appendCommonWebUrlParams());
        return URLUtils.replaceUrl((String)urlBuilder.toString());
    }
}

