/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.turntable.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.turntable.TurnTableItem;
import com.yy.hiyo.tools.revenue.turntable.ui.TurnTableView;
import java.util.List;

public class TurnTableDialog
implements BaseDialog {
    private View mRootView;
    private String mResultTips;
    private IOperationCallback mCallback;
    private TurnTableView mTurnTableView;
    private TextView mTvResultTips;
    private static final int RESULT_DELAY_TIME = 8000;

    public TurnTableDialog(Context context, List<TurnTableItem> turnTableItemList, int index, boolean isOwner) {
        this.createGuestView(context, turnTableItemList, index, isOwner);
    }

    public TurnTableDialog(Context context, List<TurnTableItem> turnTableItemList) {
        this.createOwnerView(context, turnTableItemList);
    }

    private void createOwnerView(final Context context, List<TurnTableItem> turnTableItemList) {
        this.mRootView = View.inflate((Context)context, (int)R.layout.layout_turntable_channel, null);
        this.mTvResultTips = (TextView)this.mRootView.findViewById(R.id.tv_turntable_result_tips);
        final TextView tvTitle = (TextView)this.mRootView.findViewById(R.id.tv_turntable_title_tips);
        this.mTvResultTips.setIncludeFontPadding(false);
        tvTitle.setIncludeFontPadding(false);
        ImageView ivClose = (ImageView)this.mRootView.findViewById(R.id.iv_turntable_close);
        this.mTurnTableView = (TurnTableView)this.mRootView.findViewById(R.id.turntable);
        this.mTurnTableView.setContent(turnTableItemList);
        this.mTurnTableView.setOnOperationCallback(new TurnTableView.IOperationCallback(){

            @Override
            public void onGoClicked() {
                if (!NetworkUtils.isNetworkAvailable((Context)context)) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"go click not network", (Object[])new Object[0]);
                    ToastUtils.showToast((Context)context, (int)R.string.check_network_and_retry);
                    return;
                }
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mTurnTableView.disable();
                    TurnTableDialog.this.mCallback.onGoClicked();
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TurnTableDialog.this.mCallback != null) {
                            TurnTableDialog.this.mCallback.onResultShow(TurnTableDialog.this.mResultTips);
                        }
                    }
                }, (long)8000L);
            }

            @Override
            public void onFinished() {
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mCallback.onFinished();
                }
                tvTitle.setVisibility(4);
                TurnTableDialog.this.mTvResultTips.setText((CharSequence)TurnTableDialog.this.mResultTips);
                TurnTableDialog.this.mTvResultTips.setVisibility(0);
                TurnTableDialog.this.shadeAnimator((View)TurnTableDialog.this.mTvResultTips);
            }
        });
        ivClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mCallback.onClosed(TurnTableDialog.this.mResultTips);
                }
            }
        });
    }

    public void start(int index, String tips) {
        this.mResultTips = tips;
        if (this.mTurnTableView != null) {
            this.mTurnTableView.start(index);
        }
        if (this.mTvResultTips != null) {
            this.mTvResultTips.setText((CharSequence)tips);
        }
    }

    public void setCallback(IOperationCallback callback) {
        this.mCallback = callback;
    }

    private void createGuestView(Context context, List<TurnTableItem> turnTableItemList, int index, boolean isOwner) {
        this.mRootView = View.inflate((Context)context, (int)R.layout.layout_turntable_channel, null);
        final TextView tvResultTips = (TextView)this.mRootView.findViewById(R.id.tv_turntable_result_tips);
        final TextView tvTitleTips = (TextView)this.mRootView.findViewById(R.id.tv_turntable_title_tips);
        tvTitleTips.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_turntable_guset_title));
        tvTitleTips.setIncludeFontPadding(false);
        tvResultTips.setIncludeFontPadding(false);
        ImageView ivClose = (ImageView)this.mRootView.findViewById(R.id.iv_turntable_close);
        final TurnTableView turnTableView = (TurnTableView)this.mRootView.findViewById(R.id.turntable);
        turnTableView.setContent(turnTableItemList);
        turnTableView.isOwner(isOwner);
        if (!isOwner) {
            turnTableView.start(index);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TurnTableDialog.this.mCallback != null) {
                        TurnTableDialog.this.mCallback.onResultShow(TurnTableDialog.this.mResultTips);
                    }
                }
            }, (long)8000L);
        }
        turnTableView.setOnOperationCallback(new TurnTableView.IOperationCallback(){

            @Override
            public void onGoClicked() {
            }

            @Override
            public void onFinished() {
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mCallback.onFinished();
                }
                tvTitleTips.setVisibility(4);
                turnTableView.disable();
                tvResultTips.setText((CharSequence)TurnTableDialog.this.mResultTips);
                tvResultTips.setVisibility(0);
                TurnTableDialog.this.shadeAnimator((View)tvResultTips);
            }
        });
        ivClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mCallback.onClosed(TurnTableDialog.this.mResultTips);
                }
            }
        });
    }

    private void shadeAnimator(View view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        animatorSet.setDuration(300L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.play((Animator)scaleX).with((Animator)scaleY);
        animatorSet.start();
    }

    public void init(Dialog dialog) {
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.gravity = 48;
        layoutParams.y = 281;
        layoutParams.alpha = 0.9f;
        window.setAttributes(layoutParams);
        dialog.setContentView(this.mRootView, new ViewGroup.LayoutParams(-1, -1));
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (TurnTableDialog.this.mCallback != null) {
                    TurnTableDialog.this.mCallback.onDismissed();
                }
            }
        });
    }

    public int getId() {
        return 0;
    }

    public void setResultTips(String text) {
        this.mResultTips = text;
    }

    public void showLoading() {
        if (this.mTurnTableView != null) {
            this.mTurnTableView.showLoading();
        }
    }

    public void hideLoading() {
        if (this.mTurnTableView != null) {
            this.mTurnTableView.hideLoading();
        }
    }

    public static interface IOperationCallback {
        public void onClosed(String var1);

        public void onDismissed();

        public void onFinished();

        public void onResultShow(String var1);

        public void onGoClicked();
    }
}

