/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.turntable;

import android.app.Activity;
import android.content.Context;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.tools.revenue.turntable.ui.TurnTableDialog;

public class TurnTableDialogManager {
    private Context mContext;
    private DialogLinkManager mDialogLinkManager;
    private boolean mCanGo = true;
    private Runnable mTurnTableShowRunnable = new Runnable(){

        @Override
        public void run() {
            if (TurnTableDialogManager.this.mDialogLinkManager != null) {
                TurnTableDialogManager.this.mDialogLinkManager.dismissDialog();
            }
        }
    };

    public static TurnTableDialogManager newInstance(Context context) {
        return new TurnTableDialogManager(context);
    }

    private TurnTableDialogManager(Context context) {
        this.mContext = context;
        this.mDialogLinkManager = new DialogLinkManager(context);
    }

    public void showOwnerTurnTable(final IChannel channel, final TurnTableDialog turnTableDialog, final ITurntableOperationCallback callback) {
        if (turnTableDialog == null) {
            FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"showOwnerTurnTable turnTableDialog null", (Object[])new Object[0]);
            return;
        }
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"owner turntable show", (Object[])new Object[0]);
        this.mDialogLinkManager.showTransparentDialog((BaseDialog)turnTableDialog);
        turnTableDialog.setCallback(new TurnTableDialog.IOperationCallback(){

            @Override
            public void onClosed(String tips) {
                RoomTrack.INSTANCE.reportTurnTableCloseEvent("1", channel.getChannelId());
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"turntable click close", (Object[])new Object[0]);
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)TurnTableDialogManager.this.mTurnTableShowRunnable);
                TurnTableDialogManager.this.mDialogLinkManager.dismissDialog();
            }

            @Override
            public void onDismissed() {
                if (TurnTableDialogManager.this.mContext instanceof Activity) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"turntable dismiss", (Object[])new Object[0]);
                }
            }

            @Override
            public void onFinished() {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"owner turntable finished", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)TurnTableDialogManager.this.mTurnTableShowRunnable, (long)3000L);
            }

            @Override
            public void onResultShow(String tips) {
                TurnTableDialogManager.this.mCanGo = true;
                if (callback != null) {
                    callback.onResultShow(tips);
                }
            }

            @Override
            public void onGoClicked() {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"owner turntable onGoClicked", (Object[])new Object[0]);
                TurnTableDialogManager.this.mCanGo = false;
                turnTableDialog.showLoading();
                if (callback != null) {
                    callback.onGoClick();
                }
            }
        });
    }

    public void showGuestTurnTable(int index, TurnTableDialog turnTableDialog, final ITurntableOperationCallback callback, final IChannel channel) {
        FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable show, index:%s", (Object[])new Object[]{index});
        this.mDialogLinkManager.dismissDialog();
        this.mDialogLinkManager.showTransparentDialog((BaseDialog)turnTableDialog);
        turnTableDialog.setCallback(new TurnTableDialog.IOperationCallback(){

            @Override
            public void onClosed(String tips) {
                RoomTrack.INSTANCE.reportTurnTableCloseEvent("2", channel.getChannelId());
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable click close", (Object[])new Object[0]);
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)TurnTableDialogManager.this.mTurnTableShowRunnable);
                TurnTableDialogManager.this.mDialogLinkManager.dismissDialog();
            }

            @Override
            public void onDismissed() {
                if (TurnTableDialogManager.this.mContext instanceof Activity) {
                    FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable dismiss", (Object[])new Object[0]);
                }
            }

            @Override
            public void onFinished() {
                FeatureLog.i((String)"FTVoiceRoomTurnTable", (String)"guest turntable finished", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)TurnTableDialogManager.this.mTurnTableShowRunnable, (long)3000L);
            }

            @Override
            public void onResultShow(String tips) {
                if (callback != null) {
                    callback.onResultShow(tips);
                }
            }

            @Override
            public void onGoClicked() {
                if (callback != null) {
                    callback.onGoClick();
                }
            }
        });
    }

    public void hideTurnTable() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mTurnTableShowRunnable);
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    public boolean canGo() {
        return this.mCanGo;
    }

    public static interface ITurntableOperationCallback {
        public void onGoClick();

        public void onResultShow(String var1);
    }
}

