/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.base.callback.ICalculatorCallback;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.calculator.CalculatorStyleManager;
import com.yy.hiyo.tools.revenue.calculator.bean.CalculatorStyleData;
import com.yy.hiyo.tools.revenue.calculator.ui.ShimmerLayout;

public class CalculatorAnimationView
extends YYFrameLayout {
    private LinearLayout mLlFirstSeatCount;
    private LinearLayout mLlFirstSeatCountSpecial;
    private TextView mFirstNumberView;
    private FrameLayout mFlFirstSeatCount;
    private RecycleImageView mRvCountLeft;
    private RecycleImageView mRvCountRight;
    private ShimmerLayout mRlFirstLight;
    private ShimmerLayout mRlFirstLightSpecial;
    private View mLightView;
    private Animation mLightAnim;
    private FrameLayout mFlStyleCommon;
    private FrameLayout mflStyleSpacial;
    private TextView mFirstNumberSpecialView;
    private RecycleImageView mRvSpecial;
    private boolean mIsSmallMode = false;

    public CalculatorAnimationView(Context context) {
        super(context);
        this.initView(context);
    }

    public CalculatorAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public CalculatorAnimationView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        View.inflate((Context)context, (int)R.layout.layout_calculator_animation_view, (ViewGroup)this);
        this.mLlFirstSeatCount = (LinearLayout)this.findViewById(R.id.ll_first_seat_count);
        this.mFirstNumberView = (TextView)this.findViewById(R.id.seat_first_number_view);
        this.mFlFirstSeatCount = (FrameLayout)this.findViewById(R.id.fl_first_seat_count);
        this.mRvCountLeft = (RecycleImageView)this.findViewById(R.id.rv_count_left);
        this.mRvCountRight = (RecycleImageView)this.findViewById(R.id.rv_count_right);
        this.mRlFirstLight = (ShimmerLayout)this.findViewById(R.id.rl_first_light);
        this.mLightView = this.findViewById(R.id.view_first_bg);
        this.mFlStyleCommon = (FrameLayout)this.findViewById(R.id.fl_style_common);
        this.mflStyleSpacial = (FrameLayout)this.findViewById(R.id.fl_style_special);
        this.mFirstNumberSpecialView = (TextView)this.findViewById(R.id.seat_first_number_view_special);
        this.mRlFirstLightSpecial = (ShimmerLayout)this.findViewById(R.id.rl_calculator_speacial);
        this.mRvSpecial = (RecycleImageView)this.findViewById(R.id.rv_special);
        this.mLlFirstSeatCountSpecial = (LinearLayout)this.findViewById(R.id.ll_first_seat_count_special);
        this.expandViewTouchDelegate((View)this.mLlFirstSeatCount);
    }

    private void expandViewTouchDelegate(final View view) {
        ((View)view.getParent()).post(new Runnable(){

            @Override
            public void run() {
                Rect bounds = new Rect();
                view.setEnabled(true);
                view.getHitRect(bounds);
                bounds.top = view.getTop() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.bottom = view.getBottom() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.left = view.getLeft() + ResolutionUtils.dip2Px((float)150.0f);
                bounds.right = view.getRight() + ResolutionUtils.dip2Px((float)150.0f);
                TouchDelegate touchDelegate = new TouchDelegate(bounds, view);
                if (view.getParent() instanceof View) {
                    ((View)view.getParent()).setTouchDelegate(touchDelegate);
                }
            }
        });
    }

    private void startLightAnim(View targetView) {
        if (targetView == null) {
            return;
        }
        this.mRlFirstLight.setAnimationListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (CalculatorAnimationView.this.mLightView != null && CalculatorAnimationView.this.mLlFirstSeatCount != null) {
                    ((CalculatorAnimationView)CalculatorAnimationView.this).mLightView.getLayoutParams().height = ResolutionUtils.dip2Px((float)12.0f);
                    ((CalculatorAnimationView)CalculatorAnimationView.this).mLightView.getLayoutParams().width = CalculatorAnimationView.this.mLlFirstSeatCount.getMeasuredWidth() - ResolutionUtils.dip2Px((float)2.0f);
                    CalculatorAnimationView.this.showFirstBgAnimator(CalculatorAnimationView.this.mLightView);
                }
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                if (CalculatorAnimationView.this.mLightView != null && CalculatorAnimationView.this.mLlFirstSeatCount != null) {
                    ((CalculatorAnimationView)CalculatorAnimationView.this).mLightView.getLayoutParams().height = ResolutionUtils.dip2Px((float)12.0f);
                    ((CalculatorAnimationView)CalculatorAnimationView.this).mLightView.getLayoutParams().width = CalculatorAnimationView.this.mLlFirstSeatCount.getMeasuredWidth() - ResolutionUtils.dip2Px((float)2.0f);
                    CalculatorAnimationView.this.showFirstBgAnimator(CalculatorAnimationView.this.mLightView);
                }
            }
        });
        if (this.mRlFirstLight.getVisibility() == 0) {
            this.mRlFirstLight.startShimmerAnimation();
        } else if (this.mRlFirstLightSpecial.getVisibility() == 0) {
            this.mRlFirstLightSpecial.startShimmerAnimation();
        }
    }

    private void showFirstBgAnimator(final View view) {
        if (view == null) {
            return;
        }
        if (view.getVisibility() == 8) {
            return;
        }
        AlphaAnimation alphaAnimation2 = new AlphaAnimation(0.0f, 0.5f);
        alphaAnimation2.setDuration(300L);
        alphaAnimation2.setStartOffset(1000L);
        alphaAnimation2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.startAnimation((Animation)alphaAnimation2);
    }

    public void stopLightAnim() {
        if (this.mLightAnim != null) {
            this.mLightAnim.cancel();
        }
    }

    public void setNumber(CharSequence number) {
        if (TextUtils.isEmpty((CharSequence)number)) {
            return;
        }
        if (this.mFirstNumberView != null && this.mFirstNumberView.getVisibility() == 0) {
            this.mFirstNumberView.setText(number);
        } else if (this.mFirstNumberSpecialView != null && this.mFirstNumberSpecialView.getVisibility() == 0) {
            this.mFirstNumberSpecialView.setText(number);
        }
    }

    public void initLayout(String value, CalculatorData data) {
        if (data == null) {
            return;
        }
        CalculatorStyleData calculatorStyleData = CalculatorStyleManager.INSTANCE.getData(data.getMStyleId());
        if (calculatorStyleData == null) {
            return;
        }
        int style = 1;
        if (calculatorStyleData != null) {
            style = calculatorStyleData.getEffectStyle();
        }
        FeatureLog.d((String)"FTCalculator", (String)"initLayout style:%s", (Object[])new Object[]{calculatorStyleData});
        if (style == 1) {
            ImageLoader.loadImage((ImageView)this.mRvCountLeft, (String)calculatorStyleData.getLeftWingUrl(), (int)R.drawable.first_charmvalue_left);
            ImageLoader.loadImage((ImageView)this.mRvCountRight, (String)calculatorStyleData.getRightWingUrl(), (int)R.drawable.first_charmvalue_right);
            if (TextUtils.isEmpty((CharSequence)calculatorStyleData.getContentUrl())) {
                if (this.mLlFirstSeatCount != null) {
                    this.mLlFirstSeatCount.setBackgroundResource(R.drawable.first_charmvalue_bg);
                }
            } else {
                ImageLoader.loadBitmap((Context)this.getContext(), (String)(calculatorStyleData.getContentUrl() + YYImageUtils.getThumbSmall()), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        if (CalculatorAnimationView.this.mLlFirstSeatCount != null) {
                            CalculatorAnimationView.this.mLlFirstSeatCount.setBackgroundResource(R.drawable.first_charmvalue_bg);
                        }
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (CalculatorAnimationView.this.mLlFirstSeatCount != null) {
                            CalculatorAnimationView.this.mLlFirstSeatCount.setBackground((Drawable)new BitmapDrawable(bitmap));
                        }
                    }
                });
            }
            this.mFirstNumberSpecialView.setVisibility(8);
            this.mFirstNumberView.setVisibility(0);
            this.mFlStyleCommon.setVisibility(0);
            this.mflStyleSpacial.setVisibility(8);
            this.mRlFirstLightSpecial.setVisibility(8);
            this.mRlFirstLight.setVisibility(0);
            this.mRlFirstLight.setShimmerColor(Color.parseColor((String)calculatorStyleData.getSweepColor()));
            if (value.length() > 2) {
                this.mLlFirstSeatCount.getLayoutParams().width = data.getCalculatorValue() > 999L ? (value.length() > 6 ? ResolutionUtils.dip2Px((float)30.0f) + ResolutionUtils.spToPx((float)9.0f) * (value.length() - 2) : (value.length() > 4 ? ResolutionUtils.dip2Px((float)40.0f) + ResolutionUtils.spToPx((float)9.0f) * (value.length() - 2) : ResolutionUtils.dip2Px((float)40.0f) + ResolutionUtils.spToPx((float)9.0f) * (value.length() - 2))) : ResolutionUtils.dip2Px((float)40.0f) + ResolutionUtils.spToPx((float)9.0f) * (value.length() - 2);
                if (this.mLlFirstSeatCount.getLayoutParams().width > ResolutionUtils.dip2Px((float)50.0f)) {
                    this.mLlFirstSeatCount.getLayoutParams().width = ResolutionUtils.dip2Px((float)50.0f);
                }
            } else {
                this.mLlFirstSeatCount.getLayoutParams().width = ResolutionUtils.dip2Px((float)50.0f);
            }
            this.mLightView.setBackground(this.getBgDrawable(calculatorStyleData.getSweepColor()));
            this.mLightView.setVisibility(8);
            FontUtils.setFontType((TextView)this.mFirstNumberView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            FontUtils.setFontType((TextView)this.mFirstNumberSpecialView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        } else if (style == 2) {
            this.mFlStyleCommon.setVisibility(8);
            this.mflStyleSpacial.setVisibility(0);
            this.mFirstNumberSpecialView.setVisibility(0);
            this.mFirstNumberView.setVisibility(8);
            this.mRlFirstLightSpecial.setVisibility(0);
            this.mRlFirstLight.setVisibility(8);
            this.mRlFirstLightSpecial.setShimmerColor(Color.parseColor((String)calculatorStyleData.getSweepColor()));
            ImageLoader.loadImage((ImageView)this.mRvSpecial, (String)calculatorStyleData.getGemstoneUrl(), (int)R.drawable.calculator_special);
            if (TextUtils.isEmpty((CharSequence)calculatorStyleData.getContentUrl())) {
                if (this.mLlFirstSeatCountSpecial != null) {
                    this.mLlFirstSeatCountSpecial.setBackgroundResource(R.drawable.calculator_special_bg);
                }
            } else {
                ImageLoader.loadBitmap((Context)this.getContext(), (String)calculatorStyleData.getContentUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        if (CalculatorAnimationView.this.mLlFirstSeatCountSpecial != null) {
                            CalculatorAnimationView.this.mLlFirstSeatCountSpecial.setBackgroundResource(R.drawable.calculator_special_bg);
                        }
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (CalculatorAnimationView.this.mLlFirstSeatCountSpecial != null) {
                            CalculatorAnimationView.this.mLlFirstSeatCountSpecial.setBackground((Drawable)new BitmapDrawable(bitmap));
                        }
                    }
                });
            }
        }
        if (this.mIsSmallMode) {
            this.initSmallMode();
        }
    }

    public void initClickListener(final String roomId, final SeatItem data, final ICalculatorCallback listener2) {
        this.mLlFirstSeatCount.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (data == null || data.mCalculatorData == null) {
                    return;
                }
                SeatTrack.INSTANCE.calculatorCharmClick(roomId, String.valueOf(data.uid), String.valueOf(data.mCalculatorData.getCalculatorValue()));
                if (listener2 != null) {
                    listener2.onClickCalculator(data.uid, data.userInfo.nick, data.mCalculatorData);
                }
            }
        });
        this.mLlFirstSeatCountSpecial.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (data == null || data.mCalculatorData == null) {
                    return;
                }
                SeatTrack.INSTANCE.calculatorCharmClick(roomId, String.valueOf(data.uid), String.valueOf(data.mCalculatorData.getCalculatorValue()));
                if (listener2 != null) {
                    listener2.onClickCalculator(data.uid, data.userInfo.nick, data.mCalculatorData);
                }
            }
        });
    }

    public void clearAnimation() {
        MLog.info((Object)"CalculatorAnimationView", (String)"clearAnimation", (Object[])new Object[0]);
        if (null != this.mRlFirstLight) {
            this.mRlFirstLight.stopShimmerAnimation();
            this.mRlFirstLight.clearAnimation();
        }
        if (null != this.mRlFirstLightSpecial) {
            this.mRlFirstLightSpecial.stopShimmerAnimation();
            this.mRlFirstLightSpecial.clearAnimation();
        }
        this.mFirstNumberView.clearAnimation();
        this.mFirstNumberSpecialView.clearAnimation();
        this.mFlFirstSeatCount.clearAnimation();
        if (null != this.mLightView) {
            this.mLightView.clearAnimation();
        }
        this.stopLightAnim();
        super.clearAnimation();
    }

    private Drawable getBgDrawable(String color2) {
        float topLeftRadius;
        int fillColor = Color.parseColor((String)color2);
        float topRightRadius = topLeftRadius = (float)ResolutionUtils.dip2Px((float)30.0f) * 1.0f;
        float bottomRightRadius = topLeftRadius;
        float bottomLeftRadius = topLeftRadius;
        GradientDrawable gd = new GradientDrawable();
        gd.setGradientType(0);
        gd.setColor(fillColor);
        float[] array = new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
        gd.setCornerRadii(array);
        return gd;
    }

    public void shadeAnimator(View view, Animator.AnimatorListener listener2, long calculatorValue) {
        if (view == null) {
            return;
        }
        if (view.getVisibility() == 8) {
            return;
        }
        view.setTag(R.id.seat_number_view, (Object)calculatorValue);
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, 1.3f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, 1.3f, 1.0f});
        animatorSet.setDuration(360L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.play((Animator)scaleX).with((Animator)scaleY);
        animatorSet.start();
        if (listener2 != null) {
            animatorSet.addListener(listener2);
        }
    }

    public void shadeSeatCountAnimator(long calculatorValue, final CharSequence charmValue) {
        this.shadeAnimator((View)this.mFlFirstSeatCount, new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (CalculatorAnimationView.this.mRlFirstLight != null && CalculatorAnimationView.this.mLightView != null && CalculatorAnimationView.this.mRlFirstLight.getVisibility() == 0) {
                    if (CalculatorAnimationView.this.mFlFirstSeatCount.getVisibility() == 0) {
                        CalculatorAnimationView.this.startLightAnim((View)CalculatorAnimationView.this.mRlFirstLight);
                    }
                } else if (CalculatorAnimationView.this.mRlFirstLightSpecial != null && CalculatorAnimationView.this.mRlFirstLightSpecial.getVisibility() == 0) {
                    CalculatorAnimationView.this.startLightAnim((View)CalculatorAnimationView.this.mRlFirstLightSpecial);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }, calculatorValue);
        if (this.mFirstNumberView.getVisibility() == 0) {
            this.showTextAnimator((View)this.mFirstNumberView, new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (null != CalculatorAnimationView.this.mFirstNumberView) {
                        CalculatorAnimationView.this.mFirstNumberView.setText(charmValue);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else if (this.mFirstNumberSpecialView.getVisibility() == 0) {
            this.showTextAnimator((View)this.mFirstNumberSpecialView, new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (null != CalculatorAnimationView.this.mFirstNumberSpecialView) {
                        CalculatorAnimationView.this.mFirstNumberSpecialView.setText(charmValue);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        }
    }

    private void showTextAnimator(View view, Animation.AnimationListener animationListener) {
        if (view == null) {
            return;
        }
        if (view.getVisibility() == 8) {
            return;
        }
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-ResolutionUtils.dip2Px((float)14.0f)));
        translateAnimation.setDuration(180L);
        view.setAnimation((Animation)translateAnimation);
        translateAnimation.setAnimationListener(animationListener);
        view.startAnimation((Animation)translateAnimation);
    }

    public void startLightAnimation(CharSequence value) {
        if (this.mRlFirstLight != null && this.mLightView != null && this.mRlFirstLight.getVisibility() == 0) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (CalculatorAnimationView.this.mFlFirstSeatCount != null && CalculatorAnimationView.this.mFlFirstSeatCount.getVisibility() == 0) {
                        CalculatorAnimationView.this.startLightAnim((View)CalculatorAnimationView.this.mRlFirstLight);
                    }
                }
            }, (long)100L);
            this.mFirstNumberView.setText(value);
        } else if (this.mRlFirstLightSpecial != null && this.mRlFirstLightSpecial.getVisibility() == 0) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CalculatorAnimationView.this.startLightAnim((View)CalculatorAnimationView.this.mRlFirstLightSpecial);
                }
            }, (long)100L);
            this.mFirstNumberSpecialView.setText(value);
        }
    }

    private void initSmallMode() {
        if (this.mLlFirstSeatCount != null && this.mRvCountLeft != null && this.mRvCountRight != null && this.mRlFirstLightSpecial != null) {
            if (this.mLlFirstSeatCount.getLayoutParams().width > ResolutionUtils.dip2Px((float)40.0f)) {
                this.mLlFirstSeatCount.getLayoutParams().width = ResolutionUtils.dip2Px((float)40.0f);
            }
            FrameLayout.LayoutParams rightLayoutParams = (FrameLayout.LayoutParams)this.mRvCountRight.getLayoutParams();
            rightLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)5.0f);
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)rightLayoutParams);
            FrameLayout.LayoutParams leftLayoutParams = (FrameLayout.LayoutParams)this.mRvCountLeft.getLayoutParams();
            leftLayoutParams.leftMargin = ResolutionUtils.dip2Px((float)5.0f);
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)leftLayoutParams);
            this.mRlFirstLightSpecial.getLayoutParams().width = ResolutionUtils.dip2Px((float)50.0f);
        }
    }

    public void adjustSmallMode() {
        this.mIsSmallMode = true;
    }
}

