/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.gift;

import android.graphics.Point;
import android.text.TextUtils;
import android.util.Pair;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.reddot.IRedDot;
import com.yy.appbase.roomfloat.FloatMsgInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.FamilyInfoBean;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IMsgItemFactory;
import com.yy.hiyo.channel.cbase.publicscreen.callback.OnChatViewLocationChangeListener;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.cbase.tools.IFaceEmojiCallback;
import com.yy.hiyo.channel.cbase.tools.IGiftBroadcastCallback;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.tools.revenue.gift.GiftDataHelper;
import com.yy.hiyo.tools.revenue.gift.GiftTag;
import com.yy.hiyo.tools.revenue.gift.IRoomGiftService;
import com.yy.hiyo.tools.revenue.gift.SimpleGiftBehavior;
import com.yy.hiyo.tools.revenue.gift.WeakOnProfileCallback;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.action.ActivityTagInfo;
import com.yy.hiyo.wallet.base.bean.FamilyInfo;
import com.yy.hiyo.wallet.base.bean.KtvSongInfo;
import com.yy.hiyo.wallet.base.revenue.gift.GiftPanelInfo;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftPushBroMessage;
import com.yy.hiyo.wallet.base.revenue.gift.event.IBigEffectGiftListener;
import com.yy.hiyo.wallet.base.revenue.gift.event.IComboCallback;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftLifecycle;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftListener;
import com.yy.hiyo.wallet.base.revenue.gift.event.IShowGiftInterceptor;
import com.yy.hiyo.wallet.base.revenue.gift.event.SimpleGiftLifecycle;
import com.yy.hiyo.wallet.base.revenue.gift.event.SimpleGiftListener;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftFlashLocation;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftPublicScreenParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.ViewAnimDesParam;
import com.yy.hiyo.wallet.base.revenue.moneyreport.IMoneyReportService;
import com.yy.hiyo.wallet.base.revenue.moneyreport.ViewType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.ihago.money.api.family.FamilyLvConf;

public class RoomGiftServiceImpl
implements IRoomGiftService {
    private static final String TAG = GiftTag.TAG + "RoomGiftService";
    private InnerGiftBehavior mGiftBehavior;
    private IGiftLifecycle mGiftLifecycle;
    private IFaceEmojiCallback mFaceEmojiCallback;
    private volatile int[] mChatViewLocation = new int[2];
    private IGiftHandler mGiftHandler;
    private OnChatViewLocationChangeListener mChatViewLocationChangeListener;
    private ShowGiftPanelParam mShowGiftPanelParam;
    private ViewGroup mGiftLayer;
    private boolean isDestroy = false;
    private IComboCallback mComboCallback;
    private IChannel mVoiceRoom;
    private IGiftChannelCallback mChannelCallback;
    private List<IBigEffectGiftListener> mBigEffectGiftListeners = new ArrayList<IBigEffectGiftListener>();
    private List<IGiftBroadcastCallback> mGiftBroadcastCallbacks = new ArrayList<IGiftBroadcastCallback>();
    private ChannelDetailInfo mChannelDetailInfo;
    private final Set<String> mCurPlays = new CopyOnWriteArraySet<String>();
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    @Override
    public void init(IChannel room, ChannelDetailInfo channelDetailInfo) {
        EnterParam enterParam;
        RecommendEnterData recommendEnterData;
        GameInfo gameInfo;
        MLog.info((Object)TAG, (String)"init %s, RoomData %s", (Object[])new Object[]{this, room});
        this.mVoiceRoom = room;
        this.mChannelDetailInfo = channelDetailInfo;
        this.mGiftLifecycle = new SimpleGiftLifecycle(){};
        IBigEffectGiftListener bigEffectGiftListener = new IBigEffectGiftListener(){

            public void onFinish() {
                for (IBigEffectGiftListener callback : RoomGiftServiceImpl.this.mBigEffectGiftListeners) {
                    callback.onFinish();
                }
            }

            public void onPlay() {
                for (IBigEffectGiftListener callback : RoomGiftServiceImpl.this.mBigEffectGiftListeners) {
                    callback.onPlay();
                }
            }
        };
        SimpleGiftListener giftListener = new SimpleGiftListener(){

            public void onComboShow(IGiftHandler handler) {
                super.onComboShow(handler);
                if (RoomGiftServiceImpl.this.mComboCallback != null) {
                    RoomGiftServiceImpl.this.mComboCallback.onComboShow();
                }
            }

            public void onComboHide(IGiftHandler handler) {
                super.onComboHide(handler);
                if (RoomGiftServiceImpl.this.mComboCallback != null) {
                    RoomGiftServiceImpl.this.mComboCallback.onComboHide();
                }
            }

            public void onGiftBroadcast(IGiftHandler handler, @NonNull GiftBroResult result) {
                super.onGiftBroadcast(handler, result);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.RECEIVED_GIFT_IN_CHANNEL, (Object)result));
                if (!RoomGiftServiceImpl.this.mGiftBroadcastCallbacks.isEmpty()) {
                    for (IGiftBroadcastCallback callback : RoomGiftServiceImpl.this.mGiftBroadcastCallbacks) {
                        callback.onGiftBroadcast(result);
                    }
                }
            }

            public void onGiftPanelShown(IGiftHandler handler) {
                super.onGiftPanelShown(handler);
                if (!RoomGiftServiceImpl.this.mGiftBroadcastCallbacks.isEmpty()) {
                    for (IGiftBroadcastCallback callback : RoomGiftServiceImpl.this.mGiftBroadcastCallbacks) {
                        callback.onGiftPanelShown();
                    }
                }
                ((IMoneyReportService)ServiceManagerProxy.getServiceManager().getService(IMoneyReportService.class)).openViewEventReport(ViewType.TYPE_GIFT_PANEL, "", "", RoomGiftServiceImpl.this.mVoiceRoom.getChannelId());
            }

            public void onGiftPanelHidden(IGiftHandler handler) {
                super.onGiftPanelHidden(handler);
                if (!RoomGiftServiceImpl.this.mGiftBroadcastCallbacks.isEmpty()) {
                    for (IGiftBroadcastCallback callback : RoomGiftServiceImpl.this.mGiftBroadcastCallbacks) {
                        callback.onGiftPanelHidden();
                    }
                }
            }
        };
        this.mGiftBehavior = new InnerGiftBehavior();
        this.mChatViewLocationChangeListener = new OnChatViewLocationChangeListener(){

            public void onChatViewLocationChange(int[] loction) {
                boolean isChange = false;
                if (loction == null || loction.length != 2) {
                    RoomGiftServiceImpl.access$502(RoomGiftServiceImpl.this, new int[]{-1, -1});
                    isChange = true;
                } else {
                    for (int index = 0; index < loction.length; ++index) {
                        if (loction[index] == RoomGiftServiceImpl.this.mChatViewLocation[index]) continue;
                        isChange = true;
                        break;
                    }
                    if (isChange) {
                        boolean isRadioVideo;
                        RoomGiftServiceImpl.access$502(RoomGiftServiceImpl.this, loction);
                        ChannelPluginData pluginData = RoomGiftServiceImpl.this.getRoomData().getPluginService().getCurPluginData();
                        boolean bl = isRadioVideo = pluginData.mode == 14 && pluginData.isVideoMode();
                        if (isRadioVideo) {
                            ((RoomGiftServiceImpl)RoomGiftServiceImpl.this).mChatViewLocation[1] = RoomGiftServiceImpl.this.mChatViewLocation[1] - ResolutionUtils.dip2Px((float)50.0f);
                        }
                    }
                }
                if (isChange && RoomGiftServiceImpl.this.mGiftHandler != null && loction != null && loction.length == 2) {
                    GiftFlashLocation flashLocation = RoomGiftServiceImpl.this.mGiftHandler.getGiftHandlerParam().getFlashLocation();
                    flashLocation.setMarginTop(RoomGiftServiceImpl.this.mChatViewLocation[1]);
                    flashLocation.setMarginLeft(RoomGiftServiceImpl.this.mChatViewLocation[0]);
                    flashLocation.notifyLocationChanged();
                }
            }
        };
        IShowGiftInterceptor interceptor2 = giftInfo -> {
            ArrayList show2 = giftInfo.getShowPluginList();
            if (FP.empty((Collection)show2)) {
                return IShowGiftInterceptor.Opt.NONE;
            }
            String pluginId = "";
            if (!FP.anyNull((Object[])new Object[]{this.getRoomData(), this.getRoomData().getPluginService(), this.getRoomData().getPluginService().getCurPluginData()})) {
                pluginId = this.getRoomData().getPluginService().getCurPluginData().getPluginId();
            }
            for (String p : show2) {
                if (!StringUtils.equal((String)p, (String)pluginId) && !this.mCurPlays.contains(p)) continue;
                return IShowGiftInterceptor.Opt.FORCE_SHOW;
            }
            return IShowGiftInterceptor.Opt.HIDE;
        };
        String roomId = this.getRoomData().getChannelId();
        String cvid = this.mChannelDetailInfo.baseInfo.cvid;
        long ownerUid = this.mChannelDetailInfo.baseInfo.ownerUid;
        int channelMode = this.getRoomData().getPluginService().getCurPluginData().mode;
        String topId = this.getRoomData().getChannelId();
        String subId = "";
        if (StringUtils.isNotEmpty((String)topId) && !topId.equals(roomId)) {
            subId = roomId;
        }
        if ((gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.getRoomData().getPluginService().getCurPluginData().getPluginId())) != null && gameInfo.isRoomCheesGame()) {
            channelMode = -1;
        }
        GiftHandlerParam.Builder builder = GiftHandlerParam.newBuilder();
        ActivityTagInfo roomTag = new ActivityTagInfo(this.getRoomData().getPluginService().getCurPluginData().mode, this.mChannelDetailInfo.baseInfo.tag.getFirstTag().getTagId(), this.mChannelDetailInfo.baseInfo.tag.getFirstTag().getName());
        roomTag.setChannelRole(this.getRoomData().getRoleService().getMyRoleCache());
        builder.anchorUid(ownerUid).lifecycle(this.mGiftLifecycle).listener((IGiftListener)giftListener).channelId(GiftDataHelper.parseGiftChannel(channelMode, this.getRoomData().getPluginService().getCurPluginData().isVideoMode(), this.mChannelCallback.isVideoPk())).behavior((IGiftBehavior)this.mGiftBehavior).flashLocation(GiftDataHelper.paraseFlashParam(this.mChatViewLocation)).roomTag(roomTag).topId(this.getRoomData().getChannelId()).subId(subId).roomId(roomId).cvid(cvid).bigEffectListener(bigEffectGiftListener).showInterceptor(interceptor2);
        if (this.mVoiceRoom != null && this.mVoiceRoom.getEnterParam() != null && (recommendEnterData = (RecommendEnterData)(enterParam = this.mVoiceRoom.getEnterParam()).getExtra("from_recommend_info", null)) != null) {
            builder.recommendToken(recommendEnterData.getToken());
        }
        if (this.mGiftHandler == null || this.mGiftHandler.isFinish()) {
            IGiftHandler invalidHandler = ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).getGiftHandler(roomId);
            if (invalidHandler != null) {
                MLog.error((Object)TAG, (String)"init \u5f02\u5e38\uff0c\u524d\u4e00\u4e2a IGiftHandler \u6ca1\u6b63\u5e38\u9500\u6bc1 \u6216\u8005\u88ab\u5f02\u5e38\u8c03\u8d77, roomId %s", (Object[])new Object[]{roomId});
                invalidHandler.finish();
                if (RuntimeContext.sIsDebuggable) {
                    throw new IllegalStateException("init \u5f02\u5e38\uff0c\u524d\u4e00\u4e2a IGiftHandler \u6ca1\u6b63\u5e38\u9500\u6bc1 \u6216\u8005\u88ab\u5f02\u5e38\u8c03\u8d77 " + roomId);
                }
            }
            this.mGiftHandler = ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).createGiftHandler(builder.build());
        }
        this.mBinder.singleBindSourceTo((KvoSource)this.getRoomData().getPluginService().getCurPluginData());
        this.mBinder.singleBindSourceTo((KvoSource)this.getRoomData().getSeatService().getSeatData());
    }

    @Override
    public void onInitView(ViewGroup giftLayer, IGiftBehavior giftBehavior) {
        this.mGiftLayer = giftLayer;
        this.mGiftBehavior.setGiftBehavior(giftBehavior);
        if (this.mGiftBehavior != null) {
            this.mGiftHandler.start(giftLayer);
        }
    }

    public void preloadGiftList() {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.preloadGiftList();
        }
    }

    public void preloadGiftPackage() {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.loadPackageList(null);
        }
    }

    public void startPlay(String playId) {
        MLog.info((Object)TAG, (String)"startPlay playId: %s, mCurPlays: %s", (Object[])new Object[]{playId, this.mCurPlays});
        if (TextUtils.isEmpty((CharSequence)playId)) {
            return;
        }
        this.mCurPlays.add(playId);
    }

    public void stopPlay(String playId) {
        MLog.info((Object)TAG, (String)"stopPlay playId: %s, mCurPlays: %s", (Object[])new Object[]{playId, this.mCurPlays});
        if (TextUtils.isEmpty((CharSequence)playId)) {
            return;
        }
        this.mCurPlays.remove(playId);
    }

    public void pauseBigEffectSvga() {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.pauseBigEffectSvga();
        }
    }

    public void resumeBigEffectSvga() {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.resumeBigEffectSvga();
        }
    }

    public Boolean isGiftSvgaFinish() {
        if (this.mGiftHandler != null) {
            return this.mGiftHandler.isBigEffectSvgaFinish();
        }
        return true;
    }

    private void addPublicScreen(IGiftHandler handler, GiftPublicScreenParam param) {
        if (param == null) {
            MLog.error((Object)TAG, (String)"addPublicScreen param = null", (Object[])new Object[0]);
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"\u6536\u5230\u793c\u7269\u516c\u5c4f param=%s", (Object[])new Object[]{param});
        }
        int msgType = param.getType() == 13 ? 15 : 5;
        ArrayList<Long> uids = new ArrayList<Long>(2);
        uids.add(param.getReceiverUid());
        uids.add(param.getSenderUid());
        ChannelPluginData pluginData = this.getRoomData().getPluginService().getCurPluginData();
        boolean isRadioVideo = pluginData.mode == 14 && pluginData.isVideoMode();
        BaseImMsg baseImMsg = this.mChannelCallback.getMsgItemFactory().generateGiftMsg(this.mVoiceRoom.getChannelId(), param, this.getRoomData().getSeatService().getSeatData().getSeatIndex(param.getSenderUid()), this.getRoomData().getSeatService().getSeatData().getSeatIndex(param.getReceiverUid()), this.mVoiceRoom.getRoleService().getRoleCache(param.getSenderUid()), isRadioVideo);
        baseImMsg.setMsgState(1);
        this.mChannelCallback.sendChatMsg(baseImMsg);
    }

    private void addSysPublicScreenMsg(CharSequence tips) {
        this.mChannelCallback.sendChatMsg((BaseImMsg)this.mChannelCallback.getMsgItemFactory().generateSysTextMsg(this.mVoiceRoom.getChannelId(), tips.toString()));
    }

    private void addCustomScreenMsg(UserInfoKS userInfo, CharSequence content) {
        if (userInfo == null || content == null) {
            return;
        }
        PureTextMsg pureTextMsg = this.mChannelCallback.getMsgItemFactory().generateLocalPureTextMsg(this.mVoiceRoom.getChannelId(), content, this.mVoiceRoom.getRoleService().getRoleCache(userInfo.uid), userInfo.uid);
        pureTextMsg.setCanBeReported(false);
        this.mChannelCallback.sendChatMsg((BaseImMsg)pureTextMsg);
    }

    private IChannel getRoomData() {
        return this.mVoiceRoom;
    }

    @Override
    public void onViewDestroy() {
        MLog.info((Object)TAG, (String)"onViewDestroy mGiftHandler %s", (Object[])new Object[]{this.mGiftHandler});
        if (this.mGiftHandler != null) {
            this.mGiftHandler.pause();
        }
        if (this.mGiftLayer != null) {
            this.mGiftLayer = null;
        }
    }

    @Override
    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy %s", (Object[])new Object[]{this});
        this.isDestroy = true;
        this.mBinder.clearAllKvoConnections();
        if (this.mGiftHandler != null) {
            this.mGiftHandler.finish();
        }
        this.mGiftBehavior.setGiftBehavior(null);
    }

    @KvoMethodAnnotation(sourceClass=ChannelPluginData.class, name="id", thread=1)
    public void onGameIdChanged(KvoEventIntent event) {
        ChannelPluginData gameInfo = (ChannelPluginData)event.source();
        MLog.info((Object)TAG, (String)"onGameIdChanged\uff0cgameId=%s", (Object[])new Object[]{gameInfo.getPluginId()});
        if (this.mGiftHandler != null) {
            this.mGiftHandler.getGiftHandlerParam().setGameId(gameInfo.getPluginId());
        }
    }

    @KvoMethodAnnotation(sourceClass=SeatData.class, name="isSeatChanged", thread=1)
    public void onSeatListChanged(KvoEventIntent event) {
        StringBuilder uids = new StringBuilder();
        long ownerUid = this.mChannelDetailInfo.baseInfo.ownerUid;
        List seatUids = ((SeatData)event.source()).getSeatUidsList();
        Iterator iterator = seatUids.iterator();
        while (iterator.hasNext()) {
            long uid = (Long)iterator.next();
            uids.append(uid).append(",");
        }
        MLog.info((Object)TAG, (String)"onSeatListChanged uids=%s, ownerUid:%d", (Object[])new Object[]{uids, ownerUid});
        List otherSeatUids = ((SeatData)event.source()).getOtherSeatList();
        if (!FP.empty((Collection)otherSeatUids)) {
            for (Long uid : otherSeatUids) {
                if (!seatUids.contains(uid)) {
                    seatUids.add(uid);
                }
                uids.append(uid).append(",");
            }
        }
        this.onSeatUserChanged(seatUids);
    }

    @KvoMethodAnnotation(sourceClass=SeatData.class, name="otherSeatListChanged", thread=1)
    public void onOtherSeatListChanged(KvoEventIntent event) {
        List seatUids = ((SeatData)event.source()).getSeatUidsList();
        List otherSeatUids = ((SeatData)event.source()).getOtherSeatList();
        StringBuilder uids = new StringBuilder();
        if (!FP.empty((Collection)otherSeatUids)) {
            for (Long uid : otherSeatUids) {
                if (!seatUids.contains(uid)) {
                    seatUids.add(uid);
                }
                uids.append(uid).append(",");
            }
        }
        MLog.info((Object)TAG, (String)"onSeatListChanged otherSeatUids=%s", (Object[])new Object[]{uids});
        this.onSeatUserChanged(seatUids);
    }

    @Override
    public void showGiftPanelWithUid(ShowGiftPanelParam param) {
        if (this.mGiftHandler != null) {
            this.mShowGiftPanelParam = param;
            this.mShowGiftPanelParam.setRoomId(this.getRoomData().getChannelId());
            int originChannelMode = this.getRoomData().getPluginService().getCurPluginData().mode;
            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.getRoomData().getPluginService().getCurPluginData().getPluginId());
            if (gameInfo != null && gameInfo.isRoomCheesGame()) {
                originChannelMode = -1;
            }
            this.mShowGiftPanelParam.setUseChannel(GiftDataHelper.parseGiftChannel(originChannelMode, this.getRoomData().getPluginService().getCurPluginData().isVideoMode(), this.mChannelCallback.isVideoPk()));
            List seatUids = this.getRoomData().getSeatService().getSeatData().getSeatUidsList();
            List otherSeatUids = this.getRoomData().getSeatService().getSeatData().getOtherSeatList();
            if (!FP.empty((Collection)otherSeatUids)) {
                for (Long uid : otherSeatUids) {
                    if (seatUids.contains(uid)) continue;
                    seatUids.add(uid);
                }
            }
            this.mShowGiftPanelParam.setSeatUser(this.genGiftUserList(seatUids));
            this.onSeatUserChanged(seatUids);
            this.mGiftHandler.showGiftPanel(this.mShowGiftPanelParam);
            ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).reqMyVipBrand();
        }
    }

    private List<GiftUserInfo> genGiftUserList(List<Long> uidList) {
        List userInfoKSList = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, null);
        if (RuntimeContext.sIsDebuggable && userInfoKSList != null) {
            for (UserInfoKS userInfoKS : userInfoKSList) {
                if (MLog.isLogLevelAboveDebug()) continue;
                MLog.debug((Object)TAG, (String)"userInfoKS nick = %s,url=%s", (Object[])new Object[]{userInfoKS.nick, userInfoKS.avatar});
            }
        }
        return GiftDataHelper.genSeatList(userInfoKSList, this.mChannelDetailInfo.baseInfo.ownerUid, this.getRoomData().getSeatService());
    }

    private void onSeatUserChanged(List<Long> uidList) {
        int uidSize = 0;
        for (long uid : uidList) {
            if (uid <= 0L) continue;
            ++uidSize;
        }
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onSeatUserChanged uidList.size: %s ", (Object[])new Object[]{uidList});
        }
        if (uidSize > 0) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, (OnProfileCallback)new WeakOnProfileCallback(this, uidList));
        } else if (this.mShowGiftPanelParam != null) {
            this.mShowGiftPanelParam.setSeatUser(Collections.emptyList());
        }
    }

    void onUserInfoResponse(List<UserInfoKS> userInfoKSList, List<Long> uidList) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUserInfoResponse userInfoKSList %s, uidList %s", (Object[])new Object[]{userInfoKSList, uidList});
        }
        ArrayList<UserInfoKS> tempUserInfoKSList = new ArrayList<UserInfoKS>();
        block0: for (long uid : uidList) {
            for (UserInfoKS userInfoKS : userInfoKSList) {
                if (userInfoKS.uid != uid) continue;
                tempUserInfoKSList.add(userInfoKS);
                continue block0;
            }
        }
        List<GiftUserInfo> list = GiftDataHelper.genSeatList(tempUserInfoKSList, this.mChannelDetailInfo.baseInfo.ownerUid, this.getRoomData().getSeatService());
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onSeatUserChanged userInfoKSList.size: %s, tempUserInfoKSList.size: %d, list.size: %d", (Object[])new Object[]{FP.size(userInfoKSList), FP.size(tempUserInfoKSList), FP.size(list)});
        }
        if (this.mShowGiftPanelParam != null) {
            this.mShowGiftPanelParam.setSeatUser(list);
        }
    }

    public ViewGroup getFloatLayer() {
        return this.mGiftHandler.getFloatLayer();
    }

    @Override
    public OnChatViewLocationChangeListener getOnChatViewListener() {
        return this.mChatViewLocationChangeListener;
    }

    @Override
    public void setComboCallback(IComboCallback callback) {
        this.mComboCallback = callback;
    }

    public void setChannelCallback(IGiftChannelCallback channelCallback) {
        this.mChannelCallback = channelCallback;
    }

    @Override
    public void addGiftBroadcastCallback(IGiftBroadcastCallback callback) {
        if (callback != null) {
            this.mGiftBroadcastCallbacks.add(callback);
        }
    }

    @Override
    public void removeGiftBroadcastCallback(IGiftBroadcastCallback callback) {
        if (callback != null && this.mGiftBroadcastCallbacks.contains(callback)) {
            this.mGiftBroadcastCallbacks.remove(callback);
        }
    }

    @Override
    public void addBigEffectGiftList(IBigEffectGiftListener listener2) {
        if (listener2 != null && !this.mBigEffectGiftListeners.contains(listener2)) {
            this.mBigEffectGiftListeners.add(listener2);
        }
    }

    @Override
    public void removeBigEffectGiftList(IBigEffectGiftListener listener2) {
        if (listener2 != null && this.mBigEffectGiftListeners.contains(listener2)) {
            this.mBigEffectGiftListeners.remove(listener2);
        }
    }

    @Override
    public void onPluginSwitched(int newMode) {
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.getRoomData().getPluginService().getCurPluginData().getPluginId());
        if (gameInfo != null && gameInfo.isRoomCheesGame()) {
            newMode = -1;
        }
        int channelId = GiftDataHelper.parseGiftChannel(newMode, this.getRoomData().getPluginService().getCurPluginData().isVideoMode(), this.mChannelCallback.isVideoPk());
        MLog.info((Object)TAG, (String)"onChannelChanged\uff0corginChannelId=%s,channelId=%s", (Object[])new Object[]{newMode, channelId});
        if (this.mGiftHandler != null) {
            this.mGiftHandler.getGiftHandlerParam().setChannelId(channelId);
        }
    }

    @Override
    public void addBigEffectGift(GiftBroResult giftBroResult, int from) {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.addBigEffectView(giftBroResult, from);
        }
    }

    @Override
    public void sendGift(List<GiftUserInfo> receiver, int from, GiftItemInfo giftInfo, int gitNumber) {
        if (this.mGiftHandler != null) {
            this.mGiftHandler.sendGift(receiver, from, giftInfo, gitNumber);
        }
    }

    @Override
    public GiftPanelInfo getGiftPanelInfo() {
        if (this.mGiftHandler != null) {
            return this.mGiftHandler.getGiftPanelInfo();
        }
        return null;
    }

    @Override
    public boolean arGiftUpgrade(GiftItemInfo info) {
        return this.mGiftHandler.arGiftUpgrade(info);
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    static /* synthetic */ int[] access$502(RoomGiftServiceImpl x0, int[] x1) {
        x0.mChatViewLocation = x1;
        return x1;
    }

    static interface IGiftChannelCallback {
        public void sendChatMsg(BaseImMsg var1);

        public IMsgItemFactory getMsgItemFactory();

        public boolean isVideoPk();
    }

    private class InnerGiftBehavior
    extends SimpleGiftBehavior {
        IGiftBehavior mGiftBehavior;

        private InnerGiftBehavior() {
        }

        public void setGiftBehavior(IGiftBehavior giftBehavior) {
            this.mGiftBehavior = giftBehavior;
        }

        @Override
        public void appendPublicScreen(IGiftHandler handler, GiftPublicScreenParam param) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"appendPublicScreen,param = %s", (Object[])new Object[]{param.toString()});
            }
            RoomGiftServiceImpl.this.addPublicScreen(handler, param);
        }

        @Override
        public void appendSysPublicScreen(CharSequence tips) {
            RoomGiftServiceImpl.this.addSysPublicScreenMsg(tips);
        }

        @Override
        public synchronized Map<Long, FacePoint> locateSeat(IGiftHandler handler, Collection<Long> uids) {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.locateSeat(handler, uids);
            }
            return super.locateSeat(handler, uids);
        }

        @Override
        public boolean isUserOnMicSeat(IGiftHandler handler, long uid) {
            return RoomGiftServiceImpl.this.getRoomData().getSeatService().isInSeatAboutGift(uid);
        }

        @Override
        public Point defaultLocation() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.defaultLocation();
            }
            return super.defaultLocation();
        }

        @Override
        public ViewAnimDesParam getGiftButtonParam() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getGiftButtonParam();
            }
            return super.getGiftButtonParam();
        }

        @Override
        public void showGiftBoxAnim(String url, long showTime, long interval) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.showGiftBoxAnim(url, showTime, interval);
            }
        }

        @Override
        public void showGiftPanel(ShowGiftPanelParam param) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.showGiftPanel(param);
            }
        }

        @Override
        public void addGiftRedDot(IRedDot dot) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.addGiftRedDot(dot);
            }
        }

        @Override
        public String getRoomListPushToken() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getRoomListPushToken();
            }
            return super.getRoomListPushToken();
        }

        @Override
        public String getGameId() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getGameId();
            }
            return super.getGameId();
        }

        public void startSeatFlyAnim(int flyType, String splitSvga, long receiverUid) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.startSeatFlyAnim(flyType, splitSvga, receiverUid);
            }
        }

        @Override
        public void appendCustomPublicScreen(UserInfoKS userInfo, CharSequence content) {
            super.appendCustomPublicScreen(userInfo, content);
            RoomGiftServiceImpl.this.addCustomScreenMsg(userInfo, content);
        }

        @Override
        public void showFaceEmojiSvga(long fromUid, String id2) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.showFaceEmojiSvga(fromUid, id2);
            }
        }

        @Override
        public void openUserCard(long uid) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.openUserCard(uid);
            }
        }

        @Override
        public void addRoomPush(GiftPushBroMessage result) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.addRoomPush(result);
            }
        }

        @Override
        public void addGiftFloatView(FloatMsgInfo data) {
            if (this.mGiftBehavior != null) {
                this.mGiftBehavior.addGiftFloatView(data);
            }
        }

        public int getMode() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getMode();
            }
            return 0;
        }

        public Pair<List<Long>, List<Long>> getInnerPkSeatTeams() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getInnerPkSeatTeams();
            }
            return null;
        }

        public int getSubMode() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getSubMode();
            }
            return 0;
        }

        public int getVideoMode() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getVideoMode();
            }
            return 0;
        }

        public int playType() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.playType();
            }
            return 0;
        }

        public long videoPkFinishTime() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.videoPkFinishTime();
            }
            return 0L;
        }

        public String getPkId() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getPkId();
            }
            return "";
        }

        public int modePlay() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.modePlay();
            }
            return 0;
        }

        public int minCharm() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.minCharm();
            }
            return 0;
        }

        public String getVideoRoundId() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getVideoRoundId();
            }
            return "";
        }

        public FamilyInfo getMyFamilyInfo() {
            FamilyInfoBean bean = RoomGiftServiceImpl.this.getRoomData().getFamilyService().getCachedMyFamilyInfo();
            if (null != bean) {
                FamilyInfo familyInfo = new FamilyInfo(bean.getFid(), bean.getLv(), bean.getName(), bean.getAvatar(), "");
                if (null != bean.getConfig().getValue()) {
                    familyInfo.setLvIcon(((FamilyLvConf)bean.getConfig().getValue()).icon);
                }
                return familyInfo;
            }
            return null;
        }

        public KtvSongInfo getCurSongInfo() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getCurSongInfo();
            }
            return null;
        }

        public int getThemeId() {
            if (this.mGiftBehavior != null) {
                return this.mGiftBehavior.getThemeId();
            }
            return 0;
        }
    }
}

