/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.rank;

import android.content.Context;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankData;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankMvp;
import com.yy.hiyo.tools.revenue.calculator.rank.help.CalculatorRankHelpView;
import java.util.List;

public class CalculatorRankPanel
extends YYConstraintLayout
implements CalculatorRankMvp.IView,
View.OnClickListener {
    private IMvpContext mMvpContext;
    private CalculatorRankMvp.IPresenter mPresenter;
    private CommonStatusLayout statusLayout;
    private YYTextView valueTv;
    private YYTextView nameTv;
    private RecyclerView rankRv;
    private YYTextView pkRankTv;
    private BasePanel mCalculatorRankPanel;
    private long mCharmValue = 0L;
    private YYTextView tittleTv;
    private BasePanel.SimplePanelListener mListener;
    private View lLUserContainer;
    private String nickName;
    private CalculatorData mCalculatorData;
    private boolean isHatOpen = false;
    private long calculatorOpenState;

    public CalculatorRankPanel(IMvpContext context, String name, CalculatorData data, boolean hatOpen) {
        super(context.getContext());
        this.mMvpContext = context;
        this.nickName = name;
        this.isHatOpen = hatOpen;
        this.mCalculatorData = data;
        this.creatreView(data.getMCalculatorType());
    }

    private void creatreView(long calculatorOpenState) {
        View.inflate((Context)this.mMvpContext.getContext(), (int)R.layout.layout_calculator_rank_panel_channel, (ViewGroup)this);
        this.calculatorOpenState = calculatorOpenState;
        this.statusLayout = (CommonStatusLayout)this.findViewById(R.id.statuslayout);
        this.statusLayout.showLoading();
        this.tittleTv = (YYTextView)this.findViewById(R.id.tv_title);
        this.pkRankTv = (YYTextView)this.findViewById(R.id.pk_rank_tv);
        this.lLUserContainer = this.findViewById(R.id.layout_user);
        this.valueTv = (YYTextView)this.findViewById(R.id.tv_value);
        this.valueTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.nameTv = (YYTextView)this.findViewById(R.id.tv_user);
        this.nameTv.setText((CharSequence)this.nickName);
        this.rankRv = (RecyclerView)this.findViewById(R.id.rv_rank);
        this.rankRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mMvpContext.getContext()));
        this.findViewById(R.id.layout_top).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_help).setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public View getPanel() {
        return this;
    }

    public void setPresenter(CalculatorRankMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void setPanelListener(BasePanel.SimplePanelListener listener2) {
        this.mListener = listener2;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_help) {
            FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankPanel \u70b9\u51fbhelp", (Object[])new Object[0]);
            this.addView((View)new CalculatorRankHelpView(this.mMvpContext.getContext(), this.isHatOpen));
            if (null != this.mPresenter) {
                RoomTrack.INSTANCE.calculatorRankHelpClick(this.mPresenter.getRoomId());
            }
        }
    }

    public void showTotalValue(long value) {
        this.mCharmValue = value;
        this.valueTv.setText((CharSequence)String.valueOf(value));
    }

    public void showList(List<CalculatorRankData> list) {
        FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankPanel showList", (Object[])new Object[0]);
        if (null != this.statusLayout) {
            this.statusLayout.hideAllStatus();
        }
        this.rankRv.setAdapter((RecyclerView.Adapter)new RankAdapter(this.mMvpContext.getContext(), list, this.mPresenter));
        if (null != this.mPresenter) {
            RoomTrack.INSTANCE.calculatorRankShow(this.mPresenter.getRoomId(), "1", String.valueOf(this.mCharmValue));
        }
    }

    public void showError() {
        FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankPanel showError", (Object[])new Object[0]);
        if (null != this.statusLayout) {
            this.statusLayout.showError(0, ResourceUtils.getString((int)R.string.tips_loading_fail));
        }
    }

    public void showEmpty() {
        FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankPanel showEmpty", (Object[])new Object[0]);
        if (null != this.statusLayout) {
            this.statusLayout.showNoData(R.drawable.icon_default_no_data, (Spanned)new SpannableString((CharSequence)ResourceUtils.getString((int)R.string.tips_calculator_rank_empty)));
        }
        if (null != this.mPresenter) {
            RoomTrack.INSTANCE.calculatorRankShow(this.mPresenter.getRoomId(), "0", String.valueOf(this.mCharmValue));
        }
    }

    @Override
    public void hidePanel(DefaultWindow window) {
        if (null != this.mCalculatorRankPanel) {
            window.getPanelLayer().hidePanel(this.mCalculatorRankPanel, true);
            this.mCalculatorRankPanel = null;
        }
    }

    @Override
    public void showPanel(DefaultWindow window, long uid, String name) {
        FeatureLog.i((String)"FTVoiceRoom", (String)"CalculatorRankPanel show", (Object[])new Object[0]);
        if (null != window) {
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(12);
            if (this.mCalculatorRankPanel == null) {
                this.mCalculatorRankPanel = new BasePanel(this.getContext());
                this.mCalculatorRankPanel.setShowAnim(this.mCalculatorRankPanel.createBottomShowAnimation());
                this.mCalculatorRankPanel.setHideAnim(this.mCalculatorRankPanel.createBottomHideAnimation());
                this.mCalculatorRankPanel.setListener((BasePanel.IPanelListener)this.mListener);
            }
            this.mCalculatorRankPanel.setContent((View)this, params);
            window.getPanelLayer().showPanel(this.mCalculatorRankPanel, true);
            this.lLUserContainer.setVisibility(0);
            this.tittleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_calculator_rank));
            this.pkRankTv.setVisibility(8);
            this.tittleTv.setTextColor(ResourceUtils.getColor((int)R.color.color_999999));
        }
    }

    static class RankAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int TYPE_NORMAL = 0;
        private static final int TYPE_FOOTER = 1;
        private static final int MAX_COUNT = 100;
        private Context mContext;
        private CalculatorRankMvp.IPresenter mPresenter;
        private List<CalculatorRankData> mList;

        public RankAdapter(Context context, List<CalculatorRankData> list, CalculatorRankMvp.IPresenter presenter) {
            this.mContext = context;
            this.mList = list;
            this.mPresenter = presenter;
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return viewType == 1 ? new FooterViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.footer_calculator_rank_channel, parent, false)) : new NormalViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_calculator_rank_channel, parent, false));
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            if (this.getItemViewType(position) == 0 && this.mList.size() > position) {
                CalculatorRankData calculatorRankData = this.mList.get(position);
                NormalViewHolder normalViewHolder = (NormalViewHolder)holder;
                normalViewHolder.bindViewHolder(calculatorRankData, position);
            }
        }

        public int getItemCount() {
            return this.mList.size() >= 100 ? 101 : this.mList.size();
        }

        public int getItemViewType(int position) {
            return 100 == position ? 1 : 0;
        }

        class FooterViewHolder
        extends RecyclerView.ViewHolder {
            public FooterViewHolder(View itemView) {
                super(itemView);
            }
        }

        class NormalViewHolder
        extends RecyclerView.ViewHolder {
            private CircleImageView headIv;
            private YYImageView rankingIv;
            private YYTextView nameTv;
            private YYTextView valueTv;
            private YYTextView rankingTv;
            private YYTextView joinTv;
            private CalculatorRankData calculatorRankData;
            private int[] rankImg;

            NormalViewHolder(View itemView) {
                super(itemView);
                this.rankImg = new int[]{R.drawable.calculator_rank_1, R.drawable.calculator_rank_2, R.drawable.calculator_rank_3};
                this.headIv = (CircleImageView)itemView.findViewById(R.id.iv_head);
                this.rankingIv = (YYImageView)itemView.findViewById(R.id.iv_ranking);
                this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
                this.valueTv = (YYTextView)itemView.findViewById(R.id.tv_value);
                this.rankingTv = (YYTextView)itemView.findViewById(R.id.tv_ranking);
                this.joinTv = (YYTextView)itemView.findViewById(R.id.tv_join);
                this.joinTv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != RankAdapter.this.mPresenter && NormalViewHolder.this.calculatorRankData != null) {
                            RankAdapter.this.mPresenter.showGiftPanelWithUid(NormalViewHolder.this.calculatorRankData.getUid());
                        }
                    }
                });
                itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != RankAdapter.this.mPresenter) {
                            RankAdapter.this.mPresenter.clickItem((CalculatorRankData)RankAdapter.this.mList.get(NormalViewHolder.this.getAdapterPosition()));
                        }
                    }
                });
            }

            public void bindViewHolder(CalculatorRankData calculatorRankData, int position) {
                this.calculatorRankData = calculatorRankData;
                if (calculatorRankData.getIndex() > 0 && calculatorRankData.getIndex() <= this.rankImg.length) {
                    this.rankingIv.setImageResource(this.rankImg[calculatorRankData.getIndex() - 1]);
                    this.rankingIv.setVisibility(0);
                    this.rankingTv.setVisibility(8);
                } else if (calculatorRankData.getCalcuType() == 2L) {
                    this.rankingIv.setVisibility(8);
                    this.rankingTv.setVisibility(0);
                    this.rankingTv.setText((CharSequence)String.valueOf(position + 1));
                }
                String nick = calculatorRankData.getNick();
                String avatar = calculatorRankData.getAvatar();
                if (TextUtils.isEmpty((CharSequence)nick) || TextUtils.isEmpty((CharSequence)avatar)) {
                    UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(calculatorRankData.getUid());
                    nick = userInfoKS.nick;
                    avatar = userInfoKS.avatar;
                }
                this.nameTv.setText((CharSequence)nick);
                this.valueTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
                this.valueTv.setText((CharSequence)String.valueOf(calculatorRankData.getCharmValue()));
                this.rankingTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
                ImageLoader.loadImage((ImageView)this.headIv, (String)(avatar + YYImageUtils.getThumbnailPostfix((int)75)));
            }
        }
    }
}

