/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.calculator.rank;

import android.content.Context;
import android.view.View;
import android.widget.RelativeLayout;
import com.yy.base.featurelog.FeatureLog;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankData;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankModel;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankMvp;
import com.yy.hiyo.tools.revenue.calculator.rank.CalculatorRankPanel;
import com.yy.hiyo.tools.revenue.calculator.rank.help.CalculatorRankHelpView;
import com.yy.hiyo.tools.revenue.gift.RoomGiftPresenter;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import java.util.Collections;
import java.util.List;

public class CalculatorRankPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements CalculatorRankMvp.IPresenter {
    private CalculatorRankPanel mView;
    private CalculatorRankModel mModel;
    private CalculatorRankHelpView mRankHelpView;
    private BasePanel mCalculatorRankPanel;
    private CalculatorRankModel.GetRankCallback mGetRankCallback = new CalculatorRankModel.GetRankCallback(){

        @Override
        public void onSuccess(long value, List<CalculatorRankData> list) {
            if (null != CalculatorRankPresenter.this.mView) {
                CalculatorRankPresenter.this.mView.showTotalValue(value);
                if (null == list || list.isEmpty()) {
                    CalculatorRankPresenter.this.mView.showEmpty();
                } else {
                    CalculatorRankPresenter.this.mView.showList(list);
                }
            }
        }

        @Override
        public void onFail() {
            if (null != CalculatorRankPresenter.this.mView) {
                CalculatorRankPresenter.this.mView.showError();
            }
        }
    };

    public void onInit(IChannelPageContext<AbsPage> mvpContext2) {
        super.onInit(mvpContext2);
        this.mModel = new CalculatorRankModel();
    }

    @Override
    public void clickItem(CalculatorRankData item) {
        FeatureLog.i((String)"FTCalculator", (String)"CalculatorRankPresenter \u70b9\u51fbitem\uff0cuid: %s", (Object[])new Object[]{item.getUid()});
        ((ProfileCardPresenter)this.getPresenter(ProfileCardPresenter.class)).showProfileCard(item.getUid(), true, OpenProfileFrom.FROM_OTHER);
        if (null != this.mView) {
            this.mView.hidePanel((DefaultWindow)this.getWindow());
        }
    }

    @Override
    public void showGiftPanelWithUid(long uid) {
        ShowGiftPanelParam param = new ShowGiftPanelParam(10);
        param.setSelectedUid(Collections.singletonList(uid));
        ((RoomGiftPresenter)this.getPresenter(RoomGiftPresenter.class)).showGiftPanel(param);
        if (null != this.mView) {
            this.mView.hidePanel((DefaultWindow)this.getWindow());
        }
    }

    @Override
    public void showView(long uid, String name, CalculatorData data) {
        if (null == this.mView) {
            this.mView = new CalculatorRankPanel(this.getMvpContext(), name, data, this.getChannel().getCalculatorService().isHatOpen());
            this.mView.setPresenter(this);
            this.mView.setPanelListener(new BasePanel.SimplePanelListener(){

                public void onPanelHidden(BasePanel panel) {
                    super.onPanelHidden(panel);
                    CalculatorRankPresenter.this.mView = null;
                }
            });
        }
        this.fetchRank(uid, data.getMCalculatorType());
        this.mView.showPanel((DefaultWindow)this.getWindow(), uid, name);
    }

    @Override
    public void showCalculatorRankHelpView() {
        if (null == this.mRankHelpView) {
            this.mRankHelpView = new CalculatorRankHelpView((Context)((IChannelPageContext)this.getMvpContext()).getContext(), true);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
            params.addRule(12);
            if (this.mCalculatorRankPanel == null) {
                this.mCalculatorRankPanel = new BasePanel((Context)((IChannelPageContext)this.getMvpContext()).getContext());
                this.mCalculatorRankPanel.setShowAnim(this.mCalculatorRankPanel.createBottomShowAnimation());
                this.mCalculatorRankPanel.setHideAnim(this.mCalculatorRankPanel.createBottomHideAnimation());
            }
            this.mCalculatorRankPanel.setContent((View)this.mRankHelpView, params);
        }
        this.getWindow().getPanelLayer().showPanel(this.mCalculatorRankPanel, true);
    }

    @Override
    public String getRoomId() {
        return null != this.getRoomData() ? this.getRoomData().getRoomId() : "";
    }

    private void fetchRank(long uid, long calculatorOpenState) {
        if (null != this.getRoomData()) {
            this.mModel.getRank(this.getRoomData().getRoomId(), uid, this.mGetRankCallback);
        }
    }
}

