/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.tools.revenue.turntable.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.tools.revenue.R;
import com.yy.hiyo.tools.revenue.turntable.TurnTableItem;
import com.yy.hiyo.tools.revenue.turntable.ui.TurnTableItemView;
import java.util.ArrayList;
import java.util.List;

public class TurnTableView
extends YYRelativeLayout {
    private List<TurnTableItem> mGiftList = new ArrayList<TurnTableItem>();
    private IOperationCallback mCallback;
    private RecycleImageView mPointerView;
    private ProgressBar mProgressBar;
    private View mCenterInnerView;
    private View mTargetInnerView;
    private RecycleImageView mRvTargetPointerView;
    private RelativeLayout mRlTargetPointerBg;

    public TurnTableView(@NonNull Context context) {
        this(context, null);
    }

    public TurnTableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundResource(17170445);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_turntable_content_channel, (ViewGroup)this);
        this.mCenterInnerView = this.findViewById(R.id.turntable_inner);
        this.mTargetInnerView = this.findViewById(R.id.turntable_target);
        this.shadeAnimator(this.mCenterInnerView);
        this.mRlTargetPointerBg = (RelativeLayout)this.mTargetInnerView.findViewById(R.id.rl_turntable_pointer);
        this.mTargetInnerView.setVisibility(8);
        YYRelativeLayout pointerBgView = (YYRelativeLayout)this.mCenterInnerView.findViewById(R.id.rl_turntable_pointer_bg);
        pointerBgView.setVisibility(0);
        this.mPointerView = (RecycleImageView)this.mCenterInnerView.findViewById(R.id.iv_turntable_pointer);
        this.mRvTargetPointerView = (RecycleImageView)this.mTargetInnerView.findViewById(R.id.iv_turntable_pointer);
        this.mPointerView.setVisibility(0);
        this.mProgressBar = (ProgressBar)this.mCenterInnerView.findViewById(R.id.pb_turntable);
        this.mPointerView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TurnTableView.this.mCallback != null) {
                    TurnTableView.this.startClickAnimation((View)TurnTableView.this.mPointerView);
                    TurnTableView.this.mCallback.onGoClicked();
                }
            }
        });
    }

    private void shadeAnimator(View view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.0f, 1.1f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.0f, 1.1f, 1.0f});
        animatorSet.setDuration(300L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.play((Animator)scaleX).with((Animator)scaleY);
        animatorSet.start();
    }

    public void isOwner(boolean isOwner) {
        if (this.mPointerView != null) {
            ImageLoader.loadImage((ImageView)this.mPointerView, (int)(isOwner ? R.drawable.turntable_go : R.drawable.turntable_hago));
            this.mPointerView.setEnabled(isOwner);
        }
    }

    public void start(int index) {
        if (this.mTargetInnerView != null && this.mCenterInnerView != null && this.mGiftList != null && this.mGiftList.size() >= index) {
            int i;
            this.mCenterInnerView.setVisibility(8);
            this.mTargetInnerView.setVisibility(0);
            this.mRvTargetPointerView.setEnabled(false);
            this.mRvTargetPointerView.setBackgroundResource(R.drawable.turntable_hago);
            ArrayList<TurnTableItem> giftList = new ArrayList<TurnTableItem>();
            ArrayList<TurnTableItem> subList = new ArrayList<TurnTableItem>();
            int size = this.mGiftList.size();
            for (i = 0; i < size; ++i) {
                if (i >= index) {
                    giftList.add(this.mGiftList.get(i));
                    continue;
                }
                subList.add(this.mGiftList.get(i));
            }
            size = subList.size();
            for (i = 0; i < size; ++i) {
                giftList.add((TurnTableItem)subList.get(i));
            }
            this.initGift(this.mTargetInnerView, giftList);
            ObjectAnimator startAnimator = ObjectAnimator.ofFloat((Object)this.mRlTargetPointerBg, (String)"rotation", (float[])new float[]{0.0f, 960.0f});
            startAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            startAnimator.setDuration(3000L);
            startAnimator.start();
            startAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (TurnTableView.this.mCallback != null) {
                        TurnTableView.this.mCallback.onFinished();
                    }
                }
            });
        }
    }

    public void showLoading() {
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(0);
        }
    }

    public void hideLoading() {
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(8);
        }
    }

    public void disable() {
        if (this.mPointerView != null) {
            ImageLoader.loadImage((ImageView)this.mPointerView, (int)R.drawable.turntable_hago);
            this.mPointerView.setEnabled(false);
        }
    }

    private void startClickAnimation(View view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.8f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.8f, 1.0f});
        animatorSet.setDuration(300L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.play((Animator)scaleX).with((Animator)scaleY);
        animatorSet.start();
    }

    public void setOnOperationCallback(IOperationCallback callback) {
        this.mCallback = callback;
    }

    public void setContent(List<TurnTableItem> giftList) {
        if (giftList != null) {
            this.mGiftList.clear();
            this.mGiftList.addAll(giftList);
            if (this.mCenterInnerView != null) {
                this.initGift(this.mCenterInnerView, this.mGiftList);
            }
        }
    }

    private void initGift(View view, List<TurnTableItem> giftList) {
        if (giftList != null) {
            int size = giftList.size();
            for (int i = 0; i < size; ++i) {
                TurnTableItemView giftView;
                TurnTableItem turnTableItem = giftList.get(i);
                if (i == 0) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_first);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 1) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_two);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 2) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_third);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 3) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_four);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 4) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_five);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 5) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_six);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i == 6) {
                    giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_seven);
                    giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                    giftView.setCount(turnTableItem.getCount());
                    continue;
                }
                if (i != 7) continue;
                giftView = (TurnTableItemView)view.findViewById(R.id.iv_gift_eight);
                giftView.setGift(turnTableItem.getUrl() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)43.0f)));
                giftView.setCount(turnTableItem.getCount());
            }
        }
    }

    public static interface IOperationCallback {
        public void onGoClicked();

        public void onFinished();
    }

    public class AccelerateDecelerateInterpolator
    implements Interpolator {
        public float getInterpolation(float input) {
            return (float)(Math.cos((double)(input + 1.0f) * Math.PI) / (double)0.8f) + 1.0f;
        }
    }
}

