/*
 * Decompiled with CFR 0.152.
 */
package com.yy.report.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.provider.MediaStore;
import androidx.annotation.UiThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.dialog.PunishToastDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ReportMsgDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.report.base.ReportModuleMsgDef;
import com.yy.hiyo.report.base.ReportOpenEvent;
import com.yy.report.R;
import com.yy.report.msg.ReportTextImageParam;
import com.yy.report.request.ReportRequestManager;
import com.yy.report.ui.dialog.ReportDialog;
import com.yy.report.ui.dialog.ReportNewDialog;
import com.yy.report.ui.dialog.ReportThanksDialog;
import com.yy.report.uicallback.IReportViewCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class ReportController
extends DefaultWindowController
implements IReportViewCallBack {
    private static final String TAG = "ReportController";
    public static final int PHOTO_GET_PATH = 101;
    private int uploadImgNum = 0;
    private int uploadedNum = 0;
    private List<String> uploadImgUrls = new ArrayList<String>();
    private int reqGetImgPathIndex = -1;
    private ReportDialog dialog;
    private ReportNewDialog reportDialog;
    private int reportType = -1;
    private ReportOpenEvent reportOpenEvent;
    public static final int CHATTING_TYPE = 5;
    public static final int PROFILE_TYPE = 6;
    public static final int CHEATING_TYPE = 3;
    public static final int PORNOGRAPHIC_TYPE = 1;
    public static final int AUDIO_TYPE = 25;
    public static final int PROFILE_AVATAR_ALBUM_TYPE = 60001;
    public static final int PROFILE_NICKNAME_SIGN_TYPE = 60002;

    public ReportController(Environment env) {
        super(env);
        this.registerMessage(ReportModuleMsgDef.REQ_IMG_PATH_RESULT);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ReportModuleMsgDef.OPEN_WINDOW_REPORT) {
            this.reportOpenEvent = (ReportOpenEvent)msg.getData().getSerializable("data");
            this.dialog = new ReportDialog(this);
            this.mDialogLinkManager.showDialog((BaseDialog)this.dialog);
            if (StringUtils.isNotEmpty((String)this.reportOpenEvent.captureImgPath)) {
                this.dialog.onGetPhotoPath(0, this.reportOpenEvent.captureImgPath);
            }
        } else if (msg.what == ReportMsgDef.IMG_TEXT) {
            msg.arg1 = 5;
            this.handleTextImage(msg.arg1, msg.getData(), msg.replyTo);
        } else if (msg.what == ReportModuleMsgDef.OPEN_NEW_WINDOW_REPORT) {
            this.reportOpenEvent = (ReportOpenEvent)msg.getData().getSerializable("data");
            this.reportDialog = new ReportNewDialog(this);
            this.mDialogLinkManager.showDialog((BaseDialog)this.reportDialog);
        } else if (msg.what == ReportMsgDef.VOICE_REPORT) {
            this.handleTextImage(msg.arg1, msg.getData(), msg.replyTo);
        } else if (msg.what == ReportMsgDef.PROFILE_REPORT) {
            ReportTextImageParam param = new ReportTextImageParam();
            param.targetUid = (Long)msg.obj;
            int reportType = msg.arg1 == 0 ? 6 : msg.arg1;
            this.reportTextImage(reportType, param, null);
        } else if (msg.what == ReportMsgDef.IM_AUDIO) {
            this.handleTextImage(25, msg.getData(), msg.replyTo);
        }
    }

    public Object handleMessageSync(Message msg) {
        Uri uri;
        String path;
        Intent intent;
        Bundle bundle;
        int resultCode;
        if (msg.what == ReportModuleMsgDef.REQ_IMG_PATH_RESULT && (resultCode = (bundle = msg.getData()).getInt("resultCode")) == -1 && (intent = (Intent)bundle.getParcelable("data")) != null && !FP.empty((CharSequence)(path = this.getImgPathFromUri(uri = intent.getData())))) {
            this.onGetPhotoPath(path);
        }
        return super.handleMessageSync(msg);
    }

    private void handleTextImage(final int type, final Bundle data, final Messenger replyTo) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (data != null) {
                    ReportTextImageParam param = new ReportTextImageParam();
                    param.targetUid = data.getLong("targetUid");
                    param.textList = data.getStringArrayList("textList");
                    param.imgList = data.getStringArrayList("imgList");
                    param.audioList = data.getStringArrayList("audioList");
                    if (param.targetUid > 0L) {
                        ReportController.this.reportTextImage(type, param, replyTo);
                    }
                }
            }
        });
    }

    private void onGetPhotoPath(String path) {
        MLog.info((Object)TAG, (String)"onGetPhotoPath %s", (Object[])new Object[]{path});
        if (this.dialog != null) {
            this.dialog.onGetPhotoPath(this.reqGetImgPathIndex, path);
        }
    }

    @Override
    public void onSubmitClick(int reportType, List<String> imgPaths) {
        ReportThanksDialog dialog = new ReportThanksDialog();
        this.mDialogLinkManager.showDialog((BaseDialog)dialog);
        this.dialog = null;
        this.uploadedNum = 0;
        this.uploadImgUrls.clear();
        this.uploadImgNum = FP.empty(imgPaths) ? 0 : imgPaths.size();
        this.reportType = reportType;
        if (this.uploadImgNum == 0) {
            this.sendReportReq();
            return;
        }
        for (int i = 0; i < this.uploadImgNum; ++i) {
            this.uploadReportImg(imgPaths.get(i));
        }
    }

    @Override
    public void reqGetImagePath(int index) {
        if (index < 0 || index > 3) {
            return;
        }
        this.reqGetImgPathIndex = index;
        Intent intent = new Intent();
        intent.setAction("android.intent.action.PICK");
        intent.setData(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        try {
            ((Activity)this.getCurrentWindow().getContext()).startActivityForResult(intent, 101);
        }
        catch (Exception ex) {
            MLog.error((Object)this, (String)"selectPhoto fail, %s", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    @Override
    public void onDialogCancel() {
        this.dialog = null;
        this.deleteDefaultCapture();
    }

    @Override
    public void onNewSubmitClick(int reportType) {
        this.reportType = reportType;
        this.uploadImgUrls.clear();
        String type = "";
        if (this.reportOpenEvent == null || this.reportOpenEvent.targetUserInfo == null) {
            return;
        }
        if (reportType == 5) {
            this.sendChatMessageReportReq(reportType);
            type = "chatting";
        } else if (reportType == 6 || reportType == 3 || reportType == 60001 || reportType == 60002) {
            ReportTextImageParam param = new ReportTextImageParam();
            param.targetUid = this.reportOpenEvent.targetUserInfo.uid;
            param.pageSource = 1;
            this.reportTextImage(reportType, param, null);
            type = reportType == 6 ? "profile" : "cheating";
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028009").put("function_id", "report").put("act_uid", String.valueOf(this.reportOpenEvent.targetUserInfo.uid)).put("report", type));
        this.reportDialog = null;
    }

    private void sendChatMessageReportReq(int reportType) {
        if (this.reportOpenEvent == null || this.reportOpenEvent.targetUserInfo == null) {
            return;
        }
        ((ImService)this.getServiceManager().getService(ImService.class)).getIMHistory(29, this.reportOpenEvent.targetUserInfo.uid, 1, datas -> {
            MLog.info((Object)TAG, (String)"sendReportReq", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"sendReportReq:%s", (Object[])new Object[]{datas != null ? datas.toString() : ""});
            }
            ArrayList<String> msgList = new ArrayList<String>();
            if (datas != null && datas.size() > 0) {
                int size = datas.size();
                for (int i = size - 1; i >= 0; --i) {
                    ImMessageDBBean item = (ImMessageDBBean)datas.get(i);
                    if (item == null || item.getUid() == AccountUtil.getUid()) continue;
                    if (item.getContentType() == 2) {
                        this.uploadImgUrls.add(item.getContent());
                        continue;
                    }
                    msgList.add(item.getContent());
                }
            }
            ReportTextImageParam param = new ReportTextImageParam();
            param.targetUid = this.reportOpenEvent.targetUserInfo.uid;
            param.imgList = this.uploadImgUrls;
            param.textList = msgList;
            param.pageSource = 1;
            this.reportTextImage(reportType, param, null);
        });
    }

    private void uploadReportImg(String path) {
        String name = FileUtils.getFileName((String)path);
        String objectKey = StringUtils.formatWitUSLocal((String)"report_img/%d/%d/%s", (Object[])new Object[]{AccountUtil.getUid(), System.currentTimeMillis(), name});
        ((IOOSService)this.getServiceManager().getService(IOOSService.class)).uploadFile(objectKey, path, new IUploadObjectCallBack(){

            public void onSuccess(UploadObjectRequest request) {
                ReportController.this.uploadedNum++;
                String imageUrl = request.mUrl;
                MLog.info((Object)ReportController.TAG, (String)"uploadReportImg onSuccess %s", (Object[])new Object[]{imageUrl});
                ReportController.this.uploadImgUrls.add(imageUrl);
                if (ReportController.this.uploadedNum == ReportController.this.uploadImgNum) {
                    ReportController.this.sendReportReq();
                }
            }

            public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                MLog.error((Object)ReportController.TAG, (String)"uploadReportImg  onFailure %d %s", (Object[])new Object[]{errorCode, exception.getMessage()});
                ReportController.this.uploadedNum++;
                if (ReportController.this.uploadedNum == ReportController.this.uploadImgNum) {
                    ReportController.this.sendReportReq();
                }
            }
        });
    }

    private void sendReportReq() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ReportController.this.reportOpenEvent == null || ((ReportController)ReportController.this).reportOpenEvent.targetUserInfo == null) {
                    return;
                }
                ((ImService)ReportController.this.getServiceManager().getService(ImService.class)).getIMHistory(20, ((ReportController)ReportController.this).reportOpenEvent.targetUserInfo.uid, -1, datas -> {
                    MLog.info((Object)ReportController.TAG, (String)"sendReportReq", (Object[])new Object[0]);
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)ReportController.TAG, (String)"sendReportReq:%s", (Object[])new Object[]{datas != null ? datas.toString() : ""});
                    }
                    ArrayList<String> msgList = new ArrayList<String>();
                    if (datas != null && datas.size() > 0) {
                        int size = datas.size();
                        for (int i = size - 1; i >= 0; --i) {
                            ImMessageDBBean item = (ImMessageDBBean)datas.get(i);
                            if (item == null) continue;
                            msgList.add(item.getContent());
                        }
                    }
                    ReportRequestManager.sendReportReq(ReportController.this.reportType + 1, ((ReportController)ReportController.this).reportOpenEvent.targetUserInfo.uid, ((ReportController)ReportController.this).reportOpenEvent.targetUserInfo.nick, ((ReportController)ReportController.this).reportOpenEvent.targetUserInfo.avatar, ((ReportController)ReportController.this).reportOpenEvent.myName, ReportController.this.uploadImgUrls, msgList, null, NetworkUtils.getMac((Context)RuntimeContext.sApplicationContext), NetworkUtils.getLocalIpAddress(), new ReportRequestManager.IReportReqCallback(){

                        @Override
                        public void onError(int errorType, Exception e) {
                            if (ReportController.this.reportOpenEvent != null && ((ReportController)ReportController.this).reportOpenEvent.deleteCaptureImgAfterReport && StringUtils.isNotEmpty((String)((ReportController)ReportController.this).reportOpenEvent.captureImgPath)) {
                                YYFileUtils.deleteFile((File)new File(((ReportController)ReportController.this).reportOpenEvent.captureImgPath));
                            }
                        }

                        @Override
                        public void onSuccess() {
                            if (ReportController.this.reportOpenEvent != null && ((ReportController)ReportController.this).reportOpenEvent.deleteCaptureImgAfterReport && StringUtils.isNotEmpty((String)((ReportController)ReportController.this).reportOpenEvent.captureImgPath)) {
                                YYFileUtils.deleteFile((File)new File(((ReportController)ReportController.this).reportOpenEvent.captureImgPath));
                            }
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ReportController.this.showSubmittedDialog(null);
                                }
                            });
                        }
                    });
                });
            }
        });
    }

    private void deleteDefaultCapture() {
        if (this.reportOpenEvent != null && this.reportOpenEvent.deleteCaptureImgAfterReport && StringUtils.isNotEmpty((String)this.reportOpenEvent.captureImgPath)) {
            YYFileUtils.deleteFile((File)new File(this.reportOpenEvent.captureImgPath));
        }
    }

    private String getImgPathFromUri(Uri uri) {
        if (uri == null) {
            return "";
        }
        String[] filePathColumn = new String[]{"_data"};
        Cursor cursor = this.getCurrentWindow().getContext().getContentResolver().query(uri, filePathColumn, null, null, null);
        cursor.moveToFirst();
        int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
        String picturePath = cursor.getString(columnIndex);
        cursor.close();
        return picturePath;
    }

    private void reportTextImage(int type, final ReportTextImageParam param, final Messenger replyTo) {
        MLog.info((Object)TAG, (String)"reportTextImage type %s, param %s", (Object[])new Object[]{type, param});
        UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(param.targetUid, null);
        UserInfoKS myInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        ReportRequestManager.sendReportReq(type, param.targetUid, userInfoKS.nick, userInfoKS.avatar, myInfo.nick, param.imgList, param.textList, param.audioList, NetworkUtils.getMac((Context)RuntimeContext.sApplicationContext), NetworkUtils.getLocalIpAddress(), new ReportRequestManager.IReportReqCallback(){

            @Override
            public void onError(int errorType, Exception e) {
                MLog.error((Object)ReportController.TAG, (String)"reportTextImage onError", (Throwable)e, (Object[])new Object[0]);
                this.onResponse(false);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)ReportController.this.mContext, (int)R.string.network_error, (int)0);
                    }
                });
            }

            private void onResponse(final boolean isSuccess) {
                MLog.info((Object)ReportController.TAG, (String)"reportTextImage onResponse %b", (Object[])new Object[]{isSuccess});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (replyTo != null) {
                                Message message = Message.obtain();
                                message.obj = isSuccess;
                                replyTo.send(message);
                            } else if (isSuccess) {
                                ReportController.this.showSubmittedDialog(param);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)ReportController.TAG, (Throwable)e);
                        }
                    }
                });
            }

            @Override
            public void onSuccess() {
                this.onResponse(true);
            }
        });
    }

    @UiThread
    private void showSubmittedDialog(ReportTextImageParam param) {
        MLog.info((Object)TAG, (String)"showSubmittedDialog", (Object[])new Object[0]);
        PunishToastDialog dialog = new PunishToastDialog(R.drawable.img_im_report_success);
        if (param != null && param.pageSource == 1) {
            dialog.setBlockType(2);
            dialog.setBlockListener(blockType -> ((IBlacklistService)this.getServiceManager().getService(IBlacklistService.class)).blackUid(param.targetUid, (INetRespCallback)new INetRespCallback<Object>(){

                public void onError(Call call, Exception e, int id2) {
                    ToastUtils.showToast((Context)ReportController.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                }

                public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                    if (res != null && res.isSuccess()) {
                        ToastUtils.showToast((Context)ReportController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_block_successful), (int)0);
                    }
                }
            }));
        }
        this.mDialogLinkManager.showFullscreenDialog((BaseDialog)dialog);
    }
}

