/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord.impl;

import android.media.MediaCodec;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.RequiresApi;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.AudioEncoder;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.BaseEncoder;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.RecordCallback;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.ScreenVideoEncoder;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.VideoMuxerWrapper;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder;", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$EncodeErrorCallback;", "()V", "audioEncoder", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/AudioEncoder;", "destroyed", "", "muxerWrapper", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper;", "recordCallback", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/RecordCallback;", "uiCallbackHandler", "Landroid/os/Handler;", "videoEncoder", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoEncoder;", "workHandler", "workHandlerThread", "Landroid/os/HandlerThread;", "ensureHandler", "", "init", "mediaService", "Lcom/yy/hiyo/channel/base/service/IMediaService;", "width", "", "height", "onEncodeError", "codec", "Landroid/media/MediaCodec;", "e", "", "prepareCaputrePermission", "release", "setEnableAudioTrace", "enableAudioTrace", "setRecordCallback", "callback", "startRecord", "file", "Ljava/io/File;", "stopRecord", "Companion", "WorkerHandler", "radio_debug"})
public final class ScreenVideoRecorder
implements BaseEncoder.EncodeErrorCallback {
    private ScreenVideoEncoder videoEncoder;
    private AudioEncoder audioEncoder;
    private VideoMuxerWrapper muxerWrapper;
    private HandlerThread workHandlerThread;
    private Handler workHandler;
    private Handler uiCallbackHandler;
    private RecordCallback recordCallback;
    private boolean destroyed;
    private static final String TAG = "ScreenVideoRecorder";
    private static final int WHAT_PREPARE = 1;
    private static final int WHAT_START = 2;
    private static final int WHAT_STOP = 3;
    private static final int WHAT_ERROR = 4;
    private static final int WHAT_RELEASE_MUXER = 5;
    private static final int WHAT_CALLBACK_PERMISSION_READY = 11;
    private static final int WHAT_CALLBACK_STARTED = 12;
    private static final int WHAT_CALLBACK_STOPED = 13;
    private static final int WHAT_CALLBACK_ERROR = 14;
    public static final Companion Companion = new Companion(null);

    public final void init(@NotNull IMediaService mediaService, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)mediaService, (String)"mediaService");
        if (Build.VERSION.SDK_INT >= 21) {
            this.videoEncoder = new ScreenVideoEncoder(width, height);
            this.audioEncoder = new AudioEncoder(mediaService);
            this.muxerWrapper = new VideoMuxerWrapper();
            AudioEncoder audioEncoder = this.audioEncoder;
            if (audioEncoder == null) {
                Intrinsics.throwNpe();
            }
            audioEncoder.setErrorCallback(this);
            ScreenVideoEncoder screenVideoEncoder = this.videoEncoder;
            if (screenVideoEncoder == null) {
                Intrinsics.throwNpe();
            }
            screenVideoEncoder.setErrorCallback(this);
            AudioEncoder audioEncoder2 = this.audioEncoder;
            if (audioEncoder2 == null) {
                Intrinsics.throwNpe();
            }
            audioEncoder2.setMVideoMuxer(this.muxerWrapper);
            ScreenVideoEncoder screenVideoEncoder2 = this.videoEncoder;
            if (screenVideoEncoder2 == null) {
                Intrinsics.throwNpe();
            }
            screenVideoEncoder2.setMVideoMuxer(this.muxerWrapper);
            ScreenVideoEncoder screenVideoEncoder3 = this.videoEncoder;
            if (screenVideoEncoder3 == null) {
                Intrinsics.throwNpe();
            }
            screenVideoEncoder3.init();
        }
    }

    public final void setRecordCallback(@NotNull RecordCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.recordCallback = callback2;
    }

    public final void setEnableAudioTrace(boolean enableAudioTrace) {
        VideoMuxerWrapper videoMuxerWrapper = this.muxerWrapper;
        if (videoMuxerWrapper != null) {
            videoMuxerWrapper.setMOnlyVideoTrace(!enableAudioTrace);
        }
        MLog.info((Object)TAG, (String)("setEnableAudioTrace " + enableAudioTrace), (Object[])new Object[0]);
    }

    public final void prepareCaputrePermission() {
        block0: {
            this.ensureHandler();
            Handler handler = this.workHandler;
            if (handler == null || (handler = handler.obtainMessage(1)) == null) break block0;
            handler.sendToTarget();
        }
    }

    @Override
    public void onEncodeError(@NotNull MediaCodec codec, @NotNull Throwable e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Handler handler = this.workHandler;
            if (handler == null || (handler = handler.obtainMessage(4, (Object)e)) == null) break block0;
            handler.sendToTarget();
        }
    }

    private final void ensureHandler() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (this.workHandlerThread == null) {
            HandlerThread handlerThread = this.workHandlerThread = new HandlerThread("ScreenRecorder");
            if (handlerThread != null) {
                handlerThread.start();
            }
        }
        if (this.workHandler == null) {
            HandlerThread handlerThread = this.workHandlerThread;
            if (handlerThread == null) {
                Intrinsics.throwNpe();
            }
            Looper looper = handlerThread.getLooper();
            Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"workHandlerThread!!.looper");
            this.workHandler = new WorkerHandler(this, looper);
        }
        AudioEncoder audioEncoder = this.audioEncoder;
        if (audioEncoder != null) {
            audioEncoder.setMHandler(this.workHandler);
        }
        if (this.uiCallbackHandler == null) {
            this.uiCallbackHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(this){
                final /* synthetic */ ScreenVideoRecorder this$0;

                public final boolean handleMessage(@NotNull Message it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    switch (it.what) {
                        case 11: {
                            RecordCallback recordCallback = ScreenVideoRecorder.access$getRecordCallback$p(this.this$0);
                            if (recordCallback != null) {
                                recordCallback.onPermissionReady();
                            }
                            break;
                        }
                        case 12: {
                            RecordCallback recordCallback = ScreenVideoRecorder.access$getRecordCallback$p(this.this$0);
                            if (recordCallback != null) {
                                recordCallback.onStartRecord();
                            }
                            break;
                        }
                        case 13: {
                            RecordCallback recordCallback = ScreenVideoRecorder.access$getRecordCallback$p(this.this$0);
                            if (recordCallback != null) {
                                recordCallback.onStopRecord();
                            }
                            break;
                        }
                        case 14: {
                            RecordCallback recordCallback = ScreenVideoRecorder.access$getRecordCallback$p(this.this$0);
                            if (recordCallback != null) {
                                recordCallback.onRecordError();
                            }
                            break;
                        }
                        default: {
                            MLog.error((Object)"ScreenVideoRecorder", (String)(" UNKNOWN CALLBACK Message " + it), (Object[])new Object[0]);
                        }
                    }
                    return true;
                }
                {
                    this.this$0 = screenVideoRecorder;
                }
            });
        }
    }

    public final void startRecord(@NotNull File file) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.ensureHandler();
            Handler handler = this.workHandler;
            if (handler == null || (handler = handler.obtainMessage(2, (Object)file)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void stopRecord() {
        block0: {
            this.ensureHandler();
            Handler handler = this.workHandler;
            if (handler == null || (handler = handler.obtainMessage(3)) == null) break block0;
            handler.sendToTarget();
        }
    }

    public final void release() {
        this.destroyed = true;
        this.recordCallback = null;
        if (Build.VERSION.SDK_INT >= 21) {
            ScreenVideoEncoder screenVideoEncoder = this.videoEncoder;
            if (screenVideoEncoder != null) {
                screenVideoEncoder.release();
            }
            this.videoEncoder = null;
            this.muxerWrapper = null;
            this.audioEncoder = null;
        }
        HandlerThread handlerThread = this.workHandlerThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        this.workHandlerThread = null;
        this.workHandler = null;
        this.uiCallbackHandler = null;
    }

    public static final /* synthetic */ void access$setDestroyed$p(ScreenVideoRecorder $this, boolean bl) {
        $this.destroyed = bl;
    }

    public static final /* synthetic */ void access$setVideoEncoder$p(ScreenVideoRecorder $this, ScreenVideoEncoder screenVideoEncoder) {
        $this.videoEncoder = screenVideoEncoder;
    }

    public static final /* synthetic */ void access$setUiCallbackHandler$p(ScreenVideoRecorder $this, Handler handler) {
        $this.uiCallbackHandler = handler;
    }

    public static final /* synthetic */ void access$setMuxerWrapper$p(ScreenVideoRecorder $this, VideoMuxerWrapper videoMuxerWrapper) {
        $this.muxerWrapper = videoMuxerWrapper;
    }

    public static final /* synthetic */ void access$setAudioEncoder$p(ScreenVideoRecorder $this, AudioEncoder audioEncoder) {
        $this.audioEncoder = audioEncoder;
    }

    public static final /* synthetic */ RecordCallback access$getRecordCallback$p(ScreenVideoRecorder $this) {
        return $this.recordCallback;
    }

    public static final /* synthetic */ void access$setRecordCallback$p(ScreenVideoRecorder $this, RecordCallback recordCallback) {
        $this.recordCallback = recordCallback;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder$WorkerHandler;", "Landroid/os/Handler;", "recorder", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder;", "looper", "Landroid/os/Looper;", "(Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder;Landroid/os/Looper;)V", "error", "", "e", "", "handleMessage", "msg", "Landroid/os/Message;", "prepare", "releaseMuxer", "", "start", "file", "Ljava/io/File;", "stop", "radio_debug"})
    @RequiresApi(value=21)
    public static final class WorkerHandler
    extends Handler {
        private final ScreenVideoRecorder recorder;

        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            int what = msg.what;
            switch (what) {
                case 1: {
                    this.prepare();
                    break;
                }
                case 2: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                    }
                    this.start((File)object);
                    break;
                }
                case 3: {
                    this.stop();
                    break;
                }
                case 4: {
                    this.error((Throwable)msg.obj);
                    break;
                }
                case 5: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    this.releaseMuxer((Boolean)object);
                    break;
                }
            }
        }

        private final void prepare() {
            if (this.recorder.destroyed) {
                return;
            }
            ScreenVideoEncoder screenVideoEncoder = this.recorder.videoEncoder;
            if (screenVideoEncoder == null) {
                Intrinsics.throwNpe();
            }
            screenVideoEncoder.prepareCapturePermission(new Runnable(this){
                final /* synthetic */ WorkerHandler this$0;

                public final void run() {
                    block0: {
                        Handler handler = ScreenVideoRecorder.access$getUiCallbackHandler$p(WorkerHandler.access$getRecorder$p(this.this$0));
                        if (handler == null) break block0;
                        handler.sendEmptyMessage(11);
                    }
                }
                {
                    this.this$0 = workerHandler;
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        private final void start(File file) {
            if (ScreenVideoRecorder.access$getDestroyed$p(this.recorder)) {
                return;
            }
            v0 = ScreenVideoRecorder.access$getMuxerWrapper$p(this.recorder);
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            v0.prepareMuxer(file);
            exception = null;
            try {
                v1 = ScreenVideoRecorder.access$getVideoEncoder$p(this.recorder);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (!v1.startRecord()) ** GOTO lbl-1000
                v2 = ScreenVideoRecorder.access$getMuxerWrapper$p(this.recorder);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                if (v2.getMOnlyVideoTrace()) ** GOTO lbl-1000
                v3 = ScreenVideoRecorder.access$getAudioEncoder$p(this.recorder);
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                if (v3.startRecord()) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                var4_3 = v4;
            }
            catch (Throwable tr) {
                exception = tr;
                var4_3 = false;
            }
            result = var4_3;
            if (result) {
                v5 = ScreenVideoRecorder.access$getUiCallbackHandler$p(this.recorder);
                if (v5 != null) {
                    v5.sendEmptyMessage(12);
                }
            } else {
                v6 = exception;
                if (v6 == null) {
                    v6 = new RuntimeException("Start Failed");
                }
                this.error(v6);
            }
        }

        private final void stop() {
            ScreenVideoEncoder screenVideoEncoder = this.recorder.videoEncoder;
            if (screenVideoEncoder != null) {
                screenVideoEncoder.stop();
            }
            AudioEncoder audioEncoder = this.recorder.audioEncoder;
            if (audioEncoder != null) {
                audioEncoder.stop();
            }
            this.obtainMessage(5, false).sendToTarget();
        }

        private final void error(Throwable e) {
            Handler handler;
            ScreenVideoEncoder screenVideoEncoder = this.recorder.videoEncoder;
            if (screenVideoEncoder != null) {
                screenVideoEncoder.stop();
            }
            AudioEncoder audioEncoder = this.recorder.audioEncoder;
            if (audioEncoder != null) {
                audioEncoder.stop();
            }
            if ((handler = this.recorder.uiCallbackHandler) != null && (handler = handler.obtainMessage(14, (Object)e)) != null) {
                handler.sendToTarget();
            }
            this.obtainMessage(5, true).sendToTarget();
            MLog.error((Object)ScreenVideoRecorder.TAG, (String)"onError", (Throwable)e, (Object[])new Object[0]);
        }

        private final void releaseMuxer(boolean error) {
            block2: {
                block3: {
                    boolean result = false;
                    if (this.recorder.muxerWrapper != null) {
                        VideoMuxerWrapper videoMuxerWrapper = this.recorder.muxerWrapper;
                        if (videoMuxerWrapper == null) {
                            Intrinsics.throwNpe();
                        }
                        result = videoMuxerWrapper.releaseMuxer();
                    }
                    if (error) break block2;
                    if (!result) break block3;
                    Handler handler = this.recorder.uiCallbackHandler;
                    if (handler == null) break block2;
                    handler.sendEmptyMessage(13);
                    break block2;
                }
                Handler handler = this.recorder.uiCallbackHandler;
                if (handler == null || (handler = handler.obtainMessage(14, (Object)new IllegalStateException(" Release Muxer Failed!"))) == null) break block2;
                handler.sendToTarget();
            }
        }

        public WorkerHandler(@NotNull ScreenVideoRecorder recorder, @NotNull Looper looper) {
            Intrinsics.checkParameterIsNotNull((Object)recorder, (String)"recorder");
            Intrinsics.checkParameterIsNotNull((Object)looper, (String)"looper");
            super(looper);
            this.recorder = recorder;
        }

        public static final /* synthetic */ ScreenVideoRecorder access$getRecorder$p(WorkerHandler $this) {
            return $this.recorder;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/ScreenVideoRecorder$Companion;", "", "()V", "TAG", "", "WHAT_CALLBACK_ERROR", "", "WHAT_CALLBACK_PERMISSION_READY", "WHAT_CALLBACK_STARTED", "WHAT_CALLBACK_STOPED", "WHAT_ERROR", "WHAT_PREPARE", "WHAT_RELEASE_MUXER", "WHAT_START", "WHAT_STOP", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

