/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio;

import android.view.Window;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.unifyconfig.config.RadioLiveConfig;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.edge.GetScreenCaptureLimitReq;
import net.ihago.channel.srv.edge.GetScreenCaptureLimitRes;
import net.ihago.channel.srv.edge.SetScreenCaptureLimitReq;
import net.ihago.channel.srv.edge.SetScreenCaptureLimitRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000f0\u000eJ\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/SecureScreenUtils;", "", "()V", "TAG", "", "requestSecureScreen", "", "enable", "", "requestSecureScreenConfig", "uids", "", "", "callback", "Lcom/yy/appbase/callback/ICommonCallback;", "", "secureScreen", "window", "Landroid/view/Window;", "radio_debug"})
public final class SecureScreenUtils {
    private static final String TAG = "SecureScreenUtils";
    public static final SecureScreenUtils INSTANCE;

    public final void secureScreen(@NotNull Window window, boolean enable) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        MLog.info((Object)TAG, (String)("secureScreen " + enable), (Object[])new Object[0]);
        if (RadioLiveConfig.Companion.secureScreenFeatureEnable()) {
            if (enable) {
                window.setFlags(8192, 8192);
            } else {
                window.clearFlags(8192);
            }
        }
    }

    public final void requestSecureScreen(boolean enable) {
        SetScreenCaptureLimitReq req = new SetScreenCaptureLimitReq.Builder().is_forbidden(Boolean.valueOf(enable)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<SetScreenCaptureLimitRes>(){

            public void onResponse(@NotNull SetScreenCaptureLimitRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"SecureScreenUtils", (String)"requestSecureScreen success", (Object[])new Object[0]);
                } else {
                    MLog.info((Object)"SecureScreenUtils", (String)("requestSecureScreen fail code[" + code + ']'), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"SecureScreenUtils", (String)("requestSecureScreen onError code[" + code + ']'), (Object[])new Object[0]);
            }
        });
    }

    public final void requestSecureScreenConfig(@NotNull List<Long> uids, @NotNull ICommonCallback<Map<Long, Boolean>> callback2) {
        Intrinsics.checkParameterIsNotNull(uids, (String)"uids");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        GetScreenCaptureLimitReq req = new GetScreenCaptureLimitReq.Builder().uids(uids).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetScreenCaptureLimitRes>(callback2){
            final /* synthetic */ ICommonCallback $callback;

            public void onResponse(@NotNull GetScreenCaptureLimitRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"SecureScreenUtils", (String)("requestSecureScreenConfig success " + res.limit_infos), (Object[])new Object[0]);
                    this.$callback.onSuccess((Object)res.limit_infos, new Object[0]);
                } else {
                    this.$callback.onFail((int)code, msgTip, new Object[0]);
                    MLog.info((Object)"SecureScreenUtils", (String)("requestSecureScreenConfig fail code[" + code + ']'), (Object[])new Object[0]);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.onFail(code, reason, new Object[0]);
                MLog.error((Object)"SecureScreenUtils", (String)("requestSecureScreenConfig onError code[" + code + ']'), (Object[])new Object[0]);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    private SecureScreenUtils() {
    }

    static {
        SecureScreenUtils secureScreenUtils;
        INSTANCE = secureScreenUtils = new SecureScreenUtils();
    }
}

