/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat.warpper;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.warpper.IWrapperHandler;
import java.util.List;
import okhttp3.Call;

public abstract class BaseRadioSeatViewWrapper
implements ISeatViewWrapper,
IWrapperHandler {
    private RadioSeatPresenter.OnAnchorSeatChangedListener mShowLiveEndPageListener;
    protected IEnteredChannel mChannel;

    BaseRadioSeatViewWrapper(RadioSeatPresenter.OnAnchorSeatChangedListener listener2, IEnteredChannel channel) {
        this.mShowLiveEndPageListener = listener2;
        this.mChannel = channel;
    }

    public void updateSeats(List<SeatItem> seatItems) {
        if (!FP.empty(seatItems)) {
            this.updateSeatAnchorChanged(seatItems.get(0));
        } else {
            this.updateSeatAnchorChanged(null);
        }
        this.setLogo();
    }

    public void updateSeat(int position, SeatItem data) {
        if (position == 0) {
            this.updateSeatAnchorChanged(data);
            this.setLogo();
        }
    }

    @Override
    public long getShowingUid() {
        ChannelDetailInfo detailInfo = this.mChannel.getDataService().getChannelDetailInfo(null);
        if (null == detailInfo) {
            return 0L;
        }
        if (detailInfo.baseInfo.isGroupParty() && 0L != detailInfo.baseInfo.showUid) {
            return detailInfo.baseInfo.showUid;
        }
        return detailInfo.baseInfo.ownerUid;
    }

    @Override
    public String getPostToken() {
        if (!FP.empty((CharSequence)this.mChannel.getEnterParam().postToken)) {
            return this.mChannel.getEnterParam().postToken;
        }
        return "";
    }

    @Override
    public String getPostId() {
        if (!FP.empty((CharSequence)this.mChannel.getEnterParam().postId)) {
            return this.mChannel.getEnterParam().postId;
        }
        return "";
    }

    @Override
    public String getPostPgSource() {
        if (!FP.empty((CharSequence)this.mChannel.getEnterParam().postPageSource)) {
            return this.mChannel.getEnterParam().postPageSource;
        }
        return "";
    }

    private void updateSeatAnchorChanged(SeatItem data) {
        if (this.mShowLiveEndPageListener == null) {
            return;
        }
        if (data == null || data.uid == 0L) {
            this.mShowLiveEndPageListener.onSeatAnchorChanged(0L);
        } else {
            this.mShowLiveEndPageListener.onSeatAnchorChanged(data.uid);
        }
    }

    private void setLogo() {
        if (ServiceManagerProxy.getServiceManager() == null) {
            return;
        }
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(this.getShowingUid());
        if (userInfoKS.ver > 0L) {
            this.doSetLogo(userInfoKS);
        } else {
            ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).requestUserInfoFromServer(this.getShowingUid(), new OnKSProfileListCallback(){

                public void onUISuccess(List<UserInfoKS> userInfo) {
                    if (userInfo == null || userInfo.isEmpty()) {
                        return;
                    }
                    BaseRadioSeatViewWrapper.this.doSetLogo(userInfo.get(0));
                }

                public void onError(String reason, long code) {
                }
            });
        }
    }

    private void doSetLogo(UserInfoKS userInfoBean) {
        if (ServiceManagerProxy.getServiceManager() == null) {
            return;
        }
        this.setAvatar(userInfoBean);
        ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(userInfoBean.uid, new OnGetHeadFrameCallback(){

            public void onGetHeadFrameSuccess(List<Integer> list) {
                if (FP.empty(list)) {
                    return;
                }
                if (list.get(0) == 0) {
                    BaseRadioSeatViewWrapper.this.setAvatarFrame(null);
                    return;
                }
                String frameUrl = ((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(list.get(0).intValue());
                if (TextUtils.isEmpty((CharSequence)frameUrl)) {
                    BaseRadioSeatViewWrapper.this.setAvatarFrame(null);
                    return;
                }
                BaseRadioSeatViewWrapper.this.setAvatarFrame(frameUrl);
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    protected void setAvatarFrame(String frameUrl) {
        if (this.mShowLiveEndPageListener != null) {
            this.mShowLiveEndPageListener.onUpdateAvatarFrame(frameUrl);
        }
    }

    protected void setAvatar(UserInfoKS userInfoBean) {
        if (userInfoBean != null && this.mShowLiveEndPageListener != null) {
            this.mShowLiveEndPageListener.onUpdateUserInfo(userInfoBean);
        }
    }

    public void createView(Context context, ViewGroup parent) {
    }

    public void setOnLayoutChangeListener(View.OnLayoutChangeListener listener2) {
    }

    public void startSpeakingAnimation(int position) {
    }

    public void stopSpeakingAnimation(int position) {
    }

    public void setVisibility(int visibility) {
    }

    public int getVisibility() {
        return 0;
    }

    public View getRealSeatView() {
        return null;
    }

    public void destroy() {
    }

    public void setPresenter(@NonNull SeatMvp.IPresenter presenter) {
    }

    @Nullable
    public View getItemView(int index) {
        return null;
    }

    @Override
    public void checkFansClubEntryOrHideButton() {
    }

    @Override
    public void clickFansClub() {
    }
}

