/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.sticker.list;

import android.content.Context;
import android.text.TextUtils;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.plugins.radio.sticker.StickerModel;
import com.yy.hiyo.channel.plugins.radio.sticker.base.StickerInfo;
import com.yy.hiyo.channel.plugins.radio.sticker.callback.IApplyStickerCallback;
import com.yy.hiyo.channel.plugins.radio.sticker.list.IStickerListPresenter;
import com.yy.hiyo.channel.plugins.radio.sticker.list.IStickerListView;
import com.yy.hiyo.channel.plugins.radio.sticker.list.StickerListPanel;
import com.yy.hiyo.mvp.base.PageMvpContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.omega.api.stickies.ErrCode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/list/StickerListPresenter;", "Lcom/yy/appbase/core/DefaultController;", "Lcom/yy/hiyo/channel/plugins/radio/sticker/list/IStickerListPresenter;", "environment", "Lcom/yy/framework/core/Environment;", "model", "Lcom/yy/hiyo/channel/plugins/radio/sticker/StickerModel;", "(Lcom/yy/framework/core/Environment;Lcom/yy/hiyo/channel/plugins/radio/sticker/StickerModel;)V", "mLifecycleOwner", "Lcom/yy/hiyo/mvp/base/PageMvpContext;", "mListPanel", "Lcom/yy/hiyo/channel/plugins/radio/sticker/list/IStickerListView;", "mModel", "onPanelHidden", "", "onPanelShown", "onStickerClick", "info", "Lcom/yy/hiyo/channel/plugins/radio/sticker/base/StickerInfo;", "showPanel", "window", "Lcom/yy/hiyo/channel/cbase/AbsChannelWindow;", "Companion", "radio_debug"})
public final class StickerListPresenter
extends DefaultController
implements IStickerListPresenter {
    private final StickerModel mModel;
    private IStickerListView mListPanel;
    private PageMvpContext mLifecycleOwner;
    private static final String TAG = "Sticker_StickerListPresenter";
    public static final Companion Companion = new Companion(null);

    public final void showPanel(@NotNull AbsChannelWindow window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        if (this.mListPanel == null) {
            Context context = this.mContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
            this.mListPanel = new StickerListPanel(context, this);
        }
        IStickerListView iStickerListView = this.mListPanel;
        if (iStickerListView == null) {
            Intrinsics.throwNpe();
        }
        iStickerListView.showPanel(window);
        this.mModel.fetchStickerList();
    }

    @Override
    public void onPanelHidden() {
        this.mLifecycleOwner.onDestroy();
    }

    @Override
    public void onPanelShown() {
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        this.mLifecycleOwner = PageMvpContext.Companion.of$default((PageMvpContext.Companion)PageMvpContext.Companion, (Context)context, null, (int)2, null);
        this.mModel.getStickerListLiveData().observe((LifecycleOwner)this.mLifecycleOwner, (Observer)new Observer<List<StickerInfo>>(this){
            final /* synthetic */ StickerListPresenter this$0;

            public final void onChanged(List<StickerInfo> it) {
                block1: {
                    IStickerListView iStickerListView = StickerListPresenter.access$getMListPanel$p(this.this$0);
                    if (iStickerListView == null) break block1;
                    List list = it;
                    if (list == null) {
                        IStickerListView iStickerListView2 = iStickerListView;
                        boolean bl = false;
                        List list2 = new ArrayList<E>();
                        iStickerListView = iStickerListView2;
                        list = list2;
                    }
                    iStickerListView.updateList(list);
                }
            }
            {
                this.this$0 = stickerListPresenter;
            }
        });
    }

    @Override
    public void onStickerClick(@NotNull StickerInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        MLog.info((Object)TAG, (String)("onStickerClick, current sticker count = " + FP.size((Map)((Map)this.mModel.getCurrentStickersLiveData().getValue())) + ", info=" + info), (Object[])new Object[0]);
        if (FP.size((Map)((Map)this.mModel.getCurrentStickersLiveData().getValue())) >= 3) {
            IStickerListView iStickerListView = this.mListPanel;
            if (iStickerListView != null) {
                iStickerListView.showLimitToast();
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)info.getPosition())) {
                info.setPosition("25_150");
            }
            this.mModel.applySticker(info, new IApplyStickerCallback(this){
                final /* synthetic */ StickerListPresenter this$0;

                public void onError(int code) {
                    block1: {
                        if (code != ErrCode.MAX_STICKY_NUM.getValue()) break block1;
                        IStickerListView iStickerListView = StickerListPresenter.access$getMListPanel$p(this.this$0);
                        if (iStickerListView != null) {
                            iStickerListView.showLimitToast();
                        }
                    }
                }

                public void onSuccess(@NotNull StickerInfo sticker) {
                    Intrinsics.checkParameterIsNotNull((Object)sticker, (String)"sticker");
                    RadioUtils.INSTANCE.reportStickerShow(String.valueOf(sticker.getId()));
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        RadioUtils.INSTANCE.reportStickerClick(info.getId());
    }

    public StickerListPresenter(@NotNull Environment environment, @NotNull StickerModel model2) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        super(environment);
        this.mModel = model2;
        Context context = this.mContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"mContext");
        this.mLifecycleOwner = PageMvpContext.Companion.of$default((PageMvpContext.Companion)PageMvpContext.Companion, (Context)context, null, (int)2, null);
    }

    public static final /* synthetic */ IStickerListView access$getMListPanel$p(StickerListPresenter $this) {
        return $this.mListPanel;
    }

    public static final /* synthetic */ void access$setMListPanel$p(StickerListPresenter $this, IStickerListView iStickerListView) {
        $this.mListPanel = iStickerListView;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/sticker/list/StickerListPresenter$Companion;", "", "()V", "TAG", "", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

